/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.types;

import java.util.ArrayList;
import java.util.Collection;
import java.util.SortedMap;
import javax.swing.ListModel;
import oracle.bpm.collections.Sequence;
import oracle.bpm.designer.action.NewBpmObjectAction;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.types.CatalogObjectLabelProvider;
import oracle.bpm.designer.types.TypeItem;
import oracle.bpm.designer.types.TypePanel;
import oracle.bpm.draw.Color;
import oracle.bpm.project.CatalogObjectImpl;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectContainer;
import oracle.bpm.project.model.catalog.CatalogObject;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.view.filter.ProjectFilter;
import oracle.bpm.resources.Msg;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.TypeRef;
import oracle.bpm.ui.Box;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.List;
import oracle.bpm.ui.MutableListListModel;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.ActionListener;
import oracle.bpm.ui.event.CustomEvent;
import oracle.bpm.ui.event.KeyAdapter;
import oracle.bpm.ui.event.KeyEvent;
import oracle.bpm.ui.event.KeyListener;
import oracle.bpm.ui.event.ListSelectionEvent;
import oracle.bpm.ui.event.ListSelectionListener;
import oracle.bpm.ui.event.MouseAdapter;
import oracle.bpm.ui.event.MouseEvent;
import oracle.bpm.ui.event.MouseListener;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.text.TextField;

class ComponentPanel
extends TypePanel {
    private List<CatalogObject> componentList;
    private TextField findField;
    private CatalogObjectListModel mutableListListModel;
    private final Project project;
    private final ProjectFilter projectFilter;
    private Label statusField;

    public ComponentPanel(UiContainer parent, Project project, ProjectFilter projectFilter) {
        super(parent, DesignerMsg.TYPES_COMPONENT);
        this.project = project;
        this.projectFilter = projectFilter;
    }

    public boolean isSelectionOk() {
        return true;
    }

    @Override
    public boolean isValidType() {
        return this.isSelectionOk();
    }

    public void requestFocus() {
        this.findField.requestFocus();
    }

    public void objectSelected() {
        CatalogObject value;
        String detail = "";
        if (this.isSelectionOk() && (value = (CatalogObject)this.componentList.getSelectedValue()) != null) {
            TypeItem typeItem = this.getTypeItem();
            typeItem.setRef((CatalogType)value);
            detail = value.getText();
            this.fireCustomEventChanged(new CustomEvent("oracle.bpm.designer.types.TypeItem", (Object)typeItem, null, (UiComponent)this));
        }
        this.statusField.setText(detail);
    }

    public void ok() {
        if (this.isSelectionOk()) {
            this.objectSelected();
        }
    }

    public ProjectFilter getProjectFilter() {
        return this.projectFilter;
    }

    @Override
    protected void initialize() {
        this.setLayout((Layout)new BorderLayout());
        Panel panel = new Panel((UiContainer)this);
        this.mutableListListModel = new CatalogObjectListModel(this.project, this.projectFilter);
        this.componentList = new List((UiContainer)panel, (ListModel)((Object)this.mutableListListModel));
        this.componentList.setLabelProvider((LabelProvider)new CatalogObjectLabelProvider());
        this.componentList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                CatalogObject value = (CatalogObject)ComponentPanel.this.componentList.getSelectedValue();
                if (value != null) {
                    ComponentPanel.this.ok();
                }
            }
        });
        this.componentList.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                ComponentPanel.this.ok();
            }

            public void mouseDoubleClicked(MouseEvent e) {
                ComponentPanel.this.ok();
            }
        });
        ComponentCatalog componentCatalog = this.getTypeCatalog();
        assert (componentCatalog != null) : "ConfigType Catalog cannot be null";
        Panel findPanel = new Panel((UiContainer)panel);
        findPanel.setLayout((Layout)new BorderLayout(5, 5));
        this.findField = new TextField((UiContainer)findPanel);
        findPanel.add((UiComponent)Label.create((UiContainer)findPanel, (Msg)DesignerMsg.FIND), (Object)"West");
        findPanel.add((UiComponent)this.findField, (Object)"Center");
        this.findField.addKeyListener((KeyListener)new AutocompleteKeyAdapter(this.findField));
        Button newBPMObjectButton = Button.createIconic((UiContainer)findPanel, (Msg)UIMsg.NEW);
        newBPMObjectButton.addActionListener((ActionListener)new NewBpmObjectAction(this.project.getCatalogRoot()){

            @Override
            public boolean doIt() {
                boolean result = super.doIt();
                if (result) {
                    ComponentPanel.this.mutableListListModel.reset();
                }
                return result;
            }
        });
        findPanel.add((UiComponent)newBPMObjectButton, (Object)"East");
        panel.setLayout((Layout)new BorderLayout(5, 5));
        panel.add((UiComponent)findPanel, (Object)"North");
        panel.add(this.componentList, (Object)"Center");
        panel.add((UiComponent)this.buildStatusPanel(panel), (Object)"South");
        this.add((UiComponent)panel, "Center");
        if (this.componentList.getVisibleRowCount() > 0) {
            this.componentList.setSelectedIndex(0);
        }
        this.setInitialized(true);
        this.updateDefaults();
    }

    @Override
    protected void updateDefaults() {
        TypeItem typeItem = this.getTypeItem();
        CatalogType typeRef = typeItem.getRef();
        if (typeRef != null) {
            this.selectComponent();
        }
    }

    private Panel buildStatusPanel(Panel container) {
        Panel panel = new Panel((UiContainer)container);
        panel.setLayout((Layout)new BorderLayout());
        panel.add(Box.createHorizontalStrut((UiContainer)panel, (int)10), (Object)"East");
        panel.add(Box.createHorizontalStrut((UiContainer)panel, (int)10), (Object)"West");
        this.statusField = Label.create((UiContainer)container);
        this.statusField.setForeground(Color.GRAY);
        this.statusField.setText(" ");
        panel.add((UiComponent)this.statusField, (Object)"Center");
        return panel;
    }

    private void selectComponent() {
        TypeItem typeItem1 = this.getTypeItem();
        this.firePropertyChange("oracle.bpm.designer.types.TypeItem", null, typeItem1);
    }

    private class AutocompleteKeyAdapter
    extends KeyAdapter {
        private final TextField field;

        public AutocompleteKeyAdapter(TextField field) {
            this.field = field;
        }

        public void keyReleased(KeyEvent e) {
            if (e.isUndefined() || e.isControlDown() || e.isActionKey()) {
                return;
            }
            if (e.isEnter()) {
                ComponentPanel.this.ok();
                return;
            }
            String input = this.field.getText();
            if (e.isBackSpace() || e.isDelete()) {
                int caretPosition = this.field.getCaretPosition();
                this.field.setText(input);
                this.field.setCaretPosition(caretPosition);
            }
            this.field.setForeground(Color.BLACK);
            if (input.length() > 0) {
                SortedMap<String, ? extends TypeRef> map = ComponentPanel.this.project.getComponentCatalog().findByPartialName(input);
                Collection<? extends TypeRef> typeRefs = map.values();
                if (typeRefs.isEmpty()) {
                    this.field.setForeground(Color.RED);
                    ComponentPanel.this.mutableListListModel.reset();
                } else {
                    ComponentPanel.this.mutableListListModel.removeAllElements();
                    for (TypeRef typeRef : typeRefs) {
                        ComponentPanel.this.mutableListListModel.addElement(typeRef);
                    }
                    if (ComponentPanel.this.mutableListListModel.getSize() > 0) {
                        ComponentPanel.this.componentList.setSelectedIndex(0);
                    }
                }
            } else {
                ComponentPanel.this.mutableListListModel.reset();
            }
        }
    }

    private static class CatalogObjectListModel
    extends MutableListListModel {
        private final Project project;
        private final ProjectFilter projectFilter;
        private static final long serialVersionUID = 1511192608846770760L;

        public CatalogObjectListModel(Project project, ProjectFilter projectFilter) {
            super(new ArrayList());
            this.project = project;
            this.projectFilter = projectFilter;
            this.fillFullList();
        }

        public void addElement(TypeRef ref) {
            CatalogObject catalogObject = CatalogObjectImpl.create((Project)this.project, (TypeRef)ref);
            if (this.getCatalogObjects().contains(catalogObject)) {
                this.addElement(catalogObject);
            }
        }

        public void removeElement(TypeRef ref) {
            CatalogObject catalogObject = CatalogObjectImpl.create((Project)this.project, (TypeRef)ref);
            this.removeElement(catalogObject);
        }

        public ProjectFilter getProjectFilter() {
            return this.projectFilter;
        }

        public void reset() {
            this.fillFullList();
        }

        private void fillFullList() {
            this.removeAllElements();
            for (ProjectObject projectObject : this.getCatalogObjects()) {
                this.addElement(projectObject);
            }
        }

        private Sequence<? extends ProjectObject> getCatalogObjects() {
            return this.projectFilter.getChildren((ProjectObjectContainer)this.project.getCatalogRoot());
        }
    }
}

