/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.tree.folder.actions;

import java.io.File;
import oracle.bpm.designer.DesignerAction;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.lang.exception.ReadOnlyException;
import oracle.bpm.log.Log;
import oracle.bpm.project.model.Container;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectWriter;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.fojsp.WebContentType;
import oracle.bpm.project.model.resources.Resource;
import oracle.bpm.project.model.resources.ResourcesContainer;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.filechooser.FileChooser;
import oracle.bpm.util.FileUtils;

public class ImportResourcesAction
extends DesignerAction {
    public ImportResourcesAction() {
        super(DesignerMsg.IMPORT_RESOURCES);
        this.requires(ResourcesContainer.class);
    }

    @Override
    public boolean doIt() {
        boolean result = false;
        FileChooser fileChooser = new FileChooser();
        this.addFilters(fileChooser);
        int status = fileChooser.showOpenDialog((UiComponent)Ui.getRoot(), 1);
        File[] filesToCopy = fileChooser.getSelectedFiles();
        if (status == 0) {
            try {
                this.addFiles(filesToCopy);
                result = true;
            }
            catch (ReadOnlyException e) {
                throw e;
            }
            catch (Exception e) {
                Log.logInfo(e);
                result = false;
            }
        }
        return result;
    }

    public void addFiles(File[] filesSelected) {
        for (File fileSelected : filesSelected) {
            if (!this.fileAlreadyImported(fileSelected)) {
                this.addFileSelected(fileSelected);
                continue;
            }
            if (!this.wantOverride()) continue;
            this.overrideFile(fileSelected);
        }
    }

    protected void addFilters(FileChooser fileChooser) {
    }

    private boolean fileAlreadyImported(File fileSelected) {
        ResourcesContainer.Mutable parent = ((ResourcesContainer.Mutable)this.getSelection().as(ResourcesContainer.Mutable.class)).asMutable();
        String fileExtension = FileUtils.getExtension(fileSelected);
        String fileName = FileUtils.getName(fileSelected);
        return parent.findResource(fileName, WebContentType.valueOfFileExtension((String)fileExtension)) != null;
    }

    private void addFileSelected(File fileSelected) {
        String fileName = FileUtils.getName(fileSelected);
        ResourcesContainer.Mutable parent = ((ResourcesContainer.Mutable)this.getSelection().as(ResourcesContainer.Mutable.class)).asMutable();
        try {
            if (fileSelected.isDirectory()) {
                Container.Mutable folder = parent.createContainer(fileName);
                parent.addContainer((Container)folder);
            } else {
                Resource.Mutable resource = this.createResource(fileSelected);
                parent.addResource((Resource)resource);
            }
        }
        catch (ProjectException e) {
            MessageDialog.showError((Throwable)e);
        }
    }

    private boolean wantOverride() {
        int answer = MessageDialog.showQuestion((UiContainer)null, (Msg)DesignerMsg.FILE_ALREADY_IMPORTED, (Msg)DesignerMsg.FILE_ALREADY_IMPORTED_MSG, null, (int)6, null);
        return answer == 2;
    }

    private void overrideFile(File fileSelected) {
        try {
            ResourcesContainer.Mutable parent = ((ResourcesContainer.Mutable)this.getSelection().as(ResourcesContainer.Mutable.class)).asMutable();
            ProjectWriter writer = parent.getProject().getWriter();
            writer.write(new ProjectObject[]{this.createResource(fileSelected)});
        }
        catch (ProjectException e) {
            MessageDialog.showError((Throwable)e);
        }
    }

    private Resource.Mutable createResource(File fileSelected) {
        String fileExtension = FileUtils.getExtension(fileSelected);
        String fileName = FileUtils.getName(fileSelected);
        ResourcesContainer.Mutable parent = ((ResourcesContainer.Mutable)this.getSelection().as(ResourcesContainer.Mutable.class)).asMutable();
        Resource.Mutable resource = parent.createResource(fileName, WebContentType.valueOfFileExtension((String)fileExtension));
        resource.setSourceDir(fileSelected.getPath());
        return resource;
    }
}

