/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.tree.folder.actions;

import oracle.bpm.designer.DesignerAction;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.tree.folder.AbstractFolderTreeNode;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.resources.Resource;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.msg.UIMsg;

public class DeleteResourceNodeAction
extends DesignerAction {
    private AbstractFolderTreeNode abstractWebNode;

    public DeleteResourceNodeAction(AbstractFolderTreeNode abstractWebNode) {
        super(UIMsg.MENU_DELETE);
        this.requires(Resource.class);
        this.abstractWebNode = abstractWebNode;
    }

    @Override
    public boolean doIt() {
        try {
            Resource resource = (Resource)this.getSelection().as(Resource.class);
            resource.getParent().asMutable().removeResource(resource);
        }
        catch (ProjectException e) {
            MessageDialog.showError((Msg)DesignerMsg.ERROR_DELETING_FILE, (Throwable)e);
            return false;
        }
        return true;
    }

    public void unDoIt() {
    }
}

