/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.tree.folder;

import oracle.bpm.designer.ProjectObjectTreeNode;
import oracle.bpm.designer.ResourceFolderNode;
import oracle.bpm.designer.fojsp.tree.CSSResourceNode;
import oracle.bpm.designer.fojsp.tree.HTMLResourceNode;
import oracle.bpm.designer.fojsp.tree.ImageResourceNode;
import oracle.bpm.designer.fojsp.tree.JSPNode;
import oracle.bpm.designer.fojsp.tree.UnknownContentNode;
import oracle.bpm.designer.fojsp.tree.WsdlResourceNode;
import oracle.bpm.designer.fojsp.tree.XsdResourceNode;
import oracle.bpm.project.model.Container;
import oracle.bpm.project.model.resources.ResourceObject;
import oracle.bpm.project.model.resources.ResourcesContainer;
import oracle.bpm.ui.tree.TreeNode;

public class TreeNodeFactory {
    public static TreeNode create(ResourceObject webRootObject, ResourceFolderNode parent) {
        ProjectObjectTreeNode result = null;
        switch (webRootObject.getType()) {
            case CSS: {
                result = new CSSResourceNode(webRootObject);
                break;
            }
            case JSP: {
                result = new JSPNode(webRootObject);
                break;
            }
            case JSPF: {
                result = new JSPNode(webRootObject);
                break;
            }
            case JSF: {
                result = new JSPNode(webRootObject);
                break;
            }
            case XHTML: {
                result = new JSPNode(webRootObject);
                break;
            }
            case HTML: {
                result = new HTMLResourceNode(webRootObject);
                break;
            }
            case HTM: {
                result = new HTMLResourceNode(webRootObject);
                break;
            }
            case GIF: {
                result = new ImageResourceNode(webRootObject);
                break;
            }
            case PNG: {
                result = new ImageResourceNode(webRootObject);
                break;
            }
            case JPG: {
                result = new ImageResourceNode(webRootObject);
                break;
            }
            case WSDL: {
                result = new WsdlResourceNode(webRootObject);
                break;
            }
            case XSD: {
                result = new XsdResourceNode(webRootObject);
                break;
            }
            case UNKNOWN: {
                result = new UnknownContentNode(webRootObject);
                break;
            }
            case FOLDER: {
                result = new ResourceFolderNode((Container)((ResourcesContainer)webRootObject));
                ((ResourceFolderNode)result).setAllowedContent(parent.getAllowedContent());
            }
        }
        return result;
    }
}

