/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.tree.folder;

import oracle.bpm.designer.dialog.AbstractDialog;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.validator.CompositeValidator;
import oracle.bpm.designer.validator.webroot.ContainerExistenceValidator;
import oracle.bpm.project.model.Container;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.resources.ResourcesContainer;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.text.TextField;
import oracle.bpm.ui.text.ValidFileTextField;

public class ResourceContainerDialog
extends AbstractDialog<ResourcesContainer> {
    private ResourcesContainer parentContainer;

    public ResourceContainerDialog(UiWindow parent, ResourcesContainer parentContainer) {
        super(parent, parentContainer.getProject());
        this.parentContainer = parentContainer;
    }

    @Override
    protected ResourcesContainer createNewProjectObject(String ResourcesContainerId) throws ProjectException {
        return (ResourcesContainer)this.parentContainer.asMutable().createContainer(ResourcesContainerId);
    }

    @Override
    protected ResourcesContainer addNewProjectObject(ResourcesContainer ResourcesContainer2) throws ProjectException {
        this.parentContainer.asMutable().addContainer((Container)ResourcesContainer2);
        return ResourcesContainer2;
    }

    @Override
    protected TextField createNameTextField(Panel panel) {
        return new ValidFileTextField((UiContainer)panel, "", 0, 128);
    }

    @Override
    protected void addValidators(CompositeValidator compositeValidator) {
        compositeValidator.addValidator(new ContainerExistenceValidator(this.getProject(), (Container)this.parentContainer));
    }

    @Override
    protected Msg getTitleMsg() {
        return DesignerMsg.FOLDER;
    }

    @Override
    protected boolean isProjectObjectExists(String suggestedName) {
        return this.parentContainer.findContainer(suggestedName) != null;
    }

    @Override
    protected String getSuggestedPrefix() {
        return DesignerMsg.NEW_FOLDER.getString();
    }
}

