/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.tree.folder;

import oracle.bpm.designer.DesignerAction;
import oracle.bpm.designer.ProjectObjectTreeNode;
import oracle.bpm.designer.fojsp.loaders.Loader;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.tree.folder.actions.DeleteResourceNodeAction;
import oracle.bpm.project.model.Container;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.resources.ResourceObject;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.action.ActionGroup;
import oracle.bpm.ui.action.BaseAction;

public abstract class AbstractFolderTreeNode
extends ProjectObjectTreeNode<ResourceObject> {
    protected DesignerAction deleteAction;
    protected boolean isContainer;
    protected boolean isRemovable;
    protected Loader loader;
    protected Image nodeIcon;
    protected Project project;
    static final long serialVersionUID = -3133646462771683866L;
    static final long serialCheck = -472453394556798391L;

    public AbstractFolderTreeNode(Container resourceObject) {
        super((ProjectObject)((ResourceObject)resourceObject));
        this.setUserObject(resourceObject);
        this.isContainer = false;
        this.deleteAction = new DeleteResourceNodeAction(this);
        this.isRemovable = true;
        this.project = resourceObject.getProject();
    }

    public boolean isContainer() {
        return this.isContainer;
    }

    public ResourceObject getContent() {
        return (ResourceObject)this.getUserObject();
    }

    public void setLoader(Loader loader) {
        this.loader = loader;
    }

    @Override
    public String getName() {
        return this.getContent().getName();
    }

    public boolean isRemovable() {
        return this.isRemovable;
    }

    public void setRemovable(boolean removable) {
        this.isRemovable = removable;
    }

    public boolean delete() {
        return this.deleteAction.doIt();
    }

    @Override
    public String toString() {
        return this.getContent().getName();
    }

    @Override
    public Project getProject() {
        return this.project;
    }

    protected ActionGroup getRootAction() {
        return new ActionGroup(DesignerMsg.EMPTY_MSG(""));
    }

    protected boolean isReadOnly() {
        return this.getContent().isReadOnly();
    }

    protected void addCommonActions() {
        super.addCommonActions();
        if (this.isRemovable) {
            this.getCommonActionsMap().put("delete-action", this.deleteAction);
        }
    }

    protected void addDeleteAction(ActionGroup action) {
        if (this.isRemovable) {
            DesignerAction deleteAction = this.deleteAction;
            deleteAction.setEnabled(!this.isReadOnly());
            action.add((BaseAction)deleteAction);
        }
    }
}

