/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.toolbar;

import java.util.ArrayList;
import java.util.List;
import oracle.bpm.command.Command;
import oracle.bpm.designer.AbstractStudioWorkbench;
import oracle.bpm.designer.ActionRunner;
import oracle.bpm.designer.AutoLayoutPanel;
import oracle.bpm.designer.DesignerStateManager;
import oracle.bpm.designer.HighlightSlider;
import oracle.bpm.designer.ProcessDomain;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.preferences.DesignerPreferences;
import oracle.bpm.designer.preferences.HighlightLevel;
import oracle.bpm.designer.toolbar.FlowNodeToolBarAction;
import oracle.bpm.event.ModificationEvent;
import oracle.bpm.event.ModificationListener;
import oracle.bpm.project.command.design.ChangeScaleCommand;
import oracle.bpm.project.model.features.Feature;
import oracle.bpm.project.model.features.ViewScaleFeature;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.ButtonSlider;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.ToolBar;
import oracle.bpm.ui.ToolBarItem;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.selection.DefaultSelection;
import org.jetbrains.annotations.NotNull;

public class UtilityToolBar
extends ToolBar {
    public HighlightSlider highlightSlider;
    public ViewScaleFeature scaleFeature;
    public ButtonSlider<Float> scaleSlider;
    private ProcessDomain domain;
    private List<FlowNodeToolBarAction> flowNodeButtons = new ArrayList<FlowNodeToolBarAction>();
    private Process process;

    public UtilityToolBar(UiContainer parent, DesignerStateManager manager) {
        super(parent, ToolBar.Orientation.HORIZONTAL);
        this.domain = manager.getDomain();
        this.process = manager.getDomain().getDomainElement();
        this.build();
    }

    public void build() {
        this.initGotoCompositeUtility();
        this.addSeparator();
        this.initLayoutUtility();
        this.addSeparator();
        this.initHighlightUtility();
        this.addSeparator();
        this.initScaleUtility();
        this.addListeners();
        this.enableButtons();
    }

    public void enableButtons() {
        boolean isReadOnly = !this.process.isReadOnly();
        for (FlowNodeToolBarAction action : this.flowNodeButtons) {
            action.setEnabled(action.isEnabled() && isReadOnly);
        }
    }

    private void initGotoCompositeUtility() {
        BaseAction action = AbstractStudioWorkbench.getInstance().createGotoCompositeAction();
        if (action != null) {
            action.setSelection(DefaultSelection.createSingle((Object)this.process.getProject()));
            ToolBarItem toolBarItem = this.add(action);
            toolBarItem.setToolTipText(action.getMsg());
        }
    }

    private void initLayoutUtility() {
        this.add((UiComponent)AutoLayoutPanel.create((UiContainer)this, this.domain));
    }

    private void initHighlightUtility() {
        HighlightLevel level = DesignerPreferences.getPreferences().getHighlight();
        this.highlightSlider = HighlightSlider.create((UiContainer)this, Image.create((Msg)UIMsg.ERROR), level);
        this.highlightSlider.setToolTipText(DesignerMsg.HIGHLIGHTING_LEVEL);
        this.add((UiComponent)this.highlightSlider);
    }

    private void initScaleUtility() {
        this.scaleFeature = (ViewScaleFeature)this.process.getFeature(ViewScaleFeature.class);
        this.scaleSlider = ButtonSlider.createFloat((UiContainer)this, (Image)Image.create((Msg)UIMsg.ZOOM), (Float)ViewScaleFeature.MAXIMUM_SCALE, (Float)ViewScaleFeature.MINIMUM_SCALE, (Float)ViewScaleFeature.INCREMENT_SCALE, (Float)this.scaleFeature.getValue());
        this.scaleSlider.setToolTipText(UIMsg.ZOOM);
        this.add((UiComponent)this.scaleSlider);
    }

    private void addListeners() {
        this.highlightSlider.addSliderListener(new HighlightSliderListener());
        this.scaleSlider.addSliderListener((ButtonSlider.SliderListener)new ScaleSliderListener());
        ModificationListener<Feature> viewScaleListener = new ModificationListener<Feature>(){

            @Override
            public void objectModified(ModificationEvent<Feature> event) {
                UtilityToolBar.this.scaleSlider.setValue((Number)UtilityToolBar.this.scaleFeature.getValue());
            }
        };
        this.scaleFeature.addModificationListener((ModificationListener)viewScaleListener);
    }

    private class ScaleSliderListener
    implements ButtonSlider.SliderListener<Float> {
        private ScaleSliderListener() {
        }

        public void sliderChanged(@NotNull Float value) {
            ActionRunner.getInstance().run((Command)new ChangeScaleCommand(UtilityToolBar.this.process, value.floatValue()));
            UtilityToolBar.this.domain.getDrawContext().setScale(((Float)UtilityToolBar.this.process.getFeatureValue(ViewScaleFeature.class)).floatValue());
            UtilityToolBar.this.domain.getCanvas().repaint();
        }
    }

    private class HighlightSliderListener
    implements HighlightSlider.SliderListener {
        private HighlightSliderListener() {
        }

        @Override
        public void sliderChanged(@NotNull HighlightLevel newLevel) {
            DesignerPreferences preferences = DesignerPreferences.getPreferences();
            preferences.setHighlight(newLevel);
            preferences.store();
            UtilityToolBar.this.domain.getCanvas().repaint();
        }
    }
}

