/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.toolbar;

import oracle.bpm.designer.DesignerStateManager;
import oracle.bpm.designer.preferences.DesignerPreferences;
import oracle.bpm.designer.preferences.ToolBarMode;
import oracle.bpm.designer.toolbar.FlowElementToolBarActionFactory;
import oracle.bpm.designer.toolbar.FlowNodeToolBarAction;
import oracle.bpm.draw.figure.FlowFigureType;
import oracle.bpm.draw.figure.FlowFigureTypeProvider;
import oracle.bpm.draw.themes.ThemeProvider;
import oracle.bpm.ui.ToolBar;
import oracle.bpm.ui.ToolBarItem;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import org.jetbrains.annotations.NotNull;

public class FlowNodeToolbar
extends ToolBar {
    private FlowElementToolBarActionFactory factory;
    private ToolBarMode mode = ToolBarMode.ICON_ONLY;

    public FlowNodeToolbar(UiContainer parent, DesignerStateManager manager) {
        super(parent);
        this.factory = new FlowElementToolBarActionFactory(manager);
        this.build();
    }

    private void build() {
        this.addActivities();
        this.addGateways();
        this.addEvents();
        this.addSubprocess();
        this.addSequenceFlow();
    }

    private void addActivities() {
        for (FlowFigureType type : FlowFigureTypeProvider.getDefaultActivities()) {
            FlowNodeToolBarAction action = this.factory.createFlowNodeAction(type, (ThemeProvider)DesignerPreferences.getPreferences().getTheme());
            this.addAction(action);
        }
    }

    private void addEvents() {
        for (FlowFigureType type : FlowFigureTypeProvider.getDefaultEvents()) {
            FlowNodeToolBarAction action = this.factory.createFlowNodeAction(type, (ThemeProvider)DesignerPreferences.getPreferences().getTheme());
            this.addAction(action);
        }
    }

    private void addGateways() {
        for (FlowFigureType type : FlowFigureTypeProvider.getDefaultGateways()) {
            FlowNodeToolBarAction action = this.factory.createFlowNodeAction(type, (ThemeProvider)DesignerPreferences.getPreferences().getTheme());
            this.addAction(action);
        }
    }

    private void addSubprocess() {
        FlowNodeToolBarAction action = this.factory.createFlowNodeAction(FlowFigureType.SUBPROCESS, (ThemeProvider)DesignerPreferences.getPreferences().getTheme());
        this.addAction(action);
    }

    private void addSequenceFlow() {
        FlowNodeToolBarAction action = this.factory.createAddSequenceFlowAction(DesignerPreferences.getPreferences().getTheme());
        this.addAction(action);
    }

    private void addAction(@NotNull FlowNodeToolBarAction action) {
        int options = this.mode == ToolBarMode.ICON_AND_TEXT ? 11 : 10;
        ToolBarItem item = this.add(action, options);
        this.setAllSizes((UiComponent)item, action.getSmallIcon().getDimension().add(4, 4));
    }
}

