/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.toolbar;

import oracle.bpm.designer.DesignerStateManager;
import oracle.bpm.designer.ProcessCanvas;
import oracle.bpm.designer.controller.ProcessController;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.processdesigner.states.AddingNoteState;
import oracle.bpm.designer.processdesigner.states.AddingRoleState;
import oracle.bpm.designer.processdesigner.states.AddingSequenceFlowState;
import oracle.bpm.designer.toolbar.AddFlowNodeFromToolbarAction;
import oracle.bpm.designer.toolbar.FlowNodeToolBarAction;
import oracle.bpm.draw.figure.FlowFigureType;
import oracle.bpm.draw.figure.FlowFigureUtils;
import oracle.bpm.draw.themes.DefaultTheme;
import oracle.bpm.draw.themes.ImageType;
import oracle.bpm.draw.themes.ThemeProvider;
import oracle.bpm.project.LaneImpl;
import oracle.bpm.project.TextAnnotationImpl;
import oracle.bpm.project.model.processes.Lane;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.TextAnnotation;
import oracle.bpm.project.model.processes.TransitionType;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Image;
import org.jetbrains.annotations.NotNull;

class FlowElementToolBarActionFactory {
    private final DesignerStateManager manager;
    private final Process process;

    FlowElementToolBarActionFactory(@NotNull DesignerStateManager manager) {
        this.manager = manager;
        this.process = manager.getDomain().getDomainElement();
    }

    FlowNodeToolBarAction createFlowNodeAction(@NotNull FlowFigureType type, @NotNull ThemeProvider theme) {
        AddFlowNodeFromToolbarAction addActivityAction = new AddFlowNodeFromToolbarAction(type, this.manager);
        addActivityAction.setSmallIcon(theme.getImageFor(type, ImageType.ICON));
        addActivityAction.setMsg(type.getType().isEvent() ? type.getLabel() : FlowFigureUtils.getNameForType((FlowFigureType)type));
        return addActivityAction;
    }

    FlowNodeToolBarAction createAddRoleAction() {
        AddLaneAction addRoleFromToolbarAction = new AddLaneAction();
        addRoleFromToolbarAction.setSmallIcon(Image.create((Msg)DesignerMsg.ADD_ROLE));
        return addRoleFromToolbarAction;
    }

    FlowNodeToolBarAction createAddNoteAction() {
        AddNoteAction addNoteAction = new AddNoteAction();
        addNoteAction.setSmallIcon(Image.create((Msg)DesignerMsg.NEW_NOTE));
        return addNoteAction;
    }

    FlowNodeToolBarAction createAddSequenceFlowAction(DefaultTheme theme) {
        AddTransitionAction addSequenceFlowAction = new AddTransitionAction();
        Image newTransitionImage = theme.getNewTransitionImage();
        addSequenceFlowAction.setSmallIcon(newTransitionImage);
        return addSequenceFlowAction;
    }

    private class AddTransitionAction
    extends FlowNodeToolBarAction {
        private AddTransitionAction() {
            super(DesignerMsg.SEQUENCE_FLOW);
        }

        public void run() {
            ProcessController controller = this.getProcessCanvas().getProcessController();
            AddingSequenceFlowState state = AddingSequenceFlowState.create(controller, null, TransitionType.UNCONDITIONAL);
            FlowElementToolBarActionFactory.this.manager.getCurrentState().cancel();
            FlowElementToolBarActionFactory.this.manager.setCurrentState(state);
        }

        private ProcessCanvas getProcessCanvas() {
            return FlowElementToolBarActionFactory.this.manager.getDomain().getCanvas();
        }
    }

    private class AddNoteAction
    extends FlowNodeToolBarAction {
        public AddNoteAction() {
            super(DesignerMsg.TEXT_ANNOTATION);
        }

        public void run() {
            TextAnnotationImpl textAnnotationImpl = (TextAnnotationImpl)FlowElementToolBarActionFactory.this.process.createTextAnnotation("");
            FlowElementToolBarActionFactory.this.manager.getCurrentState().cancel();
            FlowElementToolBarActionFactory.this.manager.setCurrentState(new AddingNoteState((TextAnnotation)textAnnotationImpl));
        }
    }

    private class AddLaneAction
    extends FlowNodeToolBarAction {
        public AddLaneAction() {
            super(DesignerMsg.ADD_ROLE);
        }

        public void run() {
            if (FlowElementToolBarActionFactory.this.manager != null && FlowElementToolBarActionFactory.this.process != null) {
                LaneImpl laneImpl = (LaneImpl)FlowElementToolBarActionFactory.this.process.createLane(null);
                FlowElementToolBarActionFactory.this.manager.getCurrentState().cancel();
                FlowElementToolBarActionFactory.this.manager.setCurrentState(new AddingRoleState((Lane)laneImpl));
            }
        }
    }
}

