/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.toolbar;

import oracle.bpm.designer.DesignerStateManager;
import oracle.bpm.designer.capability.CapabilityType;
import oracle.bpm.designer.controller.ControllerUtils;
import oracle.bpm.designer.controller.FlowElementController;
import oracle.bpm.designer.processdesigner.states.AddingState;
import oracle.bpm.designer.toolbar.FlowNodeToolBarAction;
import oracle.bpm.draw.figure.FlowFigureType;
import oracle.bpm.draw.themes.DefaultTheme;
import oracle.bpm.draw.themes.ImageType;
import org.jetbrains.annotations.NotNull;

class AddFlowNodeFromToolbarAction
extends FlowNodeToolBarAction {
    @NotNull
    private DesignerStateManager manager;
    @NotNull
    private FlowFigureType type;

    AddFlowNodeFromToolbarAction(@NotNull FlowFigureType type, @NotNull DesignerStateManager manager) {
        super(type.getLabel());
        this.type = type;
        this.manager = manager;
    }

    public void run() {
        FlowElementController controller = ControllerUtils.createFlowElementControllerFromType(this.type, this.manager.getDomain());
        this.manager.getCurrentState().cancel();
        this.manager.setCurrentState(new AddingState(CapabilityType.ADD_NODE, controller));
    }

    @Override
    public void updateTheme(DefaultTheme theme) {
        this.setSmallIcon(theme.getImageFor(this.type, ImageType.ICON));
    }
}

