/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.subcontroller;

import oracle.bpm.designer.capability.focus.FocusCapability;
import oracle.bpm.designer.controller.Controller;
import oracle.bpm.designer.subcontroller.SubcontrollerImpl;
import oracle.bpm.draw.DesignerLayer;
import oracle.bpm.draw.DrawContext;
import oracle.bpm.draw.Drawable;
import oracle.bpm.draw.DrawableImpl;
import oracle.bpm.draw.Graphics;
import oracle.bpm.geom.Point;
import oracle.bpm.geom.Rectangle;
import oracle.bpm.ui.Cursor;
import oracle.bpm.ui.Image;
import org.jetbrains.annotations.NotNull;

public class ResizeSubcontroller<T>
extends SubcontrollerImpl<T> {
    protected ResizeSubcontroller(Controller<T> controller, Drawable<T> drawable) {
        super(controller, drawable);
        this.install(new FocusCapability(this));
    }

    @Override
    @NotNull
    public Cursor getCursor() {
        return Cursor.SE_RESIZE_CURSOR;
    }

    protected static class DrawableHandlerResize<T>
    extends DrawableImpl<T> {
        private final Controller<T> container;
        private final Image handler;

        protected DrawableHandlerResize(@NotNull Controller<T> container, @NotNull Image handler) {
            super(container.getDrawableObject(), container.getModelObject(), DesignerLayer.CAPABILITY);
            this.container = container;
            this.handler = handler;
        }

        @NotNull
        public Rectangle getBounds(@NotNull DrawContext context) {
            Rectangle result;
            if (this.container.getSelection().isPrimary()) {
                Point top = this.getContainer().getBounds(context).getTop();
                Point origin = top.sub(this.handler.getWidth(), this.handler.getHeight());
                result = Rectangle.deriveFromPoints(origin, top).translate(2, 2);
            } else {
                result = Rectangle.ZERO;
            }
            return result;
        }

        public void draw(@NotNull DrawContext context) {
            if (this.container.getSelection().isPrimary()) {
                Rectangle bounds = this.getBounds(context);
                Graphics graphics = context.getGraphics();
                graphics.drawImage(this.handler, bounds.scaled(context.getScale()));
            }
        }
    }
}

