/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.subcontroller;

import java.awt.Shape;
import java.awt.geom.GeneralPath;
import oracle.bpm.designer.capability.drag.NoteResizeCapability;
import oracle.bpm.designer.controller.Controller;
import oracle.bpm.designer.controller.NoteController;
import oracle.bpm.designer.subcontroller.ResizeSubcontroller;
import oracle.bpm.draw.DesignerLayer;
import oracle.bpm.draw.DrawContext;
import oracle.bpm.draw.DrawableImpl;
import oracle.bpm.draw.Graphics;
import oracle.bpm.geom.Point;
import oracle.bpm.geom.Rectangle;
import oracle.bpm.project.model.processes.TextAnnotation;
import org.jetbrains.annotations.NotNull;

public class NoteResizeSubcontroller
extends ResizeSubcontroller<TextAnnotation> {
    private static final int CORNER_HANDLER_SIZE = 12;

    private NoteResizeSubcontroller(NoteController controller) {
        super(controller, new DrawableCornerResize<TextAnnotation>(controller));
        this.install(new NoteResizeCapability(this));
    }

    public static void appendTo(@NotNull NoteController controller) {
        NoteResizeSubcontroller subcontroller = new NoteResizeSubcontroller(controller);
        subcontroller.add();
    }

    private static class DrawableCornerResize<T>
    extends DrawableImpl<T> {
        private final Controller<T> container;

        protected DrawableCornerResize(@NotNull Controller<T> container) {
            super(container.getDrawableObject(), container.getModelObject(), DesignerLayer.CAPABILITY);
            this.container = container;
        }

        @NotNull
        public Rectangle getBounds(@NotNull DrawContext context) {
            Rectangle result;
            if (this.container.getSelection().isPrimary()) {
                Point top = this.getContainer().getBounds(context).getTop();
                Point origin = top.sub(12, 12);
                result = Rectangle.deriveFromPoints(origin, top);
            } else {
                result = Rectangle.ZERO;
            }
            return result;
        }

        public void draw(@NotNull DrawContext context) {
            if (this.container.getSelection().isPrimary()) {
                Rectangle bounds = context.scaleRectangle(this.getBounds(context));
                Graphics graphics = context.getGraphics();
                Point origin = bounds.getOrigin();
                Point top = bounds.getTop();
                GeneralPath path = new GeneralPath();
                path.moveTo(top.getX(), origin.getY());
                path.lineTo(top.getX(), top.getY());
                path.lineTo(origin.getX(), top.getY());
                path.closePath();
                graphics.fill((Shape)path);
            }
        }
    }
}

