/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.subcontroller;

import oracle.bpm.designer.capability.edit.ParentContainerEditCapability;
import oracle.bpm.designer.capability.focus.FocusCapability;
import oracle.bpm.designer.controller.FlowNodeController;
import oracle.bpm.designer.subcontroller.ExpandCollapseSubcontroller;
import oracle.bpm.designer.subcontroller.SubcontrollerImpl;
import oracle.bpm.draw.Color;
import oracle.bpm.draw.DesignerLayer;
import oracle.bpm.draw.DrawContext;
import oracle.bpm.draw.Graphics;
import oracle.bpm.draw.SubdrawableImpl;
import oracle.bpm.draw.msg.ProjectDrawMsg;
import oracle.bpm.geom.Point;
import oracle.bpm.geom.Rectangle;
import oracle.bpm.project.model.processes.Activity;
import oracle.bpm.project.model.processes.LoopCharacteristicsType;
import oracle.bpm.project.model.processes.MultiInstance;
import oracle.bpm.project.model.processes.Subprocess;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Cursor;
import oracle.bpm.ui.Image;
import org.jetbrains.annotations.NotNull;

public class LoopCharacteristicSubcontroller
extends SubcontrollerImpl<Activity> {
    private LoopCharacteristicSubcontroller(@NotNull FlowNodeController<Subprocess> container) {
        super(container, new LoopCharacteristicSubdrawable(container));
        this.install(new FocusCapability(this));
        this.install(new ParentContainerEditCapability(this));
    }

    public static void appendTo(@NotNull FlowNodeController container) {
        if (LoopCharacteristicSubcontroller.applies(container)) {
            new LoopCharacteristicSubcontroller(container).add();
        }
    }

    public static boolean applies(@NotNull FlowNodeController controller) {
        return controller.getModelObject() instanceof Subprocess;
    }

    public static boolean isActive(@NotNull FlowNodeController controller) {
        return LoopCharacteristicSubcontroller.applies(controller) && ((Activity)controller.getModelObject().asAnyNode(Activity.class)).getLoopCharacteristicsType() != LoopCharacteristicsType.NONE;
    }

    @Override
    @NotNull
    public Cursor getCursor() {
        return Cursor.HAND_CURSOR;
    }

    private static class LoopCharacteristicSubdrawable
    extends SubdrawableImpl<Activity> {
        private Rectangle cache = Rectangle.ZERO;
        private final FlowNodeController<Subprocess> container;
        private LoopCharacteristicsType type;
        private static final Image LOOP_IMAGE = Image.create((Msg)ProjectDrawMsg.LOOP);
        private static final Image PARALLEL_IMAGE = Image.create((Msg)ProjectDrawMsg.PARALLEL);
        private static final Image SEQUENTIAL_IMAGE = Image.create((Msg)ProjectDrawMsg.SEQUENTIAL);
        private static final int DISTANCE_GAP = 2;

        public LoopCharacteristicSubdrawable(@NotNull FlowNodeController<Subprocess> container) {
            super(container.getDrawableObject(), (Object)container.getModelObject(), DesignerLayer.CAPABILITY);
            this.container = container;
        }

        public void draw(@NotNull DrawContext context) {
            Image image = this.getCurrentImage();
            if (image != null) {
                Rectangle scaled = context.scaleRectangle(this.getBounds(context));
                Graphics graphics = context.getGraphics();
                Color original = graphics.getForeground();
                graphics.setForeground(Color.TRANSLUCENT);
                graphics.drawImage(image, scaled);
                graphics.setForeground(original);
            }
        }

        protected Rectangle createBounds(@NotNull DrawContext context) {
            this.setupWidthHeightAndLocation(context);
            return super.createBounds(context);
        }

        protected boolean needsUpdate() {
            DrawContext context = this.container.getDomain().getDrawContext();
            boolean result = super.needsUpdate();
            result = result || !this.cache.equals(this.container.getDrawableObject().getBounds(context));
            result = result || this.type != this.container.getModelObject().getLoopCharacteristicsType();
            return result;
        }

        private Image getCurrentImage() {
            Activity activity = (Activity)this.container.getModelObject();
            LoopCharacteristicsType characteristics = activity.getLoopCharacteristicsType();
            Image result = null;
            switch (characteristics) {
                case LOOP: {
                    result = LOOP_IMAGE;
                    break;
                }
                case MULTIINSTANCE: {
                    result = ((MultiInstance)activity.getLoopCharacteristics().as(MultiInstance.class)).isSequential() ? SEQUENTIAL_IMAGE : PARALLEL_IMAGE;
                }
            }
            return result;
        }

        private void setupWidthHeightAndLocation(@NotNull DrawContext context) {
            Rectangle parent = this.container.getDrawableObject().getBounds(context);
            Image image = this.getCurrentImage();
            if (image != null) {
                if (ExpandCollapseSubcontroller.applies(this.container)) {
                    this.locateAtCenterWithDelta(context, parent, image, -1);
                } else {
                    this.locateAtCenterWithDelta(context, parent, image, 0);
                }
            }
            this.cache = parent;
            this.type = this.container.getModelObject().getLoopCharacteristicsType();
        }

        private void locateAtCenterWithDelta(@NotNull DrawContext context, @NotNull Rectangle parent, @NotNull Image image, int delta) {
            this.setWidth(context, image.getWidth());
            this.setHeight(context, image.getHeight());
            int dx = this.getWidth(context) / 2 + 1;
            Point location = new Point(parent.getCenterX(), parent.getMaxY()).translate(dx * delta, -this.getHeight(context) / 2 - 2);
            this.setLocation(location);
        }
    }
}

