/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.subcontroller;

import oracle.bpm.designer.capability.edit.ParentContainerEditCapability;
import oracle.bpm.designer.capability.focus.FocusCapability;
import oracle.bpm.designer.capability.selection.ParentContainerPopUpCapability;
import oracle.bpm.designer.capability.selection.ParentContainerSelectionCapability;
import oracle.bpm.designer.controller.Controller;
import oracle.bpm.designer.preferences.DesignerPreferences;
import oracle.bpm.designer.preferences.HighlightLevel;
import oracle.bpm.designer.subcontroller.SubcontrollerImpl;
import oracle.bpm.draw.DesignerLayer;
import oracle.bpm.draw.DrawContext;
import oracle.bpm.draw.DrawableImpl;
import oracle.bpm.geom.Point;
import oracle.bpm.geom.Rectangle;
import oracle.bpm.project.model.ErrorSource;
import oracle.bpm.ui.Cursor;
import oracle.bpm.ui.Image;
import org.jetbrains.annotations.NotNull;

public class HighlightSubcontroller<T>
extends SubcontrollerImpl<T> {
    protected HighlightSubcontroller(Controller<T> container, DrawableHighlight<T> inset) {
        super(container, inset);
        this.install(new FocusCapability(this));
        this.install(new ParentContainerPopUpCapability(this));
        this.install(new ParentContainerSelectionCapability(this));
        this.install(new ParentContainerEditCapability(this));
    }

    private HighlightSubcontroller(Controller<T> container) {
        this(container, new DrawableHighlight<T>(container));
    }

    public static <T> void appendTo(@NotNull Controller<T> controller) {
        if (HighlightSubcontroller.applies(controller)) {
            new HighlightSubcontroller<T>(controller).add();
        }
    }

    public static boolean applies(@NotNull Controller controller) {
        return controller.getModelObject() instanceof ErrorSource;
    }

    @Override
    @NotNull
    public Cursor getCursor() {
        return Cursor.HAND_CURSOR;
    }

    protected static class DrawableHighlight<T>
    extends DrawableImpl<T> {
        private Controller<T> owner;

        protected DrawableHighlight(@NotNull Controller<T> owner) {
            super(owner.getDrawableObject(), owner.getModelObject(), DesignerLayer.CAPABILITY);
            this.owner = owner;
        }

        @NotNull
        public Rectangle getBounds(@NotNull DrawContext context) {
            Rectangle result;
            Image image = this.getHighlightImage();
            if (image != null) {
                Point location = this.getContainerLocation(context, image);
                result = Rectangle.valueOf(location, image.getDimension());
            } else {
                result = Rectangle.ZERO;
            }
            return result;
        }

        public void draw(@NotNull DrawContext context) {
            Image image = this.getHighlightImage();
            if (image != null) {
                Rectangle bounds = context.scaleRectangle(this.getBounds(context));
                context.getGraphics().drawImage(image, bounds);
            }
        }

        protected Image getHighlightImage() {
            HighlightLevel level = DesignerPreferences.getPreferences().getHighlight();
            ErrorSource source = this.getErrorSource();
            return (level.isError() || level.isWarning()) && source.hasNestedErrors() ? HighlightLevel.ERROR.getIcon() : (level.isWarning() && source.hasNestedWarnings() ? HighlightLevel.WARNING.getIcon() : null);
        }

        protected int getInset() {
            return 4;
        }

        protected Point getContainerLocation(DrawContext context, Image image) {
            int inset = this.getInset();
            return this.getContainer().getBounds(context).getTop().translate(-image.getWidth() - inset, -image.getHeight() - inset);
        }

        private ErrorSource getErrorSource() {
            return (ErrorSource)this.owner.getModelObject();
        }
    }
}

