/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.subcontroller;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.bpm.designer.controller.Controller;
import oracle.bpm.designer.preferences.DesignerPreferences;
import oracle.bpm.designer.preferences.HighlightLevel;
import oracle.bpm.designer.selection.DesignerSelectionProvider;
import oracle.bpm.designer.selection.DomainSelectionProvider;
import oracle.bpm.designer.subcontroller.SubcontrollerImpl;
import oracle.bpm.draw.Color;
import oracle.bpm.draw.DesignerLayer;
import oracle.bpm.draw.DrawContext;
import oracle.bpm.draw.Drawable;
import oracle.bpm.draw.DrawableImpl;
import oracle.bpm.draw.DrawableSubprocess;
import oracle.bpm.draw.FontMetrics;
import oracle.bpm.draw.Graphics;
import oracle.bpm.draw.Stroke;
import oracle.bpm.draw.Utilities;
import oracle.bpm.draw.msg.ProjectDrawMsg;
import oracle.bpm.geom.Point;
import oracle.bpm.geom.Rectangle;
import oracle.bpm.project.model.ErrorSource;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Image;
import org.jetbrains.annotations.NotNull;

public class HighlightMessageSubcontroller<T>
extends SubcontrollerImpl<T> {
    private HighlightMessageSubcontroller(@NotNull Controller<T> container) {
        super(container, new DrawableHighlightMessage(container));
    }

    public static <T> void appendTo(@NotNull Controller<T> container) {
        new HighlightMessageSubcontroller<T>(container).add();
    }

    private static class DrawableHighlightMessage<T>
    extends DrawableImpl<T> {
        private Image grayErrorImage;
        private Image grayWarningImage;
        private final Controller<T> owner;
        private static final int MAX_LINE_LENGTH = 80;

        private DrawableHighlightMessage(@NotNull Controller<T> owner) {
            super(owner.getDrawableObject(), owner.getModelObject(), DesignerLayer.PROCESS);
            this.owner = owner;
            this.grayErrorImage = Utilities.convertToGrayscale((Image)Image.create((Msg)ProjectDrawMsg.ERROR));
            this.grayWarningImage = Utilities.convertToGrayscale((Image)Image.create((Msg)ProjectDrawMsg.WARNING));
        }

        @NotNull
        public Rectangle getBounds(@NotNull DrawContext context) {
            return Rectangle.ZERO;
        }

        public boolean intersects(@NotNull Rectangle rectangle, @NotNull DrawContext context) {
            return true;
        }

        public void draw(@NotNull DrawContext context) {
            Image image = this.getHighlightImage();
            Controller controller = (Controller)this.getProvider().getSelection().as(Controller.class);
            if (image != null && controller != null) {
                Drawable single = controller.getDrawableObject();
                int margin = 7;
                int roundedSize = 5;
                int alpha = 190;
                Color boxBackground = Color.valueOf((Color)Color.GRAY.darker(), (int)alpha);
                Color boxBorder = Color.valueOf((Color)Color.GRAY.darker().darker(), (int)alpha);
                Color boxText = Color.WHITE;
                Graphics graphics = context.getGraphics();
                Color foreground = graphics.getForeground();
                Stroke original = graphics.getStroke();
                FontMetrics fontMetrics = graphics.getFontMetrics();
                int stringHeight = fontMetrics.getHeight() + 2;
                int maxStringWidth = 0;
                List<ErrorMessage> messages = this.getHighlightMessages();
                for (ErrorMessage exception : messages) {
                    int stringWidth = fontMetrics.stringWidth(exception.getMessage());
                    maxStringWidth = Math.max(maxStringWidth, stringWidth);
                }
                Point location = context.scalePoint(single.getLocation());
                int boxX = location.getX();
                int boxY = location.getY() + single.getHeight(context) + 15;
                if (single instanceof DrawableSubprocess) {
                    boxY -= single.getHeight(context) / 2;
                }
                boxX -= maxStringWidth / 2;
                boxX = Math.max(boxX, 0);
                boxY = Math.max(boxY, 0);
                int boxWidth = maxStringWidth + margin * 2 + (this.grayErrorImage.getIconWidth() + margin);
                int boxHeight = stringHeight * messages.size() + margin;
                graphics.setForeground(boxBackground);
                graphics.fillRoundRect(boxX, boxY, boxWidth, boxHeight, roundedSize, roundedSize);
                graphics.setStroke(Stroke.TWO_SOLID);
                graphics.setForeground(boxBorder);
                graphics.drawRoundRect(boxX, boxY, boxWidth, boxHeight, roundedSize, roundedSize);
                graphics.setForeground(boxText);
                int iconHeight = this.grayErrorImage.getIconHeight() - 5;
                int space = 2;
                int textY = boxY;
                ErrorSource source = this.getErrorSource();
                HighlightLevel level = DesignerPreferences.getPreferences().getHighlight();
                if (level.isError() || level.isWarning()) {
                    List<ErrorMessage> errors = this.toMessages(source.getNestedErrors(), ErrorMessage.Type.ERROR);
                    for (ErrorMessage error : errors) {
                        textY += stringHeight;
                        if (error.getType() != ErrorMessage.Type.CONTINUATION) {
                            graphics.drawImage(this.grayErrorImage, boxX + margin, textY - iconHeight, this.grayErrorImage.getIconWidth(), this.grayErrorImage.getIconHeight());
                        }
                        graphics.drawString(error.getMessage(), boxX + margin + this.grayErrorImage.getIconWidth() + space, textY);
                    }
                }
                if (level.isWarning()) {
                    List<ErrorMessage> warnings = this.toMessages(source.getNestedWarnings(), ErrorMessage.Type.WARNING);
                    for (ErrorMessage warning : warnings) {
                        textY += stringHeight;
                        if (warning.getType() != ErrorMessage.Type.CONTINUATION) {
                            graphics.drawImage(this.grayWarningImage, boxX + margin, textY - iconHeight, this.grayWarningImage.getIconWidth(), this.grayWarningImage.getIconHeight());
                        }
                        graphics.drawString(warning.getMessage(), boxX + margin + this.grayWarningImage.getIconWidth() + space, textY);
                    }
                }
                graphics.setStroke(original);
                graphics.setForeground(foreground);
            }
        }

        private Image getHighlightImage() {
            ErrorSource source = this.getErrorSource();
            Image result = null;
            if (source != null) {
                HighlightLevel level = DesignerPreferences.getPreferences().getHighlight();
                result = (level.isError() || level.isWarning()) && source.hasNestedErrors() ? HighlightLevel.ERROR.getIcon() : (level.isWarning() && source.hasNestedWarnings() ? HighlightLevel.WARNING.getIcon() : null);
            }
            return result;
        }

        private List<ErrorMessage> getHighlightMessages() {
            List<ProjectException> result;
            ErrorSource source = this.getErrorSource();
            if (source != null) {
                result = new ArrayList();
                HighlightLevel level = DesignerPreferences.getPreferences().getHighlight();
                if ((level.isError() || level.isWarning()) && source.hasNestedErrors()) {
                    result.addAll(source.getNestedErrors());
                }
                if (level.isWarning() && source.hasNestedWarnings()) {
                    result.addAll(source.getNestedWarnings());
                }
            } else {
                result = Collections.emptyList();
            }
            return this.toMessages(result, ErrorMessage.Type.ERROR);
        }

        private List<ErrorMessage> toMessages(List<ProjectException> result, ErrorMessage.Type type) {
            ArrayList<ErrorMessage> errors = new ArrayList<ErrorMessage>();
            for (ProjectException exception : result) {
                String msg = exception.getMessage();
                List<String> continuationLines = null;
                if (msg.length() > 80) {
                    continuationLines = this.splitLines(msg);
                    msg = continuationLines.remove(0);
                }
                errors.add(new ErrorMessage(msg, type));
                if (continuationLines == null) continue;
                for (String line : continuationLines) {
                    errors.add(new ErrorMessage(line, ErrorMessage.Type.CONTINUATION));
                }
            }
            return errors;
        }

        private List<String> splitLines(String msg) {
            String[] words;
            ArrayList<String> lines = new ArrayList<String>();
            StringBuilder currentLine = new StringBuilder();
            for (String word : words = msg.split("\\s+")) {
                if (currentLine.length() + word.length() < 80) {
                    if (currentLine.length() > 0) {
                        currentLine.append(' ');
                    }
                } else {
                    lines.add(currentLine.toString());
                    currentLine.setLength(0);
                }
                currentLine.append(word);
            }
            if (currentLine.length() > 0) {
                lines.add(currentLine.toString());
            }
            return lines;
        }

        private ErrorSource getErrorSource() {
            DesignerSelectionProvider provider = this.getProvider();
            ErrorSource result = null;
            if (((DomainSelectionProvider)provider).getSelection().isSingle()) {
                result = (ErrorSource)((DomainSelectionProvider)provider).getSelection().as(ErrorSource.class);
            }
            return result;
        }

        private DesignerSelectionProvider getProvider() {
            return (DesignerSelectionProvider)this.owner.getDomain().getSelectionProvider();
        }
    }

    static class ErrorMessage {
        private String message;
        private Type type;

        ErrorMessage(String message, Type type) {
            this.message = message;
            this.type = type;
        }

        public String getMessage() {
            return this.message;
        }

        public Type getType() {
            return this.type;
        }

        static enum Type {
            ERROR,
            WARNING,
            CONTINUATION;

        }
    }
}

