/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.subcontroller;

import oracle.bpm.designer.capability.edit.ExpandCollapseCapability;
import oracle.bpm.designer.capability.focus.FocusCapability;
import oracle.bpm.designer.controller.FlowNodeController;
import oracle.bpm.designer.subcontroller.LoopCharacteristicSubcontroller;
import oracle.bpm.designer.subcontroller.SubcontrollerImpl;
import oracle.bpm.draw.Color;
import oracle.bpm.draw.DesignerLayer;
import oracle.bpm.draw.DrawContext;
import oracle.bpm.draw.Graphics;
import oracle.bpm.draw.SubdrawableImpl;
import oracle.bpm.draw.msg.ProjectDrawMsg;
import oracle.bpm.geom.Point;
import oracle.bpm.geom.Rectangle;
import oracle.bpm.project.model.processes.Subprocess;
import oracle.bpm.project.model.util.ModelUtils;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Cursor;
import oracle.bpm.ui.Image;
import org.jetbrains.annotations.NotNull;

public class ExpandCollapseSubcontroller
extends SubcontrollerImpl<Subprocess> {
    private ExpandCollapseSubcontroller(@NotNull FlowNodeController<Subprocess> controller) {
        super(controller, new ExpandCollapseSubdrawable(controller));
        this.install(new FocusCapability(this));
        this.install(new ExpandCollapseCapability(this));
    }

    public static void appendTo(@NotNull FlowNodeController container) {
        if (ExpandCollapseSubcontroller.applies(container)) {
            new ExpandCollapseSubcontroller(container).add();
        }
    }

    public static boolean applies(@NotNull FlowNodeController controller) {
        return controller.getModelObject() instanceof Subprocess;
    }

    @Override
    @NotNull
    public Cursor getCursor() {
        return Cursor.HAND_CURSOR;
    }

    private static class ExpandCollapseSubdrawable
    extends SubdrawableImpl<Subprocess> {
        private boolean active;
        private Rectangle cache = Rectangle.ZERO;
        private final FlowNodeController<Subprocess> container;
        private static final Image EXPAND_IMAGE = Image.create((Msg)ProjectDrawMsg.EXPAND);
        private static final Image COLLAPSE_IMAGE = Image.create((Msg)ProjectDrawMsg.COLLAPSE);
        private static final int DISTANCE_GAP = 2;

        public ExpandCollapseSubdrawable(@NotNull FlowNodeController<Subprocess> container) {
            super(container.getDrawableObject(), (Object)container.getModelObject(), DesignerLayer.CAPABILITY);
            this.container = container;
        }

        public void draw(@NotNull DrawContext context) {
            Rectangle scaled = context.scaleRectangle(this.getBounds(context));
            Graphics graphics = context.getGraphics();
            Color original = graphics.getForeground();
            graphics.setForeground(Color.TRANSLUCENT);
            graphics.drawImage(this.getCurrentImage(), scaled);
            graphics.setForeground(original);
        }

        protected Rectangle createBounds(@NotNull DrawContext context) {
            this.setupWidthHeightAndLocation(context);
            return super.createBounds(context);
        }

        protected boolean needsUpdate() {
            DrawContext context = this.container.getDomain().getDrawContext();
            boolean result = super.needsUpdate();
            result = result || !this.cache.equals(this.container.getDrawableObject().getBounds(context));
            result = result || this.active != LoopCharacteristicSubcontroller.isActive(this.container);
            return result;
        }

        private Image getCurrentImage() {
            return ModelUtils.isCollapsed((Subprocess)this.container.getModelObject()) ? EXPAND_IMAGE : COLLAPSE_IMAGE;
        }

        private void setupWidthHeightAndLocation(DrawContext context) {
            Rectangle parent = this.container.getDrawableObject().getBounds(context);
            Image image = this.getCurrentImage();
            this.active = LoopCharacteristicSubcontroller.isActive(this.container);
            if (this.active) {
                this.locateAtCenterWithDelta(context, parent, image, 1);
            } else {
                this.locateAtCenterWithDelta(context, parent, image, 0);
            }
            this.cache = parent;
        }

        private void locateAtCenterWithDelta(@NotNull DrawContext context, @NotNull Rectangle parent, @NotNull Image image, int delta) {
            this.setWidth(context, image.getWidth());
            this.setHeight(context, image.getHeight());
            int dx = this.getWidth(context) / 2 + 1;
            Point location = new Point(parent.getCenterX(), parent.getMaxY()).translate(dx * delta, -this.getHeight(context) / 2 - 2);
            this.setLocation(location);
        }
    }
}

