/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.subcontroller;

import oracle.bpm.designer.capability.DrawableFeedback;
import oracle.bpm.designer.controller.FlowNodeController;
import oracle.bpm.designer.subcontroller.SubcontrollerImpl;
import oracle.bpm.draw.DesignerLayer;
import oracle.bpm.draw.DrawContext;
import oracle.bpm.draw.Drawable;
import oracle.bpm.draw.themes.ImageType;
import oracle.bpm.geom.Point;
import oracle.bpm.geom.Rectangle;
import oracle.bpm.project.model.processes.FlowElement;
import oracle.bpm.project.model.processes.NodeContainer;
import oracle.bpm.project.model.processes.StartEvent;
import oracle.bpm.project.model.processes.Subprocess;
import oracle.bpm.project.model.util.ModelUtils;
import oracle.bpm.ui.Image;
import org.jetbrains.annotations.NotNull;

public class EventDecorationSubcontroller
extends SubcontrollerImpl<Subprocess> {
    private EventDecorationSubcontroller(@NotNull FlowNodeController<Subprocess> container) {
        super(container, new EventSubprocessDecoration(container));
    }

    public static void appendTo(@NotNull FlowNodeController container) {
        if (EventDecorationSubcontroller.applies(container)) {
            new EventDecorationSubcontroller(container).add();
        }
    }

    public static boolean applies(@NotNull FlowNodeController controller) {
        boolean result = controller.getModelObject() instanceof Subprocess;
        if (result) {
            result = ((Subprocess)controller.getModelObject().asAnyNode(Subprocess.class)).isTriggeredByEvent();
        }
        return result;
    }

    public static class EventSubprocessDecoration
    extends DrawableFeedback<Subprocess> {
        private Point cached;
        private final Image image;
        private final FlowNodeController<Subprocess> owner;
        private static final int CORNER_GAP = 6;

        protected EventSubprocessDecoration(@NotNull FlowNodeController<Subprocess> container) {
            super((Drawable<?>)container.getDrawableObject(), container.getModelObject(), DesignerLayer.CAPABILITY);
            this.owner = container;
            this.image = this.createDecorationImage(container);
            this.setLocationForDecoration();
        }

        public void draw(@NotNull DrawContext context) {
            Rectangle bounds = this.getBounds(context).scaled(context.getScale());
            context.getGraphics().drawImage(this.image, bounds);
        }

        protected boolean needsUpdate() {
            return this.cached == null || !this.cached.equals(this.owner.getModelObject().getLocation()) || super.needsUpdate();
        }

        protected Rectangle createBounds(@NotNull DrawContext context) {
            this.setLocationForDecoration();
            return super.createBounds(context);
        }

        private Image createDecorationImage(FlowNodeController<Subprocess> container) {
            StartEvent start = ModelUtils.getStartEvent((NodeContainer)((NodeContainer)container.getModelObject()));
            DrawContext context = DrawContext.getDefault();
            return context.getTheme().getImageFor((FlowElement)start, ImageType.ICON);
        }

        private void setLocationForDecoration() {
            this.cached = this.owner.getModelObject().getLocation();
            DrawContext context = this.owner.getDomain().getDrawContext();
            this.setWidth(context, this.image.getWidth());
            this.setHeight(context, this.image.getHeight());
            Rectangle bounds = this.getOwnerBounds();
            this.setLocation(bounds.getOrigin().translate(this.getWidth(context) / 2 + 6, this.getHeight(context) / 2 + 6));
        }

        private Rectangle getOwnerBounds() {
            DrawContext context = this.owner.getDomain().getDrawContext();
            return this.owner.getDrawableObject().getBounds(context);
        }
    }
}

