/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.subcontroller;

import oracle.bpm.designer.capability.drag.AnchorMoveCapability;
import oracle.bpm.designer.capability.edit.ParentContainerEditCapability;
import oracle.bpm.designer.capability.focus.FocusCapability;
import oracle.bpm.designer.capability.selection.ParentContainerPopUpCapability;
import oracle.bpm.designer.capability.selection.ParentContainerSelectionCapability;
import oracle.bpm.designer.controller.ConnectionController;
import oracle.bpm.designer.subcontroller.SubcontrollerImpl;
import oracle.bpm.draw.DesignerLayer;
import oracle.bpm.draw.DrawContext;
import oracle.bpm.draw.DrawableHelper;
import oracle.bpm.draw.DrawableImpl;
import oracle.bpm.draw.Graphics;
import oracle.bpm.geom.Ellipse;
import oracle.bpm.geom.Path;
import oracle.bpm.geom.Point;
import oracle.bpm.geom.Rectangle;
import oracle.bpm.ui.Cursor;
import org.jetbrains.annotations.NotNull;

public class AnchorSubcontroller<T>
extends SubcontrollerImpl<T> {
    private final DrawableHelper.TransitionAnchor anchor;

    protected AnchorSubcontroller(@NotNull ConnectionController<T> controller, @NotNull DrawableHelper.TransitionAnchor anchor) {
        super(controller, new DrawableAnchor(controller, anchor));
        this.anchor = anchor;
        this.install(new FocusCapability(this));
        this.install(new AnchorMoveCapability(this));
        this.install(new ParentContainerPopUpCapability(this));
        this.install(new ParentContainerEditCapability(this));
        this.install(new ParentContainerSelectionCapability(this));
    }

    public static <T> void appendTo(@NotNull ConnectionController<T> controller, @NotNull DrawableHelper.TransitionAnchor anchor) {
        new AnchorSubcontroller<T>(controller, anchor).add();
    }

    @Override
    @NotNull
    public Cursor getCursor() {
        return Cursor.HAND_CURSOR;
    }

    public DrawableHelper.TransitionAnchor getAnchor() {
        return this.anchor;
    }

    @Override
    @NotNull
    public ConnectionController getContainer() {
        return (ConnectionController)super.getContainer();
    }

    private static class DrawableAnchor<T>
    extends DrawableImpl<T> {
        private final DrawableHelper.TransitionAnchor anchor;
        private final ConnectionController<T> container;
        private static final int ANCHOR_HIT_TOLERANCE = 8;

        private DrawableAnchor(@NotNull ConnectionController<T> container, @NotNull DrawableHelper.TransitionAnchor anchor) {
            super(container.getDrawableObject(), container.getModelObject(), DesignerLayer.CAPABILITY);
            this.container = container;
            this.anchor = anchor;
        }

        public boolean contains(int x, int y, @NotNull DrawContext context) {
            boolean result = this.anchor == DrawableHelper.TransitionAnchor.MIDDLE || this.getBounds(context).expand(8).contains(x, y);
            return result;
        }

        @NotNull
        public Rectangle getBounds(@NotNull DrawContext context) {
            Point location = this.getLocationInPath();
            return Rectangle.createAround(location, 8);
        }

        public void draw(@NotNull DrawContext context) {
            if (this.getContainer().isShowSelection() && this.anchor != DrawableHelper.TransitionAnchor.MIDDLE) {
                Graphics graphics = context.getGraphics();
                Rectangle bounds = this.getBounds(context);
                graphics.fill(new Ellipse(context.scaleRectangle(bounds)));
            }
        }

        private Point getLocationInPath() {
            Point result;
            Path path = this.container.getDrawableObject().getPath();
            switch (this.anchor) {
                case FROM: {
                    result = new Point(path.eval(0.0));
                    break;
                }
                case MIDDLE: {
                    result = new Point(path.eval(0.5));
                    break;
                }
                case TO: {
                    result = new Point(path.eval(1.0));
                    break;
                }
                default: {
                    result = Point.ORIGIN;
                }
            }
            return result;
        }
    }
}

