/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.simulation;

import fuego.simulation.ActivityInfo;
import fuego.simulation.Event;
import fuego.simulation.InteractiveActivityInfo;
import fuego.simulation.ModelSimulationImpl;
import fuego.simulation.ProcessRuntimeInfoInterface;
import fuego.simulation.ResourceInfo;
import fuego.simulation.Simulation;
import fuego.simulation.SimulationFlowNodeImpl;
import fuego.simulation.Token;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import oracle.bpm.bam.model.SimulationPhotoModel;
import oracle.bpm.bamdata.ProcessInfo;
import oracle.bpm.bamdata.Run;
import oracle.bpm.collections.Heap;
import oracle.bpm.collections.Sequence;
import oracle.bpm.project.ActivityImpl;
import oracle.bpm.project.LaneImpl;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.organization.CalendarRule;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.project.model.simulation.ModelEvent;
import oracle.bpm.project.model.simulation.ModelListener;
import oracle.bpm.project.model.simulation.ModelSimulation;
import oracle.bpm.project.model.simulation.ProjectSimulation;
import oracle.bpm.project.model.simulation.SimulationFlowNode;
import oracle.bpm.project.model.simulation.SimulationResource;
import oracle.bpm.project.model.simulation.SimulationSequenceFlow;
import oracle.bpm.project.model.util.ModelUtils;

public class StudioProjectSimulation
extends Simulation
implements ProcessRuntimeInfoInterface {
    private Queue<ActivityInfo> interactiveActivities = new LinkedList<ActivityInfo>();
    private Map<String, Process> processContentInfoMap = new HashMap<String, Process>();
    private Map<Process, Integer> processInstanceCountMap = new HashMap<Process, Integer>();
    private Map<Process, ModelSimulation> processModelMap = new HashMap<Process, ModelSimulation>();
    private Map<String, ActivityInfo> processRuntimeInfoMap = new HashMap<String, ActivityInfo>();
    private HashMap<String, ResourceInfo> resourcesInfoMap = new HashMap();

    public StudioProjectSimulation(ProjectSimulation projectSimulationModel) {
        super(projectSimulationModel);
        this.loadProcessesAndModels();
    }

    public ModelSimulation getModel(String processName) {
        return this.getProjectSimulation().findModelSimulation(processName);
    }

    public int getProcessInstanceCount(Process process) {
        return this.processInstanceCountMap.containsKey(process) ? this.processInstanceCountMap.get(process) : 0;
    }

    public void setProcessInstanceCountMap(Map<Process, Integer> processInstanceCountMap) {
        this.processInstanceCountMap = processInstanceCountMap;
    }

    public Map<Process, Integer> getProcessInstanceCountMap() {
        return this.processInstanceCountMap;
    }

    public ModelSimulation getProcessModel(Process process) {
        return this.processModelMap.get(process);
    }

    public void setProcessModelMap(Map<Process, ModelSimulation> processModelMap) {
        this.processModelMap = processModelMap;
    }

    public Map<Process, ModelSimulation> getProcessModelMap() {
        return this.processModelMap;
    }

    public void setProcessRuntimeInfo(String processName, ActivityInfo processInfo) {
        this.processRuntimeInfoMap.put(processName, processInfo);
    }

    public ProcessInfo getProcessRuntimeInfo(String processName) {
        if (processName != null) {
            Collection<ActivityInfo> collection = this.processRuntimeInfoMap.values();
            for (ActivityInfo aCollection : collection) {
                ProcessInfo processInfo = (ProcessInfo)aCollection;
                if (!processInfo.getName().equals(processName)) continue;
                return processInfo;
            }
        }
        return null;
    }

    public void addInteractiveActivity(InteractiveActivityInfo interactiveActivityInfo) {
        this.interactiveActivities.offer((ActivityInfo)interactiveActivityInfo);
    }

    public void setProcessRuntimeInfoMap(Map processRuntimeInfoMap) {
        this.processRuntimeInfoMap = processRuntimeInfoMap;
    }

    public Map getProcessRuntimeInfoMap() {
        return this.processRuntimeInfoMap;
    }

    public String[] getProcesses() {
        String[] processes = new String[this.processModelMap.size()];
        Iterator<Process> it = this.processModelMap.keySet().iterator();
        int i = 0;
        while (it.hasNext()) {
            Process process = it.next();
            processes[i] = process.getId();
            ++i;
        }
        return processes;
    }

    public String[] getProcessNames() {
        String[] processes = new String[this.processModelMap.size()];
        Iterator<Process> it = this.processModelMap.keySet().iterator();
        int i = 0;
        while (it.hasNext()) {
            Process fuegoProcess = it.next();
            processes[i] = fuegoProcess.getId();
            ++i;
        }
        return processes;
    }

    public SimulationPhotoModel getSimulationPhotoModel() {
        return new SimulationPhotoModel(this.processContentInfoMap, this.processRuntimeInfoMap);
    }

    public void generateFirstEvent(long wallClockStart) {
        this.startTime = this.getProjectSimulation().getStartTime();
        if (this.startTime == Long.MIN_VALUE) {
            this.startTime = wallClockStart;
        }
        if (this.eventQueue == null) {
            this.eventQueue = Heap.create();
        }
        this.eventQueue.clear();
        this.stopSimulation = false;
        this.simulationPaused = false;
        this.currentTime = this.startTime;
        for (Map.Entry<Process, ModelSimulation> entry : this.getProcessModelMap().entrySet()) {
            SimulationFlowNode[] startNodes;
            ModelSimulation simulationModel = entry.getValue();
            Process fuegoProcess = entry.getKey();
            String processName = fuegoProcess.getId();
            ProjectSimulation projectSimulationModel = this.getProjectSimulation();
            if (projectSimulationModel.findModelSimulationId(fuegoProcess.getId()) == null) continue;
            ActivityInfo activityInfo = (ActivityInfo)this.getProcessRuntimeInfoMap().get(processName);
            for (SimulationFlowNode s : startNodes = simulationModel.getAllBeginFlowNodes()) {
                Event event = Event.createGenerateEvent((long)this.currentTime, (int)this.getNextCategory(projectSimulationModel), (ProjectSimulation)this.getProjectSimulation(), (ModelSimulation)simulationModel, (ActivityInfo)activityInfo, (FlowNode)s.getFlowNode());
                this.eventQueue.offer(event);
            }
            this.processInstanceCountMap.put(fuegoProcess, startNodes.length);
        }
    }

    public void setCurrentSimulationModel(ModelSimulation model) {
        this.setCurrentSimulationModel(model, null);
    }

    public void setCurrentSimulationModel(ModelSimulation model, Simulation simulation) {
        ModelSimulationImpl impl = (ModelSimulationImpl)model;
        ProcessInfo[] processesInfo = null;
        if (simulation != null) {
            String[] processes = simulation.getProcessNames();
            processesInfo = new ProcessInfo[processes.length];
            for (int i = 0; i < processes.length; ++i) {
                String process = processes[i];
                ProcessInfo processInfo = simulation.getProcessRuntimeInfo(process);
                if (processInfo == null) continue;
                processesInfo[i] = processInfo;
                processesInfo[i].clearResources();
            }
        }
        oracle.bpm.util.CalendarRule calendarRule = null;
        Sequence calendarRules = impl.getProject().getOrganization().getCalendarRules();
        for (CalendarRule cr : calendarRules) {
            if (!cr.getOrganizationalUnits().isEmpty()) continue;
            calendarRule = new oracle.bpm.util.CalendarRule(cr.getWorkWeek(), cr.getTimeZone(), cr.getHolidayRuleAssignment() != null && cr.getHolidayRuleAssignment().getHolidayRule() != null ? cr.getHolidayRuleAssignment().getHolidayRule().getHolidayCalendar() : null);
            break;
        }
        for (SimulationFlowNode simulationActivity : model.getSimulationFlowNodes()) {
            SimulationFlowNodeImpl activity = (SimulationFlowNodeImpl)simulationActivity;
            activity.clearResources();
            FlowNode nodeInfo = impl.getProcess().findNode(activity.getId());
            if (nodeInfo == null) continue;
            LaneImpl role = (LaneImpl)nodeInfo.getLane();
            if (role != null) {
                Collection profiles = impl.getCurrentProjectSimulation().getResourcesAssignedToRole(role.getId());
                activity.getAvailableResources().clear();
                for (SimulationResource simulationResource : profiles) {
                    simulationActivity.addResource(simulationResource);
                    if (processesInfo == null) continue;
                    ResourceInfo resourceInfo = simulation.getResourceInfo(simulation, impl.getCurrentProjectSimulation(), simulationResource);
                    for (int j = 0; j < processesInfo.length && processesInfo[j] != null; ++j) {
                        if (processesInfo[j].containsResourceInfo(simulationResource.getId())) continue;
                        processesInfo[j].addResourceInfo(resourceInfo.getName(), resourceInfo);
                    }
                }
            }
            activity.setCalendarRule(calendarRule);
        }
    }

    public void runSimulation() {
        Token.setNextId((int)0);
        this.setListeners();
        long wallClockStart = System.currentTimeMillis() * 1000L;
        this.generateFirstEvent(wallClockStart);
        int totalProjectInstances = 0;
        this.simulate(wallClockStart, totalProjectInstances);
        this.terminateSimulation();
        this.removeListeners();
    }

    public void syncResources() {
        Collection<ModelSimulation> modelSimulations = this.processModelMap.values();
        for (ModelSimulation modelSimulation : modelSimulations) {
            this.setCurrentSimulationModel(modelSimulation);
        }
    }

    public void simulate(long wallClockStart, int totalProjectInstances) {
        while (!this.stopSimulation && !this.eventQueue.isEmpty()) {
            Event currentEvent = (Event)this.eventQueue.remove();
            long newTime = currentEvent.getDueTime();
            long simulationElapsedTime = newTime - this.startTime;
            boolean timeUp = simulationElapsedTime > currentEvent.getToken().getProjectSimulation().getDurationMicroseconds();
            boolean letInflightFinish = currentEvent.getToken().getProjectSimulation().getInflightFinish();
            if (timeUp && !letInflightFinish) continue;
            if (this.performingAnimation && newTime > this.currentTime) {
                double scale = this.getTimeScalePct();
                long sleepTime = (long)(5000.0 / scale);
                this.letsTimePass(sleepTime);
                if (this.stopSimulation) break;
            }
            this.currentTime = newTime;
            this.checkPause();
            if (this.simulationPauseEndTime != 0L) {
                this.pausedTime = this.simulationPauseEndTime - this.simulationPauseStartTime;
                wallClockStart += this.pausedTime;
                this.simulationPauseEndTime = 0L;
                this.simulationPauseStartTime = 0L;
            }
            switch (currentEvent.getType()) {
                case 7: {
                    totalProjectInstances = this.processGenerate(currentEvent, true, totalProjectInstances, timeUp);
                    break;
                }
                case 1: {
                    totalProjectInstances = this.processGenerate(currentEvent, false, totalProjectInstances, timeUp);
                    break;
                }
                case 2: 
                case 6: {
                    this.processMove(currentEvent);
                    break;
                }
                case 3: {
                    this.processTerminate(currentEvent);
                }
            }
            this.fireEventDue(currentEvent);
        }
    }

    public ResourceInfo getResourceInfo(Simulation simulation, ProjectSimulation projectSimulationModel, SimulationResource simulationResource) {
        ResourceInfo resourceInfo = this.resourcesInfoMap.get(simulationResource.getId());
        if (resourceInfo == null) {
            resourceInfo = new ResourceInfo((Run)simulation, projectSimulationModel, simulationResource.getId(), simulationResource.getCapacity(), simulationResource.getCost());
            this.resourcesInfoMap.put(resourceInfo.getName(), resourceInfo);
        }
        return resourceInfo;
    }

    public void updateCurrentSimulationModel(ModelSimulation modelSimulation) {
        this.removeActivitiesFromModelSimulation(modelSimulation);
        this.addActivitiesToModelSimulation(modelSimulation);
        this.removeTransitionsFromModelSimulation(modelSimulation);
        this.addTransitionsToModelSimulation(modelSimulation);
    }

    protected Token checkIfLeavingGroups(Token token, FlowNode from, FlowNode to, SequenceFlow transition) {
        if (ModelUtils.isExceptionFlow((SequenceFlow)transition) || ModelUtils.isDueFlow((SequenceFlow)transition) || ModelUtils.isEndEvent((FlowNode)to)) {
            ActivityImpl parentGroup = (ActivityImpl)StudioProjectSimulation.getParentGroup((FlowNode)from);
            if (token.getParent() != null && parentGroup != null && !parentGroup.equals(StudioProjectSimulation.getParentGroup((FlowNode)to))) {
                token.remove();
                token = token.getParent();
                ActivityInfo parentGroupInfo = (ActivityInfo)this.getProcessRuntimeInfo(parentGroup.getProcess().getId()).getActivity(parentGroup.getId());
                parentGroupInfo.remove(token, false);
                this.fireEventDue(Event.createMoveEvent((Token)token, (long)this.currentTime, (FlowNode)parentGroup, (FlowNode)to, null, (boolean)false));
                return this.checkIfLeavingGroups(token, (FlowNode)parentGroup, to, transition);
            }
        }
        return token;
    }

    protected void resourceCapacityChanged(ModelEvent e, List<ActivityInfo> activities) {
        for (ActivityInfo activityInfo : this.processRuntimeInfoMap.values()) {
            this.resourceCapacityChanged(e, activities, (ProcessInfo)activityInfo);
        }
    }

    private void processTerminate(Event currentEvent) {
        Token token = currentEvent.getToken();
        FlowNode endNode = currentEvent.getFrom();
        ActivityInfo simActivity = (ActivityInfo)token.getProcessInfo().getActivity(endNode.getId());
        ModelSimulation modelSimulation = token.getModel();
        SimulationFlowNodeImpl endActivity = null;
        try {
            endActivity = (SimulationFlowNodeImpl)this.addSimulationActivity(modelSimulation, (FlowNode)simActivity.getFuegoActivity());
        }
        catch (ProjectException e) {
            throw new RuntimeException(e);
        }
        assert (endActivity != null) : "End activity cannot be null";
        simActivity.remove(token);
        token.getProcessInfo().terminateInstance(token.getCreationTime(), token.getCategory());
    }

    private void processMove(Event currentEvent) {
        ActivityInfo simActivity;
        FlowNode node;
        Token token = currentEvent.getToken();
        if (currentEvent.isFirstStep()) {
            node = currentEvent.getFrom();
            simActivity = (ActivityInfo)token.getProcessInfo().getActivity(node.getId());
            SequenceFlow t = currentEvent.getTransition();
            simActivity.remove(token, t != null && !ModelUtils.isExceptionFlow((SequenceFlow)t));
            token = this.checkIfLeavingGroups(token, node, currentEvent.getTo(), t);
            currentEvent.setToken(token);
            List<Token> activitiesToActivate = this.getActivitiesToActivate(simActivity);
            for (Token next : activitiesToActivate) {
                if (next == null) continue;
                ModelSimulation modelSimulation = token.getModel();
                try {
                    SimulationFlowNode simulationActivity = this.addSimulationActivity(modelSimulation, (FlowNode)next.getActivityInfo().getFuegoActivity());
                    ((SimulationFlowNodeImpl)simulationActivity).scheduleMove(this.currentTime, next, this.eventQueue, this.random);
                }
                catch (ProjectException e) {
                    e.printStackTrace();
                }
            }
        }
        if (this.performingAnimation && !currentEvent.isLastStep()) {
            this.eventQueue.offer(Event.createMoveStep((Event)currentEvent, (int)this.stepIncrement));
        } else {
            node = currentEvent.getTo();
            simActivity = (ActivityInfo)token.getProcessInfo().getActivity(node.getId());
            if (!simActivity.queue(token)) {
                SimulationFlowNodeImpl simulationActivityImpl = (SimulationFlowNodeImpl)token.getModel().findSimulationFlowNode(node.getId());
                if (ModelUtils.isEndEvent((FlowNode)node)) {
                    simulationActivityImpl.scheduleTerminate(this.currentTime, token, this.eventQueue, this.random);
                } else {
                    simulationActivityImpl.scheduleMove(this.currentTime, token, this.eventQueue, this.random);
                }
            }
        }
    }

    private SimulationFlowNode addSimulationActivity(ModelSimulation modelSimulation, FlowNode node) throws ProjectException {
        SimulationFlowNode simulationActivity = modelSimulation.findSimulationFlowNode(node.getId());
        if (simulationActivity == null) {
            simulationActivity = modelSimulation.createSimulationFlowNode(node.getId());
            modelSimulation.addSimulationFlowNode(simulationActivity);
        }
        return simulationActivity;
    }

    private List<Token> getActivitiesToActivate(ActivityInfo simActivity) {
        InteractiveActivityInfo interactiveActivityInfo;
        if (simActivity instanceof InteractiveActivityInfo && (interactiveActivityInfo = (InteractiveActivityInfo)simActivity).isUseOrgResources()) {
            ArrayList<Token> result = new ArrayList<Token>();
            for (int i = 0; i < this.interactiveActivities.size() && result.size() == 0; ++i) {
                ActivityInfo activityInfo = this.interactiveActivities.poll();
                result.addAll(activityInfo.activate());
                this.interactiveActivities.offer(activityInfo);
            }
            return result;
        }
        return simActivity.activate();
    }

    private int processGenerate(Event currentEvent, boolean ipc, int totalProjectInstances, boolean timeUp) {
        Token token = currentEvent.getToken();
        FlowNode startNode = currentEvent.getFrom();
        ActivityInfo simActivity = (ActivityInfo)token.getProcessInfo().getActivity(startNode.getId());
        ModelSimulation modelSimulation = token.getModel();
        SimulationFlowNodeImpl beginActivity = null;
        try {
            beginActivity = (SimulationFlowNodeImpl)this.addSimulationActivity(modelSimulation, (FlowNode)simActivity.getFuegoActivity());
        }
        catch (ProjectException e) {
            throw new RuntimeException(e);
        }
        assert (beginActivity != null) : "Begin activity cannot be null";
        if (!simActivity.queue(token)) {
            beginActivity.scheduleMove(this.currentTime, token, this.eventQueue, this.random);
        }
        token.getProcessInfo().createInstance(token.getCategory(), this.currentTime);
        Process process = token.getModel().getProject().findProcess(token.getModel().getProcess().getId());
        int totalInstances = this.getProcessInstanceCount(process);
        if (!(timeUp || ipc || token.getModel().getUseMaxInstances() && totalInstances > token.getModel().getMaxInstances())) {
            Event event = Event.createGenerateEvent((long)this.getNextIAT((SimulationFlowNode)beginActivity), (int)this.getNextCategory(this.getProjectSimulation()), (ProjectSimulation)token.getProjectSimulation(), (ModelSimulation)token.getModel(), (ActivityInfo)token.getProcessInfo(), (FlowNode)startNode);
            ++totalProjectInstances;
            this.processInstanceCountMap.put(process, ++totalInstances);
            this.eventQueue.offer(event);
        }
        return totalProjectInstances;
    }

    private void setListeners() {
        for (ModelSimulation simulationModel : this.getProcessModelMap().values()) {
            simulationModel.addListener((ModelListener)this);
        }
    }

    private void load(Process fuegoProcess, ModelSimulation modelSimulation) {
        this.processModelMap.put(fuegoProcess, modelSimulation);
        this.processInstanceCountMap.put(fuegoProcess, 0);
        this.processContentInfoMap.put(fuegoProcess.getId(), fuegoProcess);
        ActivityInfo processRuntimeInfo = ActivityInfo.create((Run)this, (ProjectSimulation)this.getProjectSimulation(), (ModelSimulation)modelSimulation, (String)fuegoProcess.getId(), (String[])this.getProjectSimulation().getCategoryLabels());
        this.processRuntimeInfoMap.put(fuegoProcess.getId(), processRuntimeInfo);
        for (FlowNode node : fuegoProcess.getFlowNodes()) {
            if (!ModelUtils.isCallActivity((FlowNode)node)) continue;
            try {
                SimulationFlowNodeImpl simulationActivityImpl = (SimulationFlowNodeImpl)this.addSimulationActivity(modelSimulation, node);
            }
            catch (ProjectException e) {
                e.printStackTrace();
            }
        }
        this.updateCurrentSimulationModel(modelSimulation);
    }

    private void loadProcessesAndModels() {
        Collection modelSimulations = this.getProjectSimulation().getModelSimulations();
        if (modelSimulations != null) {
            for (ModelSimulation modelSimulation : modelSimulations) {
                this.load(modelSimulation.getProcess(), modelSimulation);
            }
        }
    }

    private void addTransitionsToModelSimulation(ModelSimulation modelSimulation) {
        ((ModelSimulationImpl)modelSimulation).addTransitions(modelSimulation.getProcess().getSequenceFlows());
    }

    private void removeTransitionsFromModelSimulation(ModelSimulation modelSimulation) {
        ArrayList<SimulationSequenceFlow> transitionsToRemove = new ArrayList<SimulationSequenceFlow>();
        Process model = modelSimulation.getProcess();
        for (SimulationSequenceFlow sequenceFlowModel : modelSimulation.getSimulationSequenceFlows()) {
            SequenceFlow transition = model.findSequenceFlow(sequenceFlowModel.getId());
            if (transition != null) continue;
            transitionsToRemove.add(sequenceFlowModel);
        }
        Iterator i$ = transitionsToRemove.iterator();
        while (i$.hasNext()) {
            SimulationSequenceFlow aTransitionsToRemove;
            SimulationSequenceFlow sequenceFlowModel = aTransitionsToRemove = (SimulationSequenceFlow)i$.next();
            try {
                modelSimulation.removeSequenceFlow(sequenceFlowModel);
            }
            catch (ProjectException e) {
                e.printStackTrace();
            }
        }
    }

    private void addActivitiesToModelSimulation(ModelSimulation modelSimulation) {
        Process model1 = modelSimulation.getProcess();
        for (FlowNode node : model1.getFlowNodes()) {
            SimulationFlowNode simulationActivity = modelSimulation.findSimulationFlowNode(node.getId());
            if (simulationActivity == null) {
                simulationActivity = modelSimulation.createSimulationFlowNode(node.getId());
                try {
                    modelSimulation.addSimulationFlowNode(simulationActivity);
                }
                catch (ProjectException e) {
                    e.printStackTrace();
                }
            }
            if (!(simulationActivity instanceof SimulationFlowNodeImpl)) continue;
            SimulationFlowNodeImpl model = (SimulationFlowNodeImpl)simulationActivity;
            model.addListener((ModelListener)((ModelSimulationImpl)modelSimulation));
        }
    }

    private void removeActivitiesFromModelSimulation(ModelSimulation modelSimulation) {
        Process model = modelSimulation.getProcess();
        Collection activityModelIterator = modelSimulation.getSimulationFlowNodes();
        ArrayList<SimulationFlowNode> activitiesToRemove = new ArrayList<SimulationFlowNode>();
        for (SimulationFlowNode simulationActivity : activityModelIterator) {
            FlowNode node = model.findNode(simulationActivity.getId());
            if (node != null) continue;
            activitiesToRemove.add(simulationActivity);
        }
        for (SimulationFlowNode anActivitiesToRemove : activitiesToRemove) {
            SimulationFlowNodeImpl simulationActivityImpl = (SimulationFlowNodeImpl)anActivitiesToRemove;
            try {
                modelSimulation.removeSimulationFlowNode((SimulationFlowNode)simulationActivityImpl);
            }
            catch (ProjectException e) {
                e.printStackTrace();
            }
        }
    }

    private void removeListeners() {
        for (ModelSimulation simulationModel : this.getProcessModelMap().values()) {
            simulationModel.removeListener((ModelListener)this);
        }
    }
}

