/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.simulation;

import fuego.simulation.Simulation;
import java.util.EnumSet;
import oracle.bpm.collections.Sequence;
import oracle.bpm.designer.AbstractStudioWorkbench;
import oracle.bpm.designer.Context;
import oracle.bpm.designer.ProcessDomain;
import oracle.bpm.designer.controller.ActivityController;
import oracle.bpm.designer.controller.ControllerUtils;
import oracle.bpm.designer.controller.FlowElementController;
import oracle.bpm.designer.controller.SequenceFlowController;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.simulation.SimulationAction;
import oracle.bpm.designer.simulation.SimulationControlPanel;
import oracle.bpm.designer.simulation.SimulationRunnerAction;
import oracle.bpm.designer.simulation.StudioSimulationUtils;
import oracle.bpm.draw.DesignerLayer;
import oracle.bpm.log.Log;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.UiUtilities;
import org.jetbrains.annotations.NotNull;

class StopSimulationAction
extends SimulationAction {
    static final long serialVersionUID = -5225023702384667938L;
    static final long serialCheck = 3112141266923576575L;

    public StopSimulationAction(SimulationControlPanel panel) {
        super(DesignerMsg.STOP_SIMULATION, panel);
    }

    @Override
    public boolean doIt() {
        if (AbstractStudioWorkbench.getInstance().getSimulation() != null) {
            this.stopIt();
            AbstractStudioWorkbench.getInstance().setSimulation(null);
            return true;
        }
        Log.logWarning(Msg.QUOTE("Trying to STOP a null Simulation"));
        return false;
    }

    private void stopIt() {
        final SimulationControlPanel panel = this.getPanel();
        panel.enableButtons(SimulationRunnerAction.STOP);
        UiUtilities.invokeAndWait((Runnable)new Runnable(){

            @Override
            public void run() {
                StopSimulationAction.this.disableAnimation(panel);
                panel.flushLogBuffer();
            }
        });
        panel.getSimulation().stopSimulation();
        StudioSimulationUtils.clear();
        if (UiUtilities.isEventDispatchThread()) {
            panel.redraw();
        } else {
            UiUtilities.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    panel.redraw();
                }
            });
        }
    }

    private void disableAnimation(SimulationControlPanel panel) {
        String[] processes;
        Simulation simulation = panel.getSimulation();
        for (String process : processes = simulation.getProcesses()) {
            Process content = panel.getProjectSimulationModel().getProject().findProcess(process);
            final ProcessDomain domain = Context.getDomainFor(content);
            if (content == null || domain == null) continue;
            domain.setShowAnimation(false);
            this.resetSimulation(domain);
            if (UiUtilities.isEventDispatchThread()) {
                domain.getCanvas().repaint();
                continue;
            }
            UiUtilities.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    domain.getCanvas().repaint();
                }
            });
        }
    }

    private void resetSimulation(@NotNull ProcessDomain domain) {
        EnumSet<DesignerLayer> layers = EnumSet.of(DesignerLayer.FLOW_NODE, DesignerLayer.EVENT, DesignerLayer.SUBPROCESS, DesignerLayer.TRANSITION);
        Sequence<FlowElementController> controllers = ControllerUtils.getControllersAtLayersRecursive(domain.getCanvas().getProcessController(), layers);
        for (FlowElementController controller : controllers) {
            if (controller instanceof ActivityController) {
                ((ActivityController)controller).resetSimulation();
                continue;
            }
            if (!(controller instanceof SequenceFlowController)) continue;
            ((SequenceFlowController)controller).resetSimulation();
        }
    }
}

