/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.simulation;

import java.util.Collection;
import oracle.bpm.bamdata.ActivityInfo;
import oracle.bpm.bamdata.ProcessInfo;
import oracle.bpm.bamdata.ResourceInfo;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.draw.Color;
import oracle.bpm.draw.Graphics;
import oracle.bpm.geom.Dimension;
import oracle.bpm.project.model.simulation.ProjectSimulation;
import oracle.bpm.project.model.simulation.SimulationResource;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.ScrollPane;
import oracle.bpm.ui.ScrollPolicy;
import oracle.bpm.ui.Separator;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiUtilities;
import oracle.bpm.ui.border.BorderFactory;
import oracle.bpm.ui.event.ChangeEvent;
import oracle.bpm.ui.event.ChangeListener;
import oracle.bpm.ui.layout.BoxLayout;
import oracle.bpm.ui.layout.FlowLayout;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.text.NumericField;

class SimulationRunTimeResourcePanel
extends Panel {
    private Color activityColor = Color.BLUE.brighter();
    private ActivityInfo activityInfo;
    private Panel labelBarPanel;
    private ParticipantPanel participantPanel;
    private Color processColor = Color.GREEN.brighter();
    private ProcessInfo processInfo;
    private Panel resourcePanel;
    private ScrollPane scrollPane;
    private ProjectSimulation simulationModel;

    public SimulationRunTimeResourcePanel(UiContainer parent, ActivityInfo activityInfo, ProcessInfo processInfo, ProjectSimulation simulationModel) {
        super(parent);
        this.activityInfo = activityInfo;
        this.processInfo = processInfo;
        this.simulationModel = simulationModel;
    }

    public Dimension getScrollPaneSize() {
        int size = this.activityInfo.getResources().values().size();
        int height = 0;
        if (size > 0) {
            height = (int)((double)this.participantPanel.getPreferredSize().getHeight() * 0.9);
        }
        int width = this.getPreferredSize().getWidth();
        return Dimension.valueOf(width, size <= 4 ? size * height : 4 * height);
    }

    public Dimension getPanelSize() {
        Dimension scrollDimension = this.getScrollPaneSize();
        return Dimension.valueOf(scrollDimension.getWidth(), scrollDimension.getHeight() + this.labelBarPanel.getPreferredSize().getHeight());
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.scrollPane.setExactSize(this.getScrollPaneSize());
            this.setExactSize(this.getPanelSize());
        }
    }

    public void init() {
        Panel container = new Panel((UiContainer)this);
        container.setLayout((Layout)new BorderLayout());
        this.add((UiComponent)container);
        this.scrollPane = new ScrollPane((UiContainer)container, ScrollPolicy.AS_NEEDED, ScrollPolicy.ALWAYS);
        this.resourcePanel = new Panel((UiContainer)this.scrollPane);
        this.resourcePanel.setLayout((Layout)new BoxLayout((UiContainer)this.resourcePanel, 1));
        this.resourcePanel.setBackground(this.getBackground());
        Collection resourcesCollection = this.activityInfo.getResources().values();
        for (Object aResourcesCollection : resourcesCollection) {
            ResourceInfo resourceInfo = (ResourceInfo)aResourcesCollection;
            int activityPercentage = resourceInfo.getRunningInfo().getPercentageBusyTime();
            int processPercentage = this.processInfo.getResourceInfo(resourceInfo.getName()).getRunningInfo().getPercentageBusyTime();
            int number = resourceInfo.getRunningInfo().getCount();
            this.participantPanel = new ParticipantPanel((UiContainer)this.resourcePanel);
            this.participantPanel.setBackground(this.getBackground());
            this.participantPanel.init();
            this.participantPanel.setInitialValues(resourceInfo.getName(), activityPercentage, processPercentage, number);
            this.participantPanel.setChangeListener(new ParticipantChangeListener(resourceInfo));
            this.resourcePanel.add((UiComponent)this.participantPanel);
            this.resourcePanel.add((UiComponent)new Separator((UiContainer)this.resourcePanel, Separator.VERTICAL));
        }
        this.scrollPane.setView((UiComponent)this.resourcePanel);
        this.scrollPane.setBorder(null);
        this.scrollPane.setBackground(this.getBackground());
        this.labelBarPanel = this.createLabelBarPanel((UiContainer)container, resourcesCollection.size() > 0);
        container.add((UiComponent)this.labelBarPanel, (Object)"North");
        container.add((UiComponent)this.scrollPane, (Object)"Center");
        this.setBorder(BorderFactory.createLineBorder((Color)Color.GRAY));
    }

    public void update() {
        Runnable runnnable = new Runnable(){

            @Override
            public void run() {
                if (!SimulationRunTimeResourcePanel.this.isDisposed()) {
                    SimulationRunTimeResourcePanel.this.updatePanel();
                }
            }
        };
        if (UiUtilities.isEventDispatchThread()) {
            runnnable.run();
        } else {
            UiUtilities.invokeLater((Runnable)runnnable);
        }
    }

    private void updatePanel() {
        for (int i = 0; i < this.resourcePanel.getComponentCount(); ++i) {
            if (!(this.resourcePanel.getComponent(i) instanceof ParticipantPanel)) continue;
            ParticipantPanel participantPanel = (ParticipantPanel)this.resourcePanel.getComponent(i);
            participantPanel.setProcessPercentage(this.processInfo.getResourceInfo(participantPanel.getName()).getRunningInfo().getPercentageBusyTime());
            participantPanel.setActivityPercentage(this.activityInfo.getResourceInfo(participantPanel.getName()).getRunningInfo().getPercentageBusyTime());
            participantPanel.setNumber(this.processInfo.getResourceInfo(participantPanel.getName()).getRunningInfo().getCount());
        }
        this.resourcePanel.invalidate();
        this.resourcePanel.repaint();
    }

    private void changeCapacity(ResourceInfo resourceInfo, int value) {
        SimulationResource resourcesModel = this.simulationModel.findResource(resourceInfo.getName());
        if (resourcesModel != null) {
            resourcesModel.setCapacity(value);
        }
    }

    private Panel createLabelBarPanel(UiContainer parent, boolean hasResources) {
        Panel labelBarPanel = new Panel(parent);
        labelBarPanel.setBorder(BorderFactory.createLineBorder((Color)Color.valueOf((int)255, (int)0, (int)0)));
        labelBarPanel.setLayout((Layout)new BoxLayout((UiContainer)labelBarPanel, 1));
        if (hasResources) {
            Label labelActivity = new Label((UiContainer)labelBarPanel);
            labelActivity.setIndicatorColor(this.activityColor);
            labelActivity.setDescription(DesignerMsg.SIMULATION_PCT_TIME_ACTIVITY.getString());
            Label labelProcess = new Label((UiContainer)labelBarPanel);
            labelProcess.setIndicatorColor(this.processColor);
            labelProcess.setDescription(DesignerMsg.SIMULATION_PCT_TIME_PROCESS.getString());
            labelBarPanel.add((UiComponent)labelActivity);
            labelBarPanel.add((UiComponent)labelProcess);
        } else {
            Label labelNoResources = new Label((UiContainer)labelBarPanel);
            labelNoResources.setDescription(DesignerMsg.SIMULATION_NO_ACTIVITY_RESOURCES.getString());
            labelBarPanel.add((UiComponent)labelNoResources);
        }
        return labelBarPanel;
    }

    private class ParticipantPanel
    extends Panel {
        private Bar activityPercentageBar;
        private Panel bars;
        private ChangeListener changeListener;
        private oracle.bpm.ui.Label name;
        private NumericField<Integer> number;
        private Bar processPercentageBar;

        ParticipantPanel(UiContainer parent) {
            super(parent);
        }

        public void setActivityPercentage(int p) {
            this.activityPercentageBar.setPercentage(p);
        }

        public void setChangeListener(ChangeListener changeListener) {
            this.changeListener = changeListener;
            this.number.removeChangeListener(changeListener);
            this.number.addChangeListener(changeListener);
        }

        public void setInitialValues(String name, int activityPercentage, int processPercentage, int number) {
            this.setName(name);
            this.setActivityPercentage(activityPercentage);
            this.setProcessPercentage(processPercentage);
            this.setNumber(number);
        }

        public void setName(String name) {
            this.name.setText(name);
        }

        public String getName() {
            return this.name.getText();
        }

        public void setNumber(int number) {
            this.number.setValue((Number)number);
        }

        public void setProcessPercentage(int p) {
            this.processPercentageBar.setPercentage(p);
        }

        public void init() {
            this.name = oracle.bpm.ui.Label.create((UiContainer)this);
            this.name.setPreferredSize(Dimension.valueOf(60, 20));
            this.name.setBackground(Color.WHITE);
            this.number = NumericField.createIntegerNumericField((UiContainer)this);
            this.number.setColumns(6);
            this.bars = new Panel((UiContainer)this);
            this.bars.setLayout((Layout)new FlowLayout(2));
            this.bars.setBackground(this.getBackground());
            this.activityPercentageBar = this.createActivityBar((UiContainer)this.bars);
            this.processPercentageBar = this.createProcessBar((UiContainer)this.bars);
            this.activityPercentageBar.setBackground(this.getBackground());
            this.processPercentageBar.setBackground(this.getBackground());
            this.bars.add((UiComponent)this.activityPercentageBar);
            this.bars.add((UiComponent)this.processPercentageBar);
            this.setLayout((Layout)new FlowLayout(0));
            this.setBorder(BorderFactory.createLineBorder((Color)Color.GRAY));
            this.add((UiComponent)this.name);
            this.add((UiComponent)this.number);
            this.add((UiComponent)this.bars);
        }

        private Bar createActivityBar(UiContainer parent) {
            return this.createBar(parent, SimulationRunTimeResourcePanel.this.activityColor);
        }

        private Bar createBar(UiContainer parent, Color mainColor) {
            Bar bar = new Bar(parent, 50, Dimension.valueOf(50, 20), mainColor, Color.GRAY);
            bar.setExactSize(Dimension.valueOf(65, 60));
            bar.setBorder(BorderFactory.createLineBorder((Color)Color.GRAY));
            return bar;
        }

        private Bar createProcessBar(UiContainer parent) {
            return this.createBar(parent, SimulationRunTimeResourcePanel.this.processColor);
        }
    }

    private class ParticipantChangeListener
    implements ChangeListener {
        private final ResourceInfo resourceInfo;

        public ParticipantChangeListener(ResourceInfo resourceInfo) {
            this.resourceInfo = resourceInfo;
        }

        public void stateChanged(ChangeEvent e) {
            NumericField numericSpinner = (NumericField)e.getSource();
            final int value = (Integer)numericSpinner.getValue();
            Runnable runnuble = new Runnable(){

                @Override
                public void run() {
                    SimulationRunTimeResourcePanel.this.changeCapacity(ParticipantChangeListener.this.resourceInfo, value);
                }
            };
            if (UiUtilities.isEventDispatchThread()) {
                runnuble.run();
            } else {
                UiUtilities.invokeLater((Runnable)runnuble);
            }
        }
    }

    private static class Bar
    extends Panel {
        private Panel container = null;
        private Dimension dimension = null;
        private Panel mainBar = null;
        private Color mainColor = null;
        private int percentage = 0;
        private Label percentageLabel = null;
        private Color secondaryColor = null;

        Bar(UiContainer parent, int percentage, Dimension dimension, Color mainColor, Color secondaryColor) {
            super(parent);
            this.percentage = percentage;
            this.dimension = dimension;
            this.mainColor = mainColor;
            this.secondaryColor = secondaryColor;
            this.init();
        }

        public void setPercentage(int p) {
            if (p > 100 || p < 0) {
                return;
            }
            this.percentage = p;
            this.updateBar();
        }

        private void init() {
            Panel globalContainer = new Panel((UiContainer)this);
            globalContainer.setForeground(Color.GRAY);
            globalContainer.setBackground(Color.GRAY);
            globalContainer.setLayout((Layout)new BorderLayout());
            this.container = new Panel((UiContainer)globalContainer);
            this.container.setForeground(Color.GRAY);
            this.container.setBackground(Color.GRAY);
            this.container.setLayout((Layout)new BorderLayout());
            this.mainBar = new Panel((UiContainer)this.container);
            this.mainBar.setBackground(Color.GRAY);
            this.mainBar.setForeground(Color.GRAY);
            this.container.setExactSize(this.dimension);
            this.container.add((UiComponent)this.mainBar, (Object)"West");
            this.percentageLabel = new Label((UiContainer)globalContainer);
            globalContainer.add((UiComponent)this.percentageLabel, (Object)"North");
            globalContainer.add((UiComponent)this.container, (Object)"Center");
            this.updateBar();
            this.add((UiComponent)globalContainer);
        }

        private void updateBar() {
            this.mainBar.setExactSize(Dimension.valueOf(this.dimension.getWidth(), this.dimension.getHeight()));
            Graphics graphics = this.mainBar.getGraphics();
            graphics.setForeground(this.secondaryColor);
            graphics.fillRect(0, 0, this.dimension.getWidth(), this.dimension.getHeight());
            graphics.setForeground(this.mainColor);
            graphics.fillRect(0, 0, this.dimension.getWidth() * this.percentage / 100, this.dimension.getHeight());
            graphics.dispose();
            this.percentageLabel.setDescription(String.valueOf(this.percentage) + "%");
        }
    }

    public static class Label
    extends Panel {
        private oracle.bpm.ui.Label description;
        private oracle.bpm.ui.Label indicator;

        public Label(UiContainer parent) {
            super(parent);
            this.setLayout((Layout)new FlowLayout(0));
            this.indicator = oracle.bpm.ui.Label.create((UiContainer)this);
            this.indicator.setPreferredSize(Dimension.valueOf(10, 10));
            this.indicator.setOpaque(true);
            this.description = oracle.bpm.ui.Label.create((UiContainer)this);
            this.add((UiComponent)this.indicator);
            this.add((UiComponent)this.description);
        }

        public void setDescription(String s) {
            this.description.setText(s);
        }

        public void setIndicatorColor(Color c) {
            this.indicator.setBackground(c);
        }
    }
}

