/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.simulation;

import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.lang.InputValidationException;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.ui.InputValidator;
import oracle.bpm.util.Identifier;

public class SimulationModelNameInputValidator
implements InputValidator {
    private Process process;
    private static final int IDENTIFIER_MAX_LENGTH = 128;

    public SimulationModelNameInputValidator(Process process) {
        this.process = process;
    }

    @Override
    public void validate(String name) throws InputValidationException {
        InputValidationException.assertTrue(Identifier.isValid(name) && name.indexOf(95) == -1, DesignerMsg.INVALID_SIMULATION_MODEL_IDENTIFIER);
        InputValidationException.assertTrue(name.trim().length() <= 128, DesignerMsg.IDENTIFIER_TOO_LONG(128));
        if (this.process != null) {
            InputValidationException.assertTrue(this.process.getProject().getSimulations().findModelSimulation(this.process, name) == null, DesignerMsg.MODEL_SIMULATION_EXISTS);
        }
    }
}

