/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.simulation;

import oracle.bpm.designer.AbstractStudioWorkbench;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.simulation.SimulationAction;
import oracle.bpm.designer.simulation.SimulationControlPanel;
import oracle.bpm.designer.simulation.SimulationRunnerAction;
import oracle.bpm.designer.simulation.StartSimulationAction;
import oracle.bpm.designer.simulation.StopSimulationAction;
import oracle.bpm.designer.simulation.StudioProjectSimulation;
import oracle.bpm.project.model.simulation.ProjectSimulation;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.FuegoWorker;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiUtilities;
import oracle.bpm.ui.monitor.ProgressDialog;
import oracle.bpm.ui.monitor.ProgressMonitorBuilder;
import oracle.bpm.util.ProgressMonitor;

class RunToEndSimulationAction
extends SimulationAction {
    private InterruptableTask interruptableTask;
    private final StartSimulationAction startAction;
    private final StopSimulationAction stopAction;
    static final long serialVersionUID = -4074474589791550858L;
    static final long serialCheck = -5976199929809078346L;

    public RunToEndSimulationAction(SimulationControlPanel panel, StartSimulationAction startAction, StopSimulationAction stopAction) {
        super(DesignerMsg.RUN_TO_THE_END, panel);
        this.startAction = startAction;
        this.stopAction = stopAction;
    }

    @Override
    public boolean doIt() {
        if (!this.getPanel().isSimulating() && !this.startAction.doIt()) {
            return false;
        }
        this.getPanel().enableButtons(SimulationRunnerAction.RUN);
        this.disableAnimation();
        this.showDialog();
        AbstractStudioWorkbench.getInstance().setSimulation(null);
        return true;
    }

    private void disableAnimation() {
        this.getPanel().setAnimation(false);
        this.getPanel().getProcessPanel().getProcessDomain().setShowAnimation(false);
    }

    private void showDialog() {
        try {
            ProgressMonitorBuilder builder = ProgressMonitorBuilder.createCancelableBuilder((UiContainer)Ui.getRoot());
            ProgressDialog dialog = builder.buildProgressDialog(Ui.getRoot(), DesignerMsg.RUN_TO_THE_END);
            dialog.setCancelListener(new ProgressDialog.CancelListener(){

                public void cancel() {
                    RunToEndSimulationAction.this.stopAction.doIt();
                    RunToEndSimulationAction.this.interruptableTask.interrupt();
                }
            });
            try {
                this.interruptableTask = new InterruptableTask(dialog);
                dialog.run((FuegoWorker.BooleanTask)this.interruptableTask);
            }
            catch (Throwable t) {
                MessageDialog.showError((Msg)DesignerMsg.RUN_TO_THE_END, (Throwable)t);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private class InterruptableTask
    implements FuegoWorker.BooleanJob {
        private final ProgressDialog dialog;
        private final ProgressMonitor monitor;
        private boolean running = true;
        private static final int ONE_SECOND = 1000;

        public InterruptableTask(ProgressDialog d) {
            this.dialog = d;
            this.monitor = d.getProgressMonitor();
        }

        public synchronized void interrupt() {
            this.running = false;
            this.notifyAll();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean run() {
            this.dialog.setVisible(true);
            this.monitor.phase(DesignerMsg.RUN_TO_THE_END);
            boolean result = false;
            try {
                result = this.doRun((StudioProjectSimulation)RunToEndSimulationAction.this.getPanel().getSimulation());
            }
            catch (Throwable e) {
                try {
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    this.dialog.setVisible(false);
                    if (this.running) {
                        RunToEndSimulationAction.this.getPanel().enableButtons(SimulationRunnerAction.INIT);
                    }
                    UiUtilities.invokeLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            RunToEndSimulationAction.this.getPanel().redraw();
                        }
                    });
                    throw throwable;
                }
                this.dialog.setVisible(false);
                if (this.running) {
                    RunToEndSimulationAction.this.getPanel().enableButtons(SimulationRunnerAction.INIT);
                }
                UiUtilities.invokeLater((Runnable)new /* invalid duplicate definition of identical inner class */);
            }
            this.dialog.setVisible(false);
            if (this.running) {
                RunToEndSimulationAction.this.getPanel().enableButtons(SimulationRunnerAction.INIT);
            }
            UiUtilities.invokeLater((Runnable)new /* invalid duplicate definition of identical inner class */);
            return result;
        }

        private boolean doRun(StudioProjectSimulation simulation) {
            long lastTime = -100L;
            ProjectSimulation project = simulation.getProjectSimulation();
            long duration = project.getDurationMicroseconds();
            long startTime = project.getStartTime();
            while (this.isRunning() && duration > simulation.getCurrentTime() - startTime) {
                try {
                    this.sleep();
                }
                catch (InterruptedException e) {
                    return false;
                }
                long step = duration / 100L;
                int stepProgress = (int)((simulation.getCurrentTime() - startTime) / step);
                if (stepProgress > 100) {
                    stepProgress = 100;
                }
                this.monitor.progress(stepProgress);
                if (lastTime == simulation.getCurrentTime()) break;
                lastTime = simulation.getCurrentTime();
            }
            if (this.isRunning()) {
                this.monitor.progress(100);
                RunToEndSimulationAction.this.stopAction.doIt();
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            return true;
        }

        private boolean isRunning() {
            return this.running;
        }

        private synchronized void sleep() throws InterruptedException {
            this.wait(1000L);
        }
    }
}

