/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.simulation;

import oracle.bpm.collections.Sequence;
import oracle.bpm.collections.lists.MsgList;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.draw.msg.ProjectDrawMsg;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.organization.Role;
import oracle.bpm.ui.LabelMultiline;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.OkCancelDialog;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.table.ProviderTableModel;
import oracle.bpm.ui.table.Table;
import oracle.bpm.ui.table.TableModel;
import oracle.bpm.ui.table.renderers.BooleanCheckBoxLabelProvider;

class RoleSelectionDialog
extends OkCancelDialog {
    private Project project;
    private Table roleTable;

    public RoleSelectionDialog(UiWindow owner, Project project) {
        super(owner, true);
        this.project = project;
        this.init();
    }

    public void setSelectedRolesIds(String[] roles) {
        TableRoleModel model = (TableRoleModel)this.getRoleTable().getModel();
        int count = model.getRowCount();
        for (int row = 0; row < count; ++row) {
            Role role = (Role)model.getRow(row);
            if (!this.isRoleIn(role.getId(), roles)) continue;
            this.getRoleTable().addRowSelectionInterval(row, row);
        }
    }

    public String[] getSelectedRolesIds() {
        TableRoleModel model = (TableRoleModel)this.getRoleTable().getModel();
        int[] selection = this.getRoleTable().getSelectedRows();
        String[] result = new String[selection.length];
        for (int row = 0; row < selection.length; ++row) {
            Role role = (Role)model.getRow(selection[row]);
            result[row] = role.getId();
        }
        return result;
    }

    public void ok() {
        this.setUserAccepted(true);
        this.setVisible(false);
        this.dispose();
    }

    private Table getRoleTable() {
        return this.roleTable;
    }

    private boolean isRoleIn(String id, String[] roles) {
        if (roles != null) {
            for (String role : roles) {
                if (!id.equals(role)) continue;
                return true;
            }
        }
        return false;
    }

    private void init() {
        UiContainer contentPane = this.getContentPane();
        LabelMultiline msgArea = new LabelMultiline(contentPane, DesignerMsg.SELECT_ROLES.withColon());
        this.roleTable = this.createRoleTable(contentPane);
        this.roleTable.setDefaultLabelProvider(Boolean.class, (LabelProvider)BooleanCheckBoxLabelProvider.getInstance());
        contentPane.setLayout((Layout)new BorderLayout());
        contentPane.add((UiComponent)msgArea, (Object)"North");
        contentPane.add((UiComponent)this.roleTable, (Object)"Center");
        this.setSize(300, 200);
        this.setLocationRelativeTo((UiComponent)this.getParent());
    }

    private Table createRoleTable(UiContainer parent) {
        TableRoleModel model = new TableRoleModel(this.project.getOrganization().getRoles());
        return new Table(parent, (TableModel)model);
    }

    private static class TableRoleModel
    extends ProviderTableModel<Role> {
        private static final MsgList titles = MsgList.create(ProjectDrawMsg.NAME);
        private static final int COLUMN_NAME = 0;

        TableRoleModel(Sequence<Role> roles) {
            super(titles);
            this.populate(roles);
        }

        public boolean isCellEditable(int row, int column) {
            return false;
        }

        public Object getValueAt(int row, int column) {
            Role role = (Role)this.getRow(row);
            switch (column) {
                case 0: {
                    return role.getDefaultLabel();
                }
            }
            return "";
        }

        private void populate(Sequence<Role> roles) {
            for (Role role : roles) {
                this.addRow(role);
            }
        }
    }
}

