/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.simulation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import oracle.bpm.collections.lists.MsgList;
import oracle.bpm.designer.DesignerException;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.preferences.DesignerPreferences;
import oracle.bpm.designer.simulation.ResourceUtils;
import oracle.bpm.designer.simulation.RoleSelectionDialog;
import oracle.bpm.draw.msg.ProjectDrawMsg;
import oracle.bpm.lib.msg.LibMsg;
import oracle.bpm.project.model.Organization;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.organization.Role;
import oracle.bpm.project.model.simulation.ProjectSimulation;
import oracle.bpm.project.model.simulation.SimulationResource;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.DialogFactory;
import oracle.bpm.ui.HiddenMessagesPreferences;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.ListSelectionMode;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.ToolBar;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.border.BorderFactory;
import oracle.bpm.ui.editors.AbstractCellEditor;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.event.ActionListener;
import oracle.bpm.ui.layout.AttributeConstraint;
import oracle.bpm.ui.layout.AttributeType;
import oracle.bpm.ui.layout.Constraint;
import oracle.bpm.ui.layout.RelativeLayout;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.table.AutoResizeMode;
import oracle.bpm.ui.table.ProviderTableModel;
import oracle.bpm.ui.table.Table;
import oracle.bpm.ui.table.TableColumn;
import oracle.bpm.ui.table.TableModel;
import oracle.bpm.ui.table.editors.TableCellEditor;
import oracle.bpm.ui.utils.Layout;
import oracle.bpm.util.ArrayUtils;
import org.jetbrains.annotations.NotNull;

class ResourcesTable
extends Table {
    private ProjectSimulation projectSimulation;

    public ResourcesTable(UiContainer parent, ProjectSimulation model) {
        super(parent, (TableModel)new ResourcesTableModel(), ListSelectionMode.SINGLE_SELECTION);
        this.projectSimulation = model;
        TableColumn column = this.getColumn(6);
        column.setLabelProvider((LabelProvider)new RolesLabelProvider(model.getProject()));
        column.setCellEditor((TableCellEditor)new RolesCellEditor(model.getProject()));
        PercentageLabelProvider provider = new PercentageLabelProvider();
        column = this.getColumn(3);
        column.setLabelProvider((LabelProvider)provider);
        column = this.getColumn(5);
        column.setLabelProvider((LabelProvider)provider);
        column = this.getColumn(2);
        column.setLabelProvider((LabelProvider)new MoneyLabelProvider());
        this.setReorderingAllowed(false);
        column = this.getColumn(0);
        column.setImage(Image.create((Msg)UIMsg.CHECKBOX_SELECTED));
        column.setResizable(false);
        this.setAutoResizeMode(AutoResizeMode.LAST_COLUMN);
        this.reload();
    }

    public ProjectSimulation getProjectSimulationModel() {
        return this.projectSimulation;
    }

    public Collection<SimulationResource> getResourcesMap() {
        return this.projectSimulation.getResources();
    }

    public void add(SimulationResource resource) {
        ResourcesTableModel model = (ResourcesTableModel)this.getModel();
        model.addRow(resource);
    }

    public void add(Collection<SimulationResource> simulationResources) {
        ResourcesTableModel model = (ResourcesTableModel)this.getModel();
        ArrayList<SimulationResource> resourcesToAdd = new ArrayList<SimulationResource>(simulationResources);
        Collections.sort(resourcesToAdd);
        for (SimulationResource simulationResource : resourcesToAdd) {
            model.addRow(simulationResource);
        }
    }

    public void checkResources() throws DesignerException {
        ResourcesTableModel model = (ResourcesTableModel)this.getModel();
        ArrayList list = new ArrayList(model.getData());
        for (SimulationResource simulationResource : list) {
            if (simulationResource == null || simulationResource.getRoles() != null && simulationResource.getRoles().length != 0) continue;
            throw new DesignerException(DesignerMsg.ROLE_MISSING(simulationResource.getId()));
        }
    }

    public void removeAllResources() {
        ResourcesTableModel model = (ResourcesTableModel)this.getModel();
        model.removeAllElements();
    }

    public void updateModelResources(ProjectSimulation projectSimulation) {
        try {
            projectSimulation.removeAllResources();
            List resources = ((ResourcesTableModel)this.getModel()).getData();
            for (SimulationResource resource : resources) {
                projectSimulation.addResource(resource);
            }
        }
        catch (ProjectException e) {
            e.printStackTrace();
        }
    }

    private static String[] roleIdsToLabels(@NotNull Project project, @NotNull String[] ids) {
        ArrayList<String> result = new ArrayList<String>();
        Organization organization = project.getOrganization();
        for (String id : ids) {
            Role role = organization.findRoleById(id);
            String roleLabel = role != null ? role.getDefaultLabel() : id;
            result.add(roleLabel);
        }
        return result.toArray(new String[result.size()]);
    }

    private void reload() {
        if (this.getProjectSimulationModel() != null) {
            Collection simulationResources = this.getProjectSimulationModel().getResources();
            this.add(simulationResources);
        }
    }

    private void refresh() {
        this.removeAllResources();
        ResourceUtils.syncModelResources(this.getProjectSimulationModel());
        this.reload();
    }

    private class RolesCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private Project project;
        private Object result;

        private RolesCellEditor(Project project) {
            this.project = project;
        }

        public Object getCellEditorValue() {
            return this.result;
        }

        public UiComponent getTableCellEditor(Table parent, Object value, boolean isSelected, int row, int column) {
            return this.createEditor((UiContainer)parent, value);
        }

        public UiComponent createEditor(final UiContainer parent, final Object roles) {
            Panel panel = new Panel(parent);
            panel.setLayout((oracle.bpm.ui.layout.Layout)new BorderLayout());
            Panel editorPanel = new Panel((UiContainer)panel);
            RelativeLayout layout = new RelativeLayout();
            editorPanel.setLayout((oracle.bpm.ui.layout.Layout)layout);
            String[] ids = (String[])roles;
            String[] roleLabels = ResourcesTable.roleIdsToLabels(this.project, ids);
            Label text = Label.create((UiContainer)editorPanel, (Msg)Msg.QUOTE(ArrayUtils.toString(roleLabels)));
            Button button = new Button((UiContainer)editorPanel);
            button.setIcon(UIMsg.FIND);
            editorPanel.add((UiComponent)text, (Object)"field");
            editorPanel.add((UiComponent)button, (Object)"button");
            Layout.fixToRoot((RelativeLayout)layout, (String)"button", (AttributeType)AttributeType.RIGHT);
            Layout.fixToRoot((RelativeLayout)layout, (String)"button", (AttributeType)AttributeType.TOP);
            Layout.fixToRoot((RelativeLayout)layout, (String)"button", (AttributeType)AttributeType.BOTTOM);
            layout.addConstraint("field", AttributeType.RIGHT, (Constraint)new AttributeConstraint("button", AttributeType.LEFT, -1));
            Layout.fixToComp((RelativeLayout)layout, (String)"field", (AttributeType)AttributeType.VERTICAL_CENTER, (String)"button");
            Layout.fixToRoot((RelativeLayout)layout, (String)"field", (AttributeType)AttributeType.LEFT, (int)1);
            panel.add((UiComponent)editorPanel, (Object)"Center");
            this.result = roles;
            button.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    RolesCellEditor.this.startEdit(parent, (String[])roles);
                    RolesCellEditor.this.stopCellEditing();
                }
            });
            button.setDefaultCapable(false);
            button.setFocusPainted(false);
            return panel;
        }

        private void startEdit(UiContainer parent, String[] roles) {
            Project project = ResourcesTable.this.projectSimulation.getProject();
            RoleSelectionDialog dialog = new RoleSelectionDialog(parent.getOwnerWindow(), project);
            dialog.setSelectedRolesIds(roles);
            dialog.setVisible(true);
            this.result = dialog.userAccepted() ? dialog.getSelectedRolesIds() : roles;
        }
    }

    private static final class RolesLabelProvider
    extends LabelProvider.Default {
        private Project project;

        public RolesLabelProvider(@NotNull Project project) {
            this.project = project;
        }

        public String getText(Object element) {
            String[] ids = (String[])element;
            String[] result = ResourcesTable.roleIdsToLabels(this.project, ids);
            return ArrayUtils.toString(result);
        }
    }

    private static class ResourcesTableModel
    extends ProviderTableModel<SimulationResource> {
        private static final int SELECTED_COLUMN = 0;
        private static final int NAME_COLUMN = 1;
        private static final int COST_COLUMN = 2;
        private static final int EFFICIENCY_COLUMN = 3;
        private static final int CAPACITY_COLUMN = 4;
        private static final int AVAILABILITY_COLUMN = 5;
        private static final int ROLES_COLUMN = 6;
        private static final MsgList TITLES = MsgList.create(UIMsg.TO_MSG((String)""), ProjectDrawMsg.NAME, DesignerMsg.COST, DesignerMsg.EFFICIENCY, DesignerMsg.CAPACITY, DesignerMsg.AVAILABILITY, LibMsg.ROLES);

        public ResourcesTableModel() {
            super(TITLES);
        }

        public boolean isCellEditable(int row, int column) {
            return true;
        }

        public Class getColumnClass(int column) {
            Class result;
            switch (column) {
                case 0: {
                    result = Boolean.class;
                    break;
                }
                case 1: {
                    result = String.class;
                    break;
                }
                case 2: {
                    result = Double.class;
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    result = Integer.class;
                    break;
                }
                case 6: {
                    result = String[].class;
                    break;
                }
                default: {
                    result = Object.class;
                }
            }
            return result;
        }

        public int getColumnCount() {
            return TITLES.size();
        }

        public void setValueAt(Object aValue, int row, int column) {
            SimulationResource resource = (SimulationResource)this.getRow(row);
            boolean updated = false;
            switch (column) {
                case 0: {
                    if (resource.getSelected() == ((Boolean)aValue).booleanValue()) break;
                    updated = true;
                    resource.setSelected(((Boolean)aValue).booleanValue());
                    break;
                }
                case 1: {
                    if (resource.getId().equals(aValue) || this.idAlreadyUsed((String)aValue)) break;
                    updated = true;
                    resource.setId((String)aValue);
                    break;
                }
                case 2: {
                    if (resource.getCost() == ((Double)aValue).doubleValue()) break;
                    updated = true;
                    resource.setCost(((Double)aValue).doubleValue());
                    break;
                }
                case 3: {
                    if ((int)resource.getEfficiency() == (Integer)aValue) break;
                    updated = true;
                    resource.setEfficiency((double)((Integer)aValue).intValue());
                    break;
                }
                case 4: {
                    if (resource.getCapacity() == ((Integer)aValue).intValue()) break;
                    updated = true;
                    resource.setCapacity(((Integer)aValue).intValue());
                    break;
                }
                case 5: {
                    if (resource.getAvailability() == ((Integer)aValue).intValue()) break;
                    updated = true;
                    resource.setAvailability(((Integer)aValue).intValue());
                    break;
                }
                case 6: {
                    if (resource == null || resource.getRoles() == null || resource.getRoles().equals(aValue)) break;
                    updated = true;
                    resource.setRoles((String[])aValue);
                }
            }
            if (updated) {
                this.fireTableCellUpdated(row, column);
            }
        }

        public Object getValueAt(int row, int column) {
            Object result;
            SimulationResource resource = (SimulationResource)this.getRow(row);
            switch (column) {
                case 0: {
                    result = resource.getSelected();
                    break;
                }
                case 1: {
                    result = resource.getId();
                    break;
                }
                case 2: {
                    result = resource.getCost();
                    break;
                }
                case 3: {
                    result = (int)resource.getEfficiency();
                    break;
                }
                case 4: {
                    result = resource.getCapacity();
                    break;
                }
                case 5: {
                    result = resource.getAvailability();
                    break;
                }
                case 6: {
                    result = resource.getRoles();
                    break;
                }
                default: {
                    result = "";
                }
            }
            return result;
        }

        private boolean idAlreadyUsed(String id) {
            boolean used = false;
            for (int i = 0; i < this.getRowCount(); ++i) {
                if (!((SimulationResource)this.getRow(i)).getId().equals(id)) continue;
                used = true;
                break;
            }
            return used;
        }
    }

    private static final class PercentageLabelProvider
    extends LabelProvider.Default {
        private PercentageLabelProvider() {
        }

        public String getText(Object element) {
            return element + " %";
        }
    }

    private static final class MoneyLabelProvider
    extends LabelProvider.Default {
        private MoneyLabelProvider() {
        }

        public String getText(Object element) {
            return "$ " + element;
        }
    }

    static class ViewPanel
    extends Panel {
        private ResourcesTable resourcesTable;

        public ViewPanel(UiContainer parent, ProjectSimulation model) {
            super(parent);
            this.resourcesTable = new ResourcesTable((UiContainer)this, model);
            this.resourcesTable.setParent((UiContainer)this);
            this.setLayout((oracle.bpm.ui.layout.Layout)new BorderLayout());
            this.add((UiComponent)this.resourcesTable, "Center");
            this.add(this.createButtonPanel((UiContainer)this, model), "East");
        }

        public ResourcesTable getResourcesTable() {
            return this.resourcesTable;
        }

        private String getNextResourceName() {
            List resources = ((ResourcesTableModel)this.resourcesTable.getModel()).getData();
            String name = ProjectDrawMsg.NAME.getString();
            HashMap namesMap = new HashMap();
            for (SimulationResource simulationResource : resources) {
                namesMap.put(simulationResource.getId(), null);
            }
            int nameCounter = 1;
            while (namesMap.containsKey(name + nameCounter++)) {
            }
            name = name + --nameCounter;
            return name;
        }

        private BaseAction createAddAction(final ProjectSimulation projectSimulation) {
            return new BaseAction(UIMsg.ADD){

                public synchronized void run() {
                    String name = ViewPanel.this.getNextResourceName();
                    SimulationResource resource = projectSimulation.createResource(name);
                    ViewPanel.this.resourcesTable.add(resource);
                }
            };
        }

        private UiComponent createButtonPanel(UiContainer parent, ProjectSimulation projectSimulation) {
            ToolBar toolBar = new ToolBar(parent, ToolBar.VERTICAL);
            BaseAction addAction = this.createAddAction(projectSimulation);
            BaseAction delAction = this.createDelAction();
            this.addToToolbar(toolBar, addAction);
            this.addToToolbar(toolBar, delAction);
            toolBar.addSeparator();
            return toolBar;
        }

        private void addToToolbar(ToolBar toolBar, BaseAction action) {
            Button btn = new Button((UiContainer)toolBar, action, 2);
            btn.setBorder(BorderFactory.createEmptyBorder((int)1, (int)1, (int)1, (int)1));
            toolBar.add((UiComponent)btn);
        }

        private BaseAction createDelAction() {
            return new BaseAction(UIMsg.REMOVE){

                public synchronized void run() {
                    int selectedRow = ViewPanel.this.resourcesTable.getSelectedRow();
                    if (selectedRow != -1) {
                        ResourcesTableModel model = (ResourcesTableModel)ViewPanel.this.resourcesTable.getModel();
                        model.removeRow(selectedRow);
                    }
                }
            };
        }

        private Button createRefreshBtn(UiContainer parent) {
            BaseAction refreshAction = new BaseAction(DesignerMsg.RELOAD){

                public void run() {
                    boolean result = DialogFactory.showConfirmDialog((HiddenMessagesPreferences)DesignerPreferences.getPreferences(), (Msg)DesignerMsg.RELOAD, (Msg)DesignerMsg.CONFIRM_SIM_RELOAD_RESOURCES);
                    if (result) {
                        ViewPanel.this.resourcesTable.refresh();
                    }
                }
            };
            Button btn = new Button(parent, refreshAction, 2);
            btn.setIcon(UIMsg.REFRESH);
            btn.setToolTipText(DesignerMsg.RELOAD_RESOURCES);
            btn.setBorder(BorderFactory.createEmptyBorder((int)1, (int)1, (int)1, (int)1));
            return btn;
        }
    }
}

