/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.simulation;

import fuego.simulation.SimulationFlowNodeImpl;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.simulation.ActivityTabPanel;
import oracle.bpm.designer.simulation.ActivityTabType;
import oracle.bpm.project.model.simulation.ParticipantSelectionPolicy;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.AbstractButton;
import oracle.bpm.ui.ButtonGroup;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.RadioButton;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiFactory;
import oracle.bpm.ui.layout.AttributeType;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.RelativeLayout;
import oracle.bpm.ui.text.NumericField;

public class ResourcesTabPanel
extends ActivityTabPanel {
    private NumericField<Integer> availableResourcesSpinner;
    private ComboBox<ParticipantSelectionPolicy> partSelectionPoliticCombo;
    private RadioButton useOrgResourceBtn;
    private RadioButton useSimResourceBtn;

    public ResourcesTabPanel(UiContainer parent) {
        super(parent, ActivityTabType.RESOURCES, DesignerMsg.PROPERTIES);
    }

    @Override
    protected void buildTab() {
        RelativeLayout layout = new RelativeLayout();
        this.setLayout((Layout)layout);
        this.availableResourcesSpinner = NumericField.createIntegerNumericField((UiContainer)this);
        this.availableResourcesSpinner.setValue((Number)5);
        this.availableResourcesSpinner.setRange((Number)1, (Number)10000);
        this.availableResourcesSpinner.setStepSize((Number)1);
        this.partSelectionPoliticCombo = UiFactory.createComboBox((UiContainer)this, (Object[])ParticipantSelectionPolicy.values());
        this.useOrgResourceBtn = new RadioButton((UiContainer)this, DesignerMsg.USE_ORG_RESOURCES);
        this.useSimResourceBtn = new RadioButton((UiContainer)this, DesignerMsg.USE_FIXED_RESOURCES);
        ButtonGroup group = new ButtonGroup();
        group.add((AbstractButton)this.useOrgResourceBtn);
        group.add((AbstractButton)this.useSimResourceBtn);
        this.add((UiComponent)this.useOrgResourceBtn, "useOrgResourceBtn");
        this.add((UiComponent)this.useSimResourceBtn, "useSimResourceBtn");
        this.add((UiComponent)Label.create((UiContainer)this, (Msg)DesignerMsg.AVAILABLE_RESOURCES), "capacityLabel");
        this.add((UiComponent)this.availableResourcesSpinner, "capacitySpinner");
        this.add((UiComponent)Label.create((UiContainer)this, (Msg)DesignerMsg.PARTICIPANT_SELECTION_POLICY), "partSelectLabel");
        this.add((UiComponent)this.partSelectionPoliticCombo, "partSelectCombo");
        oracle.bpm.ui.utils.Layout.fixToRoot((RelativeLayout)layout, (String)"useOrgResourceBtn", (AttributeType)AttributeType.TOP, (int)2);
        oracle.bpm.ui.utils.Layout.fixToRoot((RelativeLayout)layout, (String)"useOrgResourceBtn", (AttributeType)AttributeType.LEFT, (int)2);
        oracle.bpm.ui.utils.Layout.fixToComp((RelativeLayout)layout, (String)"partSelectLabel", (AttributeType)AttributeType.VERTICAL_CENTER, (String)"partSelectCombo");
        oracle.bpm.ui.utils.Layout.fixToRoot((RelativeLayout)layout, (String)"partSelectLabel", (AttributeType)AttributeType.LEFT, (int)20);
        oracle.bpm.ui.utils.Layout.fixToComp((RelativeLayout)layout, (String)"partSelectCombo", (AttributeType)AttributeType.TOP, (String)"useOrgResourceBtn", (AttributeType)AttributeType.BOTTOM, (int)2);
        oracle.bpm.ui.utils.Layout.fixToComp((RelativeLayout)layout, (String)"partSelectCombo", (AttributeType)AttributeType.LEFT, (String)"partSelectLabel", (AttributeType)AttributeType.RIGHT, (int)2);
        oracle.bpm.ui.utils.Layout.fixToComp((RelativeLayout)layout, (String)"useSimResourceBtn", (AttributeType)AttributeType.TOP, (String)"partSelectCombo", (AttributeType)AttributeType.BOTTOM, (int)10);
        oracle.bpm.ui.utils.Layout.fixToComp((RelativeLayout)layout, (String)"useSimResourceBtn", (AttributeType)AttributeType.LEFT, (String)"useOrgResourceBtn");
        oracle.bpm.ui.utils.Layout.fixToComp((RelativeLayout)layout, (String)"capacityLabel", (AttributeType)AttributeType.VERTICAL_CENTER, (String)"capacitySpinner");
        oracle.bpm.ui.utils.Layout.fixToComp((RelativeLayout)layout, (String)"capacityLabel", (AttributeType)AttributeType.LEFT, (String)"partSelectLabel");
        oracle.bpm.ui.utils.Layout.fixToComp((RelativeLayout)layout, (String)"capacitySpinner", (AttributeType)AttributeType.TOP, (String)"useSimResourceBtn", (AttributeType)AttributeType.BOTTOM, (int)2);
        oracle.bpm.ui.utils.Layout.fixToComp((RelativeLayout)layout, (String)"capacitySpinner", (AttributeType)AttributeType.LEFT, (String)"partSelectLabel", (AttributeType)AttributeType.RIGHT, (int)2);
    }

    @Override
    protected void tabToObject(SimulationFlowNodeImpl activity) {
        if (activity.showResources()) {
            activity.setUseOrgResources(this.useOrgResourceBtn.isSelected());
            activity.setCapacity(((Integer)this.availableResourcesSpinner.getValue()).intValue());
            activity.setParticipantSelectionPolicy((ParticipantSelectionPolicy)this.partSelectionPoliticCombo.getSelectedItem());
        }
    }

    @Override
    protected void objectToTab(SimulationFlowNodeImpl activity) {
        if (activity.showResources()) {
            boolean useOrgResources = activity.getUseOrgResources();
            this.useOrgResourceBtn.setSelected(useOrgResources);
            this.useSimResourceBtn.setSelected(!useOrgResources);
            this.availableResourcesSpinner.setValue((Number)activity.getCapacity());
            this.availableResourcesSpinner.repaint();
            this.partSelectionPoliticCombo.setSelectedItem((Object)activity.getParticipantSelectionPolicy());
        }
    }
}

