/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.simulation;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import oracle.bpm.bam.chartviewer.ActivityCheckTree;
import oracle.bpm.bam.chartviewer.CategoryCheckTree;
import oracle.bpm.bam.chartviewer.Chart;
import oracle.bpm.bam.chartviewer.ChartInterface;
import oracle.bpm.bam.chartviewer.ChartManager;
import oracle.bpm.bam.chartviewer.ChartViewer;
import oracle.bpm.bam.chartviewer.ChartViewerUtils;
import oracle.bpm.bam.chartviewer.CheckTreePanel;
import oracle.bpm.bam.chartviewer.IndicatorSelections;
import oracle.bpm.bam.chartviewer.IndicatorsCheckTree;
import oracle.bpm.bam.chartviewer.ResourceCheckTree;
import oracle.bpm.bam.msg.BamMsg;
import oracle.bpm.bam.report.ReportGenerator;
import oracle.bpm.bamdata.Indicator;
import oracle.bpm.chart.ChartTypeLabelProvider;
import oracle.bpm.chart.shared.styles.ChartType;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.geom.Dimension;
import oracle.bpm.lib.msg.LibMsg;
import oracle.bpm.project.Priority;
import oracle.bpm.project.model.simulation.ProjectSimulation;
import oracle.bpm.project.model.simulation.SimulationResource;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.BorderPanel;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.ButtonGroup;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.FuegoWorker;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.LabelMultiline;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.OkCancelDialog;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.RadioButton;
import oracle.bpm.ui.ScrollPane;
import oracle.bpm.ui.SplitPane;
import oracle.bpm.ui.TabbedPane;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiFactory;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.border.Border;
import oracle.bpm.ui.border.CustomLineBorder;
import oracle.bpm.ui.border.LineTitledBorder;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.event.ActionListener;
import oracle.bpm.ui.event.CheckSelectionChangedEvent;
import oracle.bpm.ui.event.CheckSelectionListener;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;
import oracle.bpm.ui.filechooser.FileChooser;
import oracle.bpm.ui.layout.AttributeType;
import oracle.bpm.ui.layout.FlowLayout;
import oracle.bpm.ui.layout.RelativeLayout;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.layout.form.CellConstraints;
import oracle.bpm.ui.layout.form.FormLayout;
import oracle.bpm.ui.layout.form.PanelBuilder;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.text.TextArea;
import oracle.bpm.ui.text.TextField;
import oracle.bpm.ui.tree.CheckTree;
import oracle.bpm.ui.tree.TreeNode;
import oracle.bpm.ui.utils.Layout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ReportDialog
extends OkCancelDialog {
    private ActivitiesPage activitiesPage;
    private ButtonTuple activitiesTuple;
    private CategoriesPage categoriesPage;
    private ButtonTuple categoriesTuple;
    private ChartManager chartManager;
    @NotNull
    private final IndicatorSelections indicatorSelections;
    private IndicatorsPage indicatorsPage;
    private ButtonTuple indicatorsTuple;
    private int options;
    @NotNull
    private final ChartManager originalChartManager;
    private UiWindow owner;
    private ProjectSimulation projectSimulationModel;
    private ResourcesPage resourcesPage;
    private ButtonTuple resourcesTuple;
    private File targetDataDir;
    private File targetDir;
    private TextField targetFileFld;
    private final CheckSelectionListener treeListener = new CheckSelectionListener(){

        public void checkedSelectionChanged(CheckSelectionChangedEvent event) {
            ReportDialog.this.chartManager.draw();
        }
    };
    private static final String DATA_DIR = "_DataDir";
    public static final int INDICATORS = 1;
    public static final int ACTIVITIES = 2;
    public static final int CATEGORIES = 4;
    public static final int RESOURCES = 8;

    public ReportDialog(@NotNull UiWindow owner, @NotNull ProjectSimulation simulation, @NotNull ChartViewer chartViewer) {
        super(owner, DesignerMsg.SIMULATION_REPORT, true);
        this.owner = owner;
        this.projectSimulationModel = simulation;
        this.indicatorSelections = chartViewer.getCurrentIndicatorProvider().clone();
        this.originalChartManager = chartViewer.getChartManager();
        this.loadOptions();
        this.buildPages();
        this.setSize(800, 550);
        this.setLocationRelativeTo((UiComponent)owner);
    }

    public ChartManager getChartManager() {
        return this.chartManager;
    }

    public boolean getOption(int option) {
        return (this.options & option) != 0;
    }

    public void ok() {
        if (!this.createTargetFiles()) {
            return;
        }
        this.beginWait();
        this.okButton.setEnabled(false);
        ChartManager chartManager = this.getChartManager();
        ReportGenerator.Info activityInfo = new ReportGenerator.Info();
        ReportGenerator.Info categoryInfo = new ReportGenerator.Info();
        ReportGenerator.Info indicatorInfo = new ReportGenerator.Info();
        ReportGenerator.Info resourceInfo = new ReportGenerator.Info();
        this.buildIndicatorInfo((ReportGenerator.Info<Indicator>)indicatorInfo);
        this.buildActivityInfo((ReportGenerator.Info<String>)activityInfo);
        if (chartManager.isResourceView()) {
            this.buildResourceInfo((ReportGenerator.Info<SimulationResource>)resourceInfo);
        }
        this.buildCategoryInfo((ReportGenerator.Info<Priority>)categoryInfo);
        final ReportGenerator generator = new ReportGenerator(chartManager, indicatorInfo, activityInfo, resourceInfo, categoryInfo);
        generator.setBaseFileName(this.projectSimulationModel.getId());
        generator.setOutputDir(this.targetDir);
        generator.setDataDir(this.targetDataDir);
        generator.setIndicatorsProvider(this.indicatorSelections);
        try {
            FuegoWorker.post((FuegoWorker.Procedure)new FuegoWorker.Procedure(){

                public void run() throws IOException {
                    generator.doIt();
                }
            });
        }
        catch (Exception e) {
            MessageDialog.showError((Throwable)e);
        }
        this.endWait();
        this.setUserAccepted(false);
        this.close();
    }

    private void browse() {
        FileChooser fileChooser = new FileChooser();
        int returnVal = fileChooser.showOpenDialog((UiComponent)this.owner, UIMsg.CHOOSE_DIRECTORY, 4);
        if (returnVal != 0) {
            return;
        }
        try {
            File selectedFile = fileChooser.getSelectedFile();
            String fileChosen = selectedFile.getCanonicalFile().getCanonicalPath();
            this.targetFileFld.setText(fileChosen);
        }
        catch (IOException e1) {
            MessageDialog.showError((Throwable)e1);
            return;
        }
    }

    private void buildActivityInfo(@NotNull ReportGenerator.Info<String> activityInfo) {
        activityInfo.setFree(true);
        activityInfo.setType(this.activitiesPage.getDetailOption());
        ActivityCheckTree activityTree = this.activitiesPage.getTree();
        for (Map.Entry activitiesByProcess : activityTree.getSelectedActivitiesByProcess().entrySet()) {
            List activities = (List)activitiesByProcess.getValue();
            for (String activity : activities) {
                activityInfo.getData().add(activity);
            }
        }
    }

    private void buildCategoryInfo(@NotNull ReportGenerator.Info<Priority> categoryInfo) {
        categoryInfo.setFree(true);
        categoryInfo.setType(this.categoriesPage.getDetailOption());
        CategoryCheckTree categoriesTree = this.categoriesPage.getTree();
        List treeCategories = categoriesTree.getSelectedCategories();
        for (Priority priority : treeCategories) {
            categoryInfo.getData().add(priority);
        }
    }

    private void buildIndicatorInfo(@NotNull ReportGenerator.Info<Indicator> indicatorInfo) {
        indicatorInfo.setFree(true);
        indicatorInfo.setType(this.indicatorsPage.getDetailOption());
        IndicatorsCheckTree indicatorsTree = this.indicatorsPage.getTree();
        for (Indicator indicator : indicatorsTree.getSelectedIndicators()) {
            indicatorInfo.getData().add(indicator);
        }
    }

    private void buildResourceInfo(@NotNull ReportGenerator.Info<SimulationResource> resourceInfo) {
        if (this.chartManager.isResourceView()) {
            resourceInfo.setFree(true);
            resourceInfo.setType(this.resourcesPage.getDetailOption());
            ResourceCheckTree resourcesTree = this.resourcesPage.getTree();
            for (SimulationResource resource : resourcesTree.getSelectedResources()) {
                resourceInfo.getData().add(resource);
            }
        }
    }

    private void buildPages() {
        Panel topPanel = this.createTopPanel(this.getContentPane());
        Panel containerPanel = new Panel(this.getContentPane());
        containerPanel.setLayout((oracle.bpm.ui.layout.Layout)new BorderLayout());
        containerPanel.setBorder((Border)new LineTitledBorder(LibMsg.OPTIONS.getString()));
        SplitPane splitPane = new SplitPane((UiContainer)containerPanel);
        TabbedPane tabbedPane = new TabbedPane((UiContainer)splitPane);
        ChartTypePanel chartTypePanel = new ChartTypePanel((UiContainer)splitPane);
        tabbedPane.setBorder((Border)new CustomLineBorder(1));
        this.resourcesPage = new ResourcesPage((UiContainer)tabbedPane);
        this.activitiesPage = new ActivitiesPage((UiContainer)tabbedPane);
        this.categoriesPage = new CategoriesPage((UiContainer)tabbedPane);
        this.indicatorsPage = new IndicatorsPage((UiContainer)tabbedPane);
        this.resourcesPage.setEnabled(true);
        this.activitiesPage.setEnabled(true);
        this.categoriesPage.setEnabled(true);
        this.indicatorsPage.setEnabled(true);
        if (this.chartManager.isResourceView()) {
            tabbedPane.addTab(BamMsg.RESOURCES, (UiComponent)this.resourcesPage);
        }
        tabbedPane.addTab(BamMsg.ACTIVITIES, (UiComponent)this.activitiesPage);
        tabbedPane.addTab(BamMsg.CATEGORIES, (UiComponent)this.categoriesPage);
        tabbedPane.addTab(BamMsg.INDICATORS, (UiComponent)this.indicatorsPage);
        splitPane.setLeftComponent((UiComponent)tabbedPane);
        splitPane.setRightComponent((UiComponent)chartTypePanel);
        splitPane.setResizeWeight(0.4);
        containerPanel.add((UiComponent)splitPane, (Object)"Center");
        this.getContentPane().add((UiComponent)topPanel, (Object)"North");
        this.getContentPane().add((UiComponent)containerPanel, (Object)"Center");
    }

    private void checkNonRepeatedDetails() {
        ButtonTuple selectedDetailsTuple = null;
        selectedDetailsTuple = this.checkNonRepeatedDetailRadioButton(selectedDetailsTuple, this.resourcesTuple);
        selectedDetailsTuple = this.checkNonRepeatedDetailRadioButton(selectedDetailsTuple, this.activitiesTuple);
        selectedDetailsTuple = this.checkNonRepeatedDetailRadioButton(selectedDetailsTuple, this.categoriesTuple);
        selectedDetailsTuple = this.checkNonRepeatedDetailRadioButton(selectedDetailsTuple, this.indicatorsTuple);
    }

    @Nullable
    private ButtonTuple checkNonRepeatedDetailRadioButton(@Nullable ButtonTuple selectedDetails, @NotNull ButtonTuple tupleToBeChecked) {
        if (tupleToBeChecked.isDetails()) {
            if (selectedDetails == null) {
                selectedDetails = tupleToBeChecked;
            } else {
                MessageDialog.showError((Msg)DesignerMsg.DIMENSION_NOT_ALLOWED);
                tupleToBeChecked.setDetails(false);
            }
        }
        return selectedDetails;
    }

    private boolean createTargetFiles() {
        String targetFileName = this.targetFileFld.getText();
        if (targetFileName == null || targetFileName.length() == 0) {
            MessageDialog.showError((Msg)DesignerMsg.INVALID_REPORT_FILE);
            return false;
        }
        this.targetDir = new File(targetFileName);
        String fileName = this.targetDir.getName();
        this.targetDataDir = new File(this.targetDir, fileName + DATA_DIR);
        if (this.targetDataDir.exists()) {
            File[] files = this.targetDataDir.listFiles();
            for (int i = 0; i < files.length; ++i) {
                File dirFile = files[i];
                if (dirFile.delete()) continue;
                MessageDialog.showError((Msg)DesignerMsg.COULD_NOT_DELETE_DATA_DIR_FILE(dirFile.getName()));
                return false;
            }
            if (!this.targetDataDir.delete()) {
                MessageDialog.showError((Msg)DesignerMsg.COULD_NOT_DELETE_DATA_DIR(this.targetDataDir.getName()));
                return false;
            }
        } else {
            this.targetDataDir.mkdirs();
        }
        return true;
    }

    private Panel createTopPanel(UiContainer parent) {
        Panel container = new Panel(parent);
        container.setBorder((Border)new LineTitledBorder(DesignerMsg.REPORT_DIRECTORY.getString()));
        String targetName = System.getProperty("user.home") + File.separator + this.projectSimulationModel.getId();
        this.targetFileFld = new TextField((UiContainer)container, targetName);
        Dimension fldSize = this.targetFileFld.getPreferredSize();
        container.setBorder((Border)new LineTitledBorder(DesignerMsg.REPORT_DIRECTORY.getString()));
        Button targetFileBtn = new Button((UiContainer)container, UIMsg.TO_MSG((String)"..."));
        targetFileBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ReportDialog.this.browse();
            }
        });
        targetFileBtn.setExactSize(Dimension.valueOf(fldSize.getHeight(), fldSize.getHeight()));
        FormLayout layout = new FormLayout("2dlu, pref, 2dlu, pref:grow, 2dlu, min, 2dlu", "2dlu, pref, 2dlu");
        PanelBuilder builder = layout.createBuilder(container);
        CellConstraints cc = layout.createCellConstraints();
        builder.add((UiComponent)Label.create((UiContainer)container, (Msg)DesignerMsg.DIRECTORY_LOCATION), cc.xy(2, 2));
        builder.add((UiComponent)this.targetFileFld, cc.xy(4, 2));
        builder.add((UiComponent)targetFileBtn, cc.xy(6, 2));
        return container;
    }

    private boolean isFreeDimension(int dimension) {
        int xAxisDim = this.originalChartManager.getViewForAxis(0);
        int zAxisDim = this.originalChartManager.getViewForAxis(2);
        return xAxisDim != dimension && zAxisDim != dimension;
    }

    private void loadOptions() {
        this.options |= 1;
        if (this.isFreeDimension(2) && this.isFreeDimension(3)) {
            this.options |= 2;
        }
        if (this.isFreeDimension(0)) {
            this.options |= 4;
        }
        if (this.isFreeDimension(1)) {
            this.options |= 8;
        }
    }

    private ButtonTuple createButtons(@NotNull Panel parent) {
        ButtonTuple tuple = new ButtonTuple((UiContainer)parent);
        parent.add((UiComponent)tuple.summary);
        parent.add((UiComponent)tuple.details);
        return tuple;
    }

    private class ResourcesPage
    extends OptionPage {
        private CheckTreePanel treePanel;

        public ResourcesPage(UiContainer parent) {
            super(parent, 8);
        }

        @Override
        protected Msg createLabel() {
            return DesignerMsg.REPORT_RESOURCES_DESC;
        }

        @Override
        protected CheckTreePanel createTreePanel(@NotNull UiContainer parent) {
            this.treePanel = ChartViewerUtils.createResourcesCheckTreePanel((UiContainer)parent, (ChartManager)ReportDialog.this.chartManager, (CheckSelectionListener)ReportDialog.this.treeListener);
            return this.treePanel;
        }

        protected ResourceCheckTree getTree() {
            return (ResourceCheckTree)this.treePanel.getTree();
        }
    }

    private class IndicatorsPage
    extends OptionPage {
        private CheckTreePanel treePanel;

        public IndicatorsPage(UiContainer parent) {
            super(parent, 1);
        }

        @Override
        protected Msg createLabel() {
            return DesignerMsg.REPORT_INDICATORS_DESC;
        }

        @Override
        protected CheckTreePanel createTreePanel(@NotNull UiContainer parent) {
            this.treePanel = ChartViewerUtils.createIndicatorsCheckTreePanel((UiContainer)parent, (IndicatorSelections)ReportDialog.this.indicatorSelections, (boolean)ReportDialog.this.chartManager.isResourceView(), (CheckSelectionListener)ReportDialog.this.treeListener);
            return this.treePanel;
        }

        protected IndicatorsCheckTree getTree() {
            return (IndicatorsCheckTree)this.treePanel.getTree();
        }
    }

    private class ChartTypePanel
    extends Panel {
        private Panel chartPanel;
        private ComboBox<ChartType> drawingTypeCombo;

        public ChartTypePanel(UiContainer parent) {
            super(parent);
            this.initComponents();
        }

        public void initComponents() {
            this.setLayout((oracle.bpm.ui.layout.Layout)new BorderLayout());
            this.add((UiComponent)this.createTypePanel(), "Center");
        }

        protected void charTypeChanged() {
            ChartType displayingChartType = ReportDialog.this.chartManager.getChartType();
            ChartType selectedChartType = (ChartType)this.drawingTypeCombo.getSelectedItem();
            if (selectedChartType != displayingChartType) {
                ReportDialog.this.chartManager.setChartType(selectedChartType);
                ReportDialog.this.chartManager.draw();
            }
        }

        private Panel createTypePanel() {
            RelativeLayout layout = new RelativeLayout();
            Panel contentPane = new Panel((UiContainer)this);
            contentPane.setLayout((oracle.bpm.ui.layout.Layout)layout);
            this.chartPanel = this.createChartPanel(contentPane);
            this.drawingTypeCombo = UiFactory.createComboBox((UiContainer)contentPane);
            this.drawingTypeCombo.setToolTipText(BamMsg.CHOOSE_CHART_TYPE);
            this.drawingTypeCombo.setLabelProvider((LabelProvider)new ChartTypeLabelProvider(Image.create((Msg)BamMsg.CHART)));
            this.drawingTypeCombo.addItems((Iterable)ChartViewer.CHART_TYPES);
            this.drawingTypeCombo.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    ChartTypePanel.this.charTypeChanged();
                }
            });
            this.drawingTypeCombo.setSelectedIndex(0);
            contentPane.add((UiComponent)new LabelMultiline((UiContainer)contentPane, DesignerMsg.REPORT_CHART_DESC), (Object)"typeLabel");
            contentPane.add(this.drawingTypeCombo, (Object)"typeCombo");
            contentPane.add((UiComponent)this.chartPanel, (Object)"chart");
            this.layoutComponents(layout);
            return contentPane;
        }

        private void layoutComponents(RelativeLayout layout) {
            Layout.fixToRoot((RelativeLayout)layout, (String)"typeLabel", (AttributeType)AttributeType.TOP, (int)5);
            Layout.fixToRoot((RelativeLayout)layout, (String)"typeLabel", (AttributeType)AttributeType.LEFT, (int)5);
            Layout.fixToRoot((RelativeLayout)layout, (String)"typeLabel", (AttributeType)AttributeType.RIGHT, (int)-5);
            Layout.fixToComp((RelativeLayout)layout, (String)"typeCombo", (AttributeType)AttributeType.TOP, (String)"typeLabel", (AttributeType)AttributeType.BOTTOM, (int)5);
            Layout.fixToComp((RelativeLayout)layout, (String)"typeCombo", (AttributeType)AttributeType.LEFT, (String)"typeLabel");
            Layout.fixToComp((RelativeLayout)layout, (String)"typeCombo", (AttributeType)AttributeType.RIGHT, (String)"typeLabel");
            Layout.fixToComp((RelativeLayout)layout, (String)"chart", (AttributeType)AttributeType.TOP, (String)"typeCombo", (AttributeType)AttributeType.BOTTOM, (int)5);
            Layout.fixToComp((RelativeLayout)layout, (String)"chart", (AttributeType)AttributeType.LEFT, (String)"typeCombo");
            Layout.fixToComp((RelativeLayout)layout, (String)"chart", (AttributeType)AttributeType.RIGHT, (String)"typeCombo");
            Layout.fixToRoot((RelativeLayout)layout, (String)"chart", (AttributeType)AttributeType.BOTTOM, (int)-5);
        }

        private Panel createChartPanel(Panel contentPane) {
            Panel chartVisualizationPanel = new Panel((UiContainer)contentPane);
            chartVisualizationPanel.setLayout((oracle.bpm.ui.layout.Layout)new BorderLayout());
            ScrollPane scrollPane = new ScrollPane((UiContainer)chartVisualizationPanel);
            Chart chart = new Chart((UiContainer)scrollPane);
            chart.setVisible(true);
            ReportDialog.this.chartManager = ChartManager.createForSimulation((ChartInterface)chart);
            scrollPane.setView((UiComponent)chart);
            ReportDialog.this.chartManager.setIndicatorProvider(ReportDialog.this.indicatorSelections);
            ReportDialog.this.chartManager.initAxes();
            ReportDialog.this.chartManager.setUpAxesFrom(ReportDialog.this.originalChartManager);
            ReportDialog.this.chartManager.initResourcesFrom(ReportDialog.this.originalChartManager);
            ReportDialog.this.chartManager.initSelections(ReportDialog.this.originalChartManager.getDataModel());
            ReportDialog.this.chartManager.setUpSelectionsFrom(ReportDialog.this.originalChartManager);
            ReportDialog.this.chartManager.draw();
            chartVisualizationPanel.add((UiComponent)scrollPane, (Object)"Center");
            return chartVisualizationPanel;
        }
    }

    private class CategoriesPage
    extends OptionPage {
        private CheckTreePanel treePanel;

        public CategoriesPage(UiContainer parent) {
            super(parent, 4);
        }

        @Override
        protected Msg createLabel() {
            return DesignerMsg.REPORT_CATEGORIES_DESC;
        }

        @Override
        protected CheckTreePanel createTreePanel(@NotNull UiContainer parent) {
            this.treePanel = ChartViewerUtils.createCategoriesCheckTreePanel((UiContainer)parent, (ChartManager)ReportDialog.this.chartManager, (CheckSelectionListener)ReportDialog.this.treeListener);
            return this.treePanel;
        }

        protected CategoryCheckTree getTree() {
            return (CategoryCheckTree)this.treePanel.getTree();
        }
    }

    private class ActivitiesPage
    extends OptionPage {
        private CheckTreePanel treePanel;

        public ActivitiesPage(UiContainer parent) {
            super(parent, 2);
        }

        @Override
        protected Msg createLabel() {
            return DesignerMsg.REPORT_ACTIVITIES_DESC;
        }

        @Override
        protected CheckTreePanel createTreePanel(@NotNull UiContainer parent) {
            this.treePanel = ChartViewerUtils.createActivityCheckTreePanel((UiContainer)parent, (ChartManager)ReportDialog.this.chartManager, (CheckSelectionListener)ReportDialog.this.treeListener);
            return this.treePanel;
        }

        protected ActivityCheckTree getTree() {
            return (ActivityCheckTree)this.treePanel.getTree();
        }
    }

    private abstract class OptionPage
    extends Panel {
        private UiComponent mainPanel;
        private TextArea msgArea;
        private Panel optionsPanel;
        private final int type;

        protected OptionPage(UiContainer parent, int type) {
            super(parent);
            this.type = type;
            this.initComponents();
        }

        public UiComponent getMainPanel(Panel parent) {
            if (this.mainPanel == null) {
                this.mainPanel = this.createTreePanel((UiContainer)parent);
            }
            return this.mainPanel;
        }

        public void initComponents() {
            this.setLayout((oracle.bpm.ui.layout.Layout)new BorderLayout());
            this.add((UiComponent)this.createPagePanel((UiContainer)this), "Center");
        }

        public void setEnabled(boolean enabled) {
            super.setEnabled(enabled);
            if (this.mainPanel != null) {
                this.mainPanel.setEnabled(enabled);
            }
            if (this.optionsPanel != null) {
                this.optionsPanel.setEnabled(enabled);
            }
            if (this.msgArea != null) {
                this.msgArea.setEnabled(enabled);
            }
            this.getButtonTuple().setEnabled(enabled);
        }

        protected abstract CheckTreePanel createTreePanel(@NotNull UiContainer var1);

        protected abstract CheckTree getTree();

        protected Msg createLabel() {
            return UIMsg.TO_MSG((String)"A title must be specified here for the default panel");
        }

        @NotNull
        protected ReportGenerator.DetailOption getDetailOption() {
            ButtonTuple buttonTuple = this.getButtonTuple();
            ReportGenerator.DetailOption result = buttonTuple.isDetails() ? ReportGenerator.DetailOption.DETAILS : (this.getTree().getRoot().getSelected() == TreeNode.Selection.ALL ? ReportGenerator.DetailOption.SUMMARY_ALL : ReportGenerator.DetailOption.SUMMARY);
            return result;
        }

        @NotNull
        protected Panel createOptionsPanel(@NotNull UiContainer parent) {
            BorderPanel panel = new BorderPanel(parent);
            panel.setLayout((oracle.bpm.ui.layout.Layout)new FlowLayout(0));
            switch (this.type) {
                case 1: {
                    ReportDialog.this.indicatorsTuple = ReportDialog.this.createButtons((Panel)panel);
                    break;
                }
                case 2: {
                    ReportDialog.this.activitiesTuple = ReportDialog.this.createButtons((Panel)panel);
                    break;
                }
                case 4: {
                    ReportDialog.this.categoriesTuple = ReportDialog.this.createButtons((Panel)panel);
                    break;
                }
                case 8: {
                    ReportDialog.this.resourcesTuple = ReportDialog.this.createButtons((Panel)panel);
                }
            }
            return panel;
        }

        protected Panel createPanel(UiContainer parent) {
            Panel panel = new Panel(parent){

                public void setEnabled(boolean enabled) {
                    super.setEnabled(enabled);
                    for (UiComponent component : this.getComponents()) {
                        component.setEnabled(enabled);
                    }
                }
            };
            panel.setLayout((oracle.bpm.ui.layout.Layout)new BorderLayout());
            return panel;
        }

        @NotNull
        private ButtonTuple getButtonTuple() {
            ButtonTuple result = null;
            switch (this.type) {
                case 1: {
                    result = ReportDialog.this.indicatorsTuple;
                    break;
                }
                case 2: {
                    result = ReportDialog.this.activitiesTuple;
                    break;
                }
                case 4: {
                    result = ReportDialog.this.categoriesTuple;
                    break;
                }
                case 8: {
                    result = ReportDialog.this.resourcesTuple;
                }
            }
            return result;
        }

        private Panel createPagePanel(UiContainer parent) {
            RelativeLayout layout = new RelativeLayout();
            Panel contentPane = new Panel(parent);
            contentPane.setLayout((oracle.bpm.ui.layout.Layout)layout);
            this.optionsPanel = this.createOptionsPanel((UiContainer)contentPane);
            LabelMultiline msgArea = new LabelMultiline((UiContainer)contentPane, this.createLabel());
            contentPane.add((UiComponent)this.optionsPanel, (Object)"optionsPanel");
            contentPane.add((UiComponent)msgArea, (Object)"label");
            contentPane.add(this.getMainPanel(contentPane), (Object)"mainPanel");
            Layout.fixToRoot((RelativeLayout)layout, (String)"optionsPanel", (AttributeType)AttributeType.TOP, (int)5);
            Layout.fixToRoot((RelativeLayout)layout, (String)"optionsPanel", (AttributeType)AttributeType.LEFT, (int)5);
            Layout.fixToRoot((RelativeLayout)layout, (String)"optionsPanel", (AttributeType)AttributeType.RIGHT, (int)-5);
            Layout.fixToComp((RelativeLayout)layout, (String)"label", (AttributeType)AttributeType.TOP, (String)"optionsPanel", (AttributeType)AttributeType.BOTTOM, (int)5);
            Layout.fixToComp((RelativeLayout)layout, (String)"label", (AttributeType)AttributeType.LEFT, (String)"optionsPanel");
            Layout.fixToComp((RelativeLayout)layout, (String)"label", (AttributeType)AttributeType.RIGHT, (String)"optionsPanel");
            Layout.fixToComp((RelativeLayout)layout, (String)"mainPanel", (AttributeType)AttributeType.TOP, (String)"label", (AttributeType)AttributeType.BOTTOM, (int)5);
            Layout.fixToComp((RelativeLayout)layout, (String)"mainPanel", (AttributeType)AttributeType.LEFT, (String)"label");
            Layout.fixToComp((RelativeLayout)layout, (String)"mainPanel", (AttributeType)AttributeType.RIGHT, (String)"label");
            Layout.fixToRoot((RelativeLayout)layout, (String)"mainPanel", (AttributeType)AttributeType.BOTTOM, (int)-5);
            return contentPane;
        }
    }

    public class ButtonTuple {
        private final RadioButton<ReportGenerator.DetailOption> details;
        private final ActionListener detailsListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ReportDialog.this.checkNonRepeatedDetails();
            }
        };
        private final RadioButton<ReportGenerator.DetailOption> summary;

        public ButtonTuple(UiContainer parent) {
            this.summary = new RadioButton(parent, DesignerMsg.SUMMARY);
            this.details = new RadioButton(parent, DesignerMsg.DETAILS);
            this.groupTupleButtons();
        }

        public void setDetails(boolean bool) {
            this.details.setSelected(bool);
            this.summary.setSelected(!bool);
        }

        public void setEnabled(boolean enabled) {
            this.summary.setEnabled(enabled);
            this.details.setEnabled(enabled);
        }

        public boolean isDetails() {
            return this.details.isSelected();
        }

        private void groupTupleButtons() {
            ButtonGroup btnGroup = new ButtonGroup();
            btnGroup.add(this.summary);
            btnGroup.add(this.details);
            this.summary.setSelected(true);
            this.details.setSelected(false);
            this.details.addActionListener(this.detailsListener);
        }
    }
}

