/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.simulation;

import fuego.simulation.NormalDistribution;
import fuego.simulation.RealDistribution;
import oracle.bpm.collections.lists.MsgList;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.simulation.GenericDistributionDataTableModel;
import oracle.bpm.lang.Interval;
import oracle.bpm.lang.IntervalFormat;
import oracle.bpm.lang.IntervalUnit;
import oracle.bpm.project.msg.ProjectMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.ListSelectionMode;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.editors.AbstractCellEditor;
import oracle.bpm.ui.event.FocusAdapter;
import oracle.bpm.ui.event.FocusEvent;
import oracle.bpm.ui.event.FocusListener;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.table.Table;
import oracle.bpm.ui.table.TableColumn;
import oracle.bpm.ui.table.TableModel;
import oracle.bpm.ui.table.editors.NumericFieldCellEditor;
import oracle.bpm.ui.table.editors.TableCellEditor;
import oracle.bpm.ui.text.IntervalField;
import oracle.bpm.ui.text.NumericField;

public class RealDistributionCriteriaPanel
extends Panel {
    private int meanType;
    private RealDistribution realDistribution;
    protected static final int INTERVAL_LABEL_COLUMN = 0;
    protected static final int MEDIA_COLUMN = 1;
    protected static final int STD_DEVIATION_COLUMN = 2;

    public RealDistributionCriteriaPanel(UiContainer parent, RealDistribution realDistribution, int meanType) {
        super(parent);
        this.realDistribution = realDistribution;
        this.meanType = meanType;
        this.init();
    }

    public static RealDistributionCriteriaPanel create(UiContainer parent, RealDistribution realDistribution, int meanType) {
        return new RealDistributionCriteriaPanel(parent, realDistribution, meanType);
    }

    public RealDistribution getRealDistribution(int meanType) {
        if (meanType == 0) {
            return this.getIntervalDistribution();
        }
        return this.getNumericDistribution();
    }

    private void init() {
        IntervalLabelProvider labelProviderStdDeviationColumn;
        Object cellEditorStdDeviationColumn;
        IntervalLabelProvider labelProviderMediaColumn;
        Object cellEditorMediaColumn;
        GenericDistributionDataTableModel distributionDataTableModel;
        this.setLayout((Layout)new BorderLayout());
        if (this.meanType == 0) {
            distributionDataTableModel = new IntervalDistributionDataTableModel(this.realDistribution, DesignerMsg.INTERVAL, ProjectMsg.MEAN, ProjectMsg.STDDEVIATION);
            cellEditorMediaColumn = new IntervalCellEditor();
            labelProviderMediaColumn = new IntervalLabelProvider();
            cellEditorStdDeviationColumn = new IntervalCellEditor();
            labelProviderStdDeviationColumn = new IntervalLabelProvider();
        } else {
            distributionDataTableModel = new NumericDistributionDataTableModel(this.realDistribution, DesignerMsg.INTERVAL, ProjectMsg.MEAN, ProjectMsg.STDDEVIATION);
            cellEditorMediaColumn = new IntegerFieldCellEditor(false);
            labelProviderMediaColumn = null;
            cellEditorStdDeviationColumn = new IntegerFieldCellEditor(true);
            labelProviderStdDeviationColumn = null;
        }
        RealDistributionsTable distributionDataTable = new RealDistributionsTable((UiContainer)this, distributionDataTableModel);
        TableColumn column = distributionDataTable.getColumn(1);
        column.setCellEditor((TableCellEditor)cellEditorMediaColumn);
        if (labelProviderMediaColumn != null) {
            column.setLabelProvider((LabelProvider)labelProviderMediaColumn);
        }
        column = distributionDataTable.getColumn(2);
        column.setCellEditor((TableCellEditor)cellEditorStdDeviationColumn);
        if (labelProviderStdDeviationColumn != null) {
            column.setLabelProvider((LabelProvider)labelProviderStdDeviationColumn);
        }
        this.add((UiComponent)distributionDataTable, "Center");
    }

    private RealDistribution getNumericDistribution() {
        return this.realDistribution;
    }

    private RealDistribution getIntervalDistribution() {
        return this.realDistribution;
    }

    private class IntervalCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private IntervalField intervalField;

        private IntervalCellEditor() {
        }

        public UiComponent getTableCellEditor(Table parentTable, Object value, boolean isSelected, int row, int column) {
            if (value == null) {
                RealDistributionsTable realDistributionsTable = (RealDistributionsTable)parentTable;
                realDistributionsTable.getModel().createDefaultDistributionIfEmpty(row);
                return this.createEditor((UiContainer)parentTable, realDistributionsTable.getModel().getValueAt(row, column));
            }
            return this.createEditor((UiContainer)parentTable, value);
        }

        public Object getCellEditorValue() {
            return this.intervalField.getInterval().getTotalMicroseconds();
        }

        public UiComponent createEditor(UiContainer parent, Object value) {
            this.intervalField = IntervalField.createPositiveIntervalField((UiContainer)parent, (IntervalUnit)IntervalUnit.DAYS, (IntervalUnit)IntervalUnit.SECONDS);
            final long microseconds = (Long)value;
            this.intervalField.addFocusListener((FocusListener)new FocusAdapter(){

                public void focusLost(FocusEvent e) {
                    if (IntervalCellEditor.this.intervalField.getInterval() == null) {
                        IntervalCellEditor.this.intervalField.setInterval(Interval.normalizedValueOf(microseconds));
                    }
                }
            });
            this.intervalField.setInterval(Interval.normalizedValueOf(microseconds));
            return this.intervalField;
        }
    }

    private static final class RealDistributionsTable
    extends Table {
        public RealDistributionsTable(UiContainer parent, GenericDistributionDataTableModel dataTableModel) {
            super(parent, (TableModel)dataTableModel, ListSelectionMode.SINGLE_SELECTION);
            this.getColumn(1).setWidth(150);
            this.getColumn(1).setResizable(false);
            this.getColumn(2).setWidth(150);
            this.getColumn(2).setResizable(false);
        }

        public GenericDistributionDataTableModel getModel() {
            return (GenericDistributionDataTableModel)super.getModel();
        }

        public void reload() {
            this.getModel().fireTableDataChanged();
        }
    }

    private static class NumericDistributionDataTableModel
    extends GenericDistributionDataTableModel {
        public NumericDistributionDataTableModel(RealDistribution realDistribution, Msg ... columns) {
            super(realDistribution, MsgList.create(columns));
        }

        @Override
        public Class getColumnClass(int column) {
            switch (column) {
                case 1: 
                case 2: {
                    return NumericField.class;
                }
            }
            return super.getColumnClass(column);
        }

        @Override
        public void createDefaultDistributionIfEmpty(int row) {
            NormalDistribution distribution = (NormalDistribution)this.getRow(row);
            if (NormalDistribution.hasNoSample((NormalDistribution)distribution)) {
                distribution.setMean(1L);
                distribution.setDeviation(0L);
                this.fireTableRowsUpdated(row, row);
            }
        }
    }

    private static class IntervalLabelProvider
    extends LabelProvider.Default<Long> {
        private IntervalLabelProvider() {
        }

        public String getText(Long element) {
            if (element == null) {
                return null;
            }
            Interval interval = Interval.normalizedValueOf(element);
            return IntervalFormat.getInstance(IntervalUnit.DAYS, IntervalUnit.SECONDS).format(interval);
        }
    }

    private static class IntervalDistributionDataTableModel
    extends GenericDistributionDataTableModel {
        public IntervalDistributionDataTableModel(RealDistribution realDistribution, Msg ... columns) {
            super(realDistribution, MsgList.create(columns));
        }

        @Override
        public Class getColumnClass(int column) {
            switch (column) {
                case 1: 
                case 2: {
                    return IntervalField.class;
                }
            }
            return super.getColumnClass(column);
        }

        @Override
        public void createDefaultDistributionIfEmpty(int row) {
            NormalDistribution distribution = (NormalDistribution)this.getRow(row);
            if (NormalDistribution.hasNoSample((NormalDistribution)distribution)) {
                distribution.setMean(NormalDistribution.DEFAULT_MEAN);
                distribution.setDeviation(NormalDistribution.DEFAULT_DEVIATION);
                this.fireTableRowsUpdated(row, row);
            }
        }
    }

    private static class IntegerFieldCellEditor
    extends NumericFieldCellEditor {
        private NumericField<Integer> field;
        private boolean isDeviationColumn;

        public IntegerFieldCellEditor(boolean deviation) {
            this.isDeviationColumn = deviation;
        }

        public NumericField<Integer> createNumericField(UiContainer parent) {
            this.field = NumericField.createIntegerNumericField((UiContainer)parent);
            this.field.setRange((Number)(this.isDeviationColumn ? 0 : 1), (Number)1000);
            this.field.setStepSize((Number)1);
            return this.field;
        }

        public Object getCellEditorValue() {
            return ((Integer)this.field.getValue()).longValue();
        }

        public UiComponent getTableCellEditor(Table parentTable, Object value, boolean isSelected, int row, int column) {
            if (value == null) {
                RealDistributionsTable realDistributionsTable = (RealDistributionsTable)parentTable;
                realDistributionsTable.getModel().createDefaultDistributionIfEmpty(row);
                return super.getTableCellEditor(parentTable, realDistributionsTable.getModel().getValueAt(row, column), isSelected, row, column);
            }
            return super.getTableCellEditor(parentTable, value, isSelected, row, column);
        }
    }
}

