/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.simulation;

import oracle.bpm.designer.ProjectObjectTreeNode;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.simulation.NewSimulationAction;
import oracle.bpm.designer.simulation.ProjectSimulationTreeNode;
import oracle.bpm.designer.utils.IconFactory;
import oracle.bpm.extensionpoint.metadata.TreeNodeMetadata;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectSimulationsContainer;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.FontStyle;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.action.ActionGroup;
import oracle.bpm.ui.action.BaseAction;

@TreeNodeMetadata(objectType=ProjectSimulationsContainer.class)
public class ProjectSimulationsTreeNode
extends ProjectObjectTreeNode<ProjectSimulationsContainer> {
    public ProjectSimulationsTreeNode(ProjectSimulationsContainer simulations) {
        super((ProjectObject)simulations);
        this.setMsg(DesignerMsg.SIMULATION_DEFINITIONS);
    }

    @Override
    public Image resolveIcon() {
        Image icon = Image.create((Msg)this.getMsg());
        return !this.isReadOnly() ? icon : IconFactory.createReadOnly(icon);
    }

    public boolean isReadOnly() {
        return ((ProjectSimulationsContainer)this.getProjectObject()).isReadOnly() || this.getProject().isReadOnly();
    }

    public FontStyle getFontModifiers() {
        return FontStyle.BOLD;
    }

    @Override
    public String toString() {
        return this.getMsg().getString();
    }

    @Override
    public ActionGroup createActions() {
        ActionGroup result = new ActionGroup(this.getMsg());
        result.add((BaseAction)new NewSimulationAction(this.getProject()));
        result.addSeparator();
        return result;
    }

    public ProjectSimulationTreeNode getChildAt(int i) {
        return (ProjectSimulationTreeNode)super.getChildAt(i);
    }

    @Override
    protected void onLoading() {
        this.build();
    }

    private void build() {
        for (ProjectObject simulation : ((ProjectSimulationsContainer)this.getProjectObject()).getChildren()) {
            this.addDynamic(simulation, null);
        }
    }
}

