/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.simulation;

import java.util.Date;
import oracle.bpm.designer.AbstractEditor;
import oracle.bpm.designer.AbstractStudioWorkbench;
import oracle.bpm.designer.DesignerException;
import oracle.bpm.designer.EditorType;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.simulation.ProjectSimulationProcessesPanel;
import oracle.bpm.designer.simulation.ResourcesTable;
import oracle.bpm.extensionpoint.metadata.Editor;
import oracle.bpm.lang.Interval;
import oracle.bpm.lang.Time;
import oracle.bpm.project.FuegoProject;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.events.ProjectListener;
import oracle.bpm.project.model.events.ProjectListenerAdapter;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.simulation.ModelSimulation;
import oracle.bpm.project.model.simulation.ProjectSimulation;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.CheckBox;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.TabbedPane;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.FocusAdapter;
import oracle.bpm.ui.event.FocusEvent;
import oracle.bpm.ui.event.FocusListener;
import oracle.bpm.ui.event.TableModelListener;
import oracle.bpm.ui.layout.AttributeConstraint;
import oracle.bpm.ui.layout.AttributeType;
import oracle.bpm.ui.layout.Constraint;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.RelativeLayout;
import oracle.bpm.ui.layout.form.CellConstraints;
import oracle.bpm.ui.layout.form.FormLayout;
import oracle.bpm.ui.layout.form.PanelBuilder;
import oracle.bpm.ui.text.IntervalField;
import oracle.bpm.ui.text.TimeField;

@Editor(objectClass=ProjectSimulation.class)
public class ProjectSimulationEditor
extends AbstractEditor<ProjectSimulation> {
    private IntervalField durationField;
    private CheckBox letInflightFinish;
    private TableModelListener modelListener;
    private ProjectListener projectListenerForModel;
    private ProjectListener projectListenerForModelSimulation;
    private ProjectSimulationProcessesPanel projectSimulationProcessesPanel;
    private ResourcesTable resourcesTable;
    private TimeField startTimeField;
    private TabbedPane tabbedPane;
    private CheckBox useCalendarRulesCheckBox;
    private static final String ID_SIMULATION = "fuego.eclipse.studio.views.SimulationView";

    public ProjectSimulationEditor(UiContainer parent, ProjectSimulation model) {
        super(parent, model, ProjectSimulation.class);
    }

    public ProjectSimulationProcessesPanel getProjectSimulationProcessesPanel() {
        return this.projectSimulationProcessesPanel;
    }

    @Override
    public EditorType getEditorType() {
        return EditorType.SIMULATION_CONFIGURATION;
    }

    @Override
    public Image getIcon() {
        return Image.create((Msg)DesignerMsg.SIMULATION);
    }

    @Override
    public void disposeEditor() {
        this.getProject().removeListener(this.projectListenerForModelSimulation);
        this.projectListenerForModelSimulation = null;
        this.getProject().removeListener(this.projectListenerForModel);
        this.projectListenerForModel = null;
        super.disposeEditor();
    }

    @Override
    protected void objectToEditor() {
        if (this.getProjectObject() != null) {
            this.durationField.setInterval(((ProjectSimulation)this.getProjectObject()).getDuration());
            this.startTimeField.setTime(Time.valueOf(((ProjectSimulation)this.getProjectObject()).getStartTime()));
            this.useCalendarRulesCheckBox.setSelected(((ProjectSimulation)this.getProjectObject()).getUseCalendarRules());
            this.letInflightFinish.setSelected(((ProjectSimulation)this.getProjectObject()).getInflightFinish());
        }
    }

    @Override
    protected void editorToObject() {
        this.getMutableProjectSimulation().setStartTime(this.startTimeField.getTime());
        this.getMutableProjectSimulation().setDuration(this.durationField.getInterval());
        this.getMutableProjectSimulation().setUseCalendarRules(this.useCalendarRulesCheckBox.isSelected());
        this.getMutableProjectSimulation().setInflightFinish(this.letInflightFinish.isSelected());
        this.updateModelResources(this.getMutableProjectSimulation());
        this.projectSimulationProcessesPanel.panelToModel();
    }

    @Override
    protected void buildUI(UiContainer parent) {
        RelativeLayout relativeLayout = new RelativeLayout();
        parent.setLayout((Layout)relativeLayout);
        this.tabbedPane = new TabbedPane(parent);
        Panel timeRelatedPanel = this.buildTimeRelatedPanel(parent);
        Panel resourcesPanel = this.buildResourcesPanel((UiContainer)this.tabbedPane);
        this.projectSimulationProcessesPanel = new ProjectSimulationProcessesPanel((FuegoProject)this.getProject(), (UiContainer)this.tabbedPane, (ProjectSimulation)this.getProjectObject());
        parent.add((UiComponent)timeRelatedPanel, (Object)"generationPanel");
        parent.add((UiComponent)this.tabbedPane, (Object)"tabbedPane");
        this.tabbedPane.addTab(DesignerMsg.PROJECT, (UiComponent)this.projectSimulationProcessesPanel);
        this.tabbedPane.addTab(DesignerMsg.RESOURCES, (UiComponent)resourcesPanel);
        relativeLayout.addConstraint("generationPanel", AttributeType.TOP, (Constraint)new AttributeConstraint("_container", AttributeType.TOP));
        relativeLayout.addConstraint("generationPanel", AttributeType.LEFT, (Constraint)new AttributeConstraint("_container", AttributeType.LEFT, 5));
        relativeLayout.addConstraint("generationPanel", AttributeType.RIGHT, (Constraint)new AttributeConstraint("_container", AttributeType.RIGHT));
        relativeLayout.addConstraint("tabbedPane", AttributeType.TOP, (Constraint)new AttributeConstraint("generationPanel", AttributeType.BOTTOM));
        relativeLayout.addConstraint("tabbedPane", AttributeType.LEFT, (Constraint)new AttributeConstraint("_container", AttributeType.LEFT));
        relativeLayout.addConstraint("tabbedPane", AttributeType.RIGHT, (Constraint)new AttributeConstraint("_container", AttributeType.RIGHT));
        relativeLayout.addConstraint("tabbedPane", AttributeType.BOTTOM, (Constraint)new AttributeConstraint("_container", AttributeType.BOTTOM));
        this.initProjectListener();
        AbstractStudioWorkbench.getInstance().showView(ID_SIMULATION);
    }

    private ProjectSimulation getMutableProjectSimulation() {
        return (ProjectSimulation)this.getProjectObject();
    }

    private Panel buildResourcesPanel(UiContainer parent) {
        ResourcesTable.ViewPanel panel = new ResourcesTable.ViewPanel(parent, (ProjectSimulation)this.getProjectObject());
        this.resourcesTable = panel.getResourcesTable();
        return panel;
    }

    private Panel buildTimeRelatedPanel(UiContainer parent) {
        Panel panel = new Panel(parent);
        FormLayout layout = new FormLayout("2dlu, pref, 2dlu, pref, 2dlu, pref, 2dlu, pref", "2dlu, pref, 2dlu, pref, 2dlu, pref, 2dlu, pref, 2dlu");
        PanelBuilder builder = layout.createBuilder(panel);
        Label durationLabel = Label.create((UiContainer)panel, (Msg)DesignerMsg.DURATION);
        this.durationField = IntervalField.createPositiveIntervalField((UiContainer)panel);
        this.durationField.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                if (ProjectSimulationEditor.this.durationField.getInterval() == null) {
                    ProjectSimulationEditor.this.durationField.setInterval(((ProjectSimulation)ProjectSimulationEditor.this.getProjectObject()).getDuration());
                }
            }
        });
        Label startTimeLabel = Label.create((UiContainer)panel, (Msg)DesignerMsg.START_TIME);
        this.startTimeField = new TimeField((UiContainer)panel);
        this.startTimeField.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                Time time = ProjectSimulationEditor.this.startTimeField.getTime();
                if (time == null || time.getMicroSeconds() < 0L) {
                    ProjectSimulationEditor.this.startTimeField.setTime(Time.now());
                }
            }
        });
        this.useCalendarRulesCheckBox = CheckBox.create((UiContainer)panel, (Msg)DesignerMsg.USE_CALENDAR_RULE);
        this.letInflightFinish = CheckBox.create((UiContainer)panel, (Msg)DesignerMsg.INFLIGHT_FINISH);
        CellConstraints cc = layout.createCellConstraints();
        Label label = Label.create((UiContainer)panel, (Msg)DesignerMsg.SIMULATION_DEFINITION);
        label.setFont(label.getFont().bold());
        builder.add((UiComponent)label, cc.xy(2, 2));
        builder.add((UiComponent)startTimeLabel, cc.xy(2, 4));
        builder.add((UiComponent)this.startTimeField, cc.xy(4, 4));
        builder.add((UiComponent)durationLabel, cc.xy(2, 6));
        builder.add((UiComponent)this.durationField, cc.xy(4, 6));
        builder.add((UiComponent)this.useCalendarRulesCheckBox, cc.xy(2, 8));
        panel.add((UiComponent)this.letInflightFinish, (Object)cc.xy(4, 8));
        return panel;
    }

    private void checkGenerationFields() {
        if (this.startTimeField.getTime().getMicroSeconds() < 0L) {
            this.startTimeField.setTime(Time.valueOf(new Date(0L)));
        }
        if (this.durationField.getInterval().getMicroSeconds() < 0L) {
            this.durationField.setInterval(Interval.valueOf(0L));
        }
    }

    private void checkResources() throws DesignerException {
        this.resourcesTable.checkResources();
    }

    private void updateModelResources(ProjectSimulation model) {
        this.resourcesTable.updateModelResources(model);
    }

    private void initProjectListener() {
        if (this.projectListenerForModelSimulation == null) {
            this.projectListenerForModelSimulation = new ProjectListenerAdapter<ModelSimulation>(ModelSimulation.class){

                public void postObjectAdded(ModelSimulation object, ProjectObject parent) {
                    ProjectSimulationEditor.this.projectSimulationProcessesPanel.modelSimulationAddedToProject(object);
                }

                public void postObjectRemoved(ModelSimulation object, ProjectObject parent) {
                    ProjectSimulationEditor.this.projectSimulationProcessesPanel.modelSimulationRemovedFromProject(object);
                }
            };
            this.getProject().addListener(this.projectListenerForModelSimulation);
        }
        if (this.projectListenerForModel == null) {
            this.projectListenerForModel = new ProjectListenerAdapter<Process>(Process.class){

                public void postObjectRemoved(Process object, ProjectObject parent) {
                    ProjectSimulationEditor.this.projectSimulationProcessesPanel.modelRemovedFromProject(object);
                }
            };
            this.getProject().addListener(this.projectListenerForModel);
        }
    }
}

