/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.simulation;

import fuego.simulation.ActivityInfo;
import fuego.simulation.Event;
import fuego.simulation.InteractiveActivityInfo;
import fuego.simulation.ProcessRuntimeInfoInterface;
import fuego.simulation.ResourceInfo;
import fuego.simulation.Simulation;
import fuego.simulation.SimulationFlowNodeImpl;
import fuego.simulation.Token;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.bpm.bam.model.SimulationPhotoModel;
import oracle.bpm.bamdata.ProcessInfo;
import oracle.bpm.bamdata.Run;
import oracle.bpm.designer.AbstractStudioWorkbench;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.project.model.processes.Subprocess;
import oracle.bpm.project.model.simulation.ModelEvent;
import oracle.bpm.project.model.simulation.ModelListener;
import oracle.bpm.project.model.simulation.ModelSimulation;
import oracle.bpm.project.model.simulation.ProjectSimulation;
import oracle.bpm.project.model.simulation.SimulationFlowNode;
import oracle.bpm.project.model.simulation.SimulationResource;
import oracle.bpm.project.model.util.ModelUtils;

class ProcessSimulation
extends Simulation
implements ProcessRuntimeInfoInterface {
    protected ModelSimulation model;
    private transient ActivityInfo processRuntimeInfo;
    private ProjectSimulation projectSimulationModel;

    public ProcessSimulation(ProjectSimulation projectSimulationModel, ModelSimulation modelSimulation) {
        super(projectSimulationModel);
        this.projectSimulationModel = projectSimulationModel;
        this.model = modelSimulation;
        this.processRuntimeInfo = ActivityInfo.create((Run)this, (ProjectSimulation)projectSimulationModel, (ModelSimulation)modelSimulation, (String)modelSimulation.getProcess().getId(), (String[])projectSimulationModel.getCategoryLabels());
    }

    public ProjectSimulation getProjectSimulationModel() {
        return this.projectSimulationModel;
    }

    public ModelSimulation getModel(String name) {
        return this.getModel();
    }

    public ModelSimulation getModel() {
        return this.model;
    }

    public ActivityInfo getProcessActivityInfo() {
        return this.processRuntimeInfo;
    }

    public int getProcessInstanceCount(Process process) {
        return 0;
    }

    public Map<Process, Integer> getProcessInstanceCountMap() {
        return null;
    }

    public ModelSimulation getProcessModel(Process process) {
        return null;
    }

    public void setProcessRuntimeInfo(String processName, ActivityInfo childProcessInfo) {
    }

    public ProcessInfo getProcessRuntimeInfo() {
        return this.processRuntimeInfo;
    }

    public ProcessInfo getProcessRuntimeInfo(String processId) {
        return this.getProcessRuntimeInfo();
    }

    public void addInteractiveActivity(InteractiveActivityInfo interactiveActivityInfo) {
    }

    public String[] getProcesses() {
        return new String[]{this.processRuntimeInfo.getName()};
    }

    public String[] getProcessNames() {
        return new String[]{this.processRuntimeInfo.getName()};
    }

    public SimulationPhotoModel getSimulationPhotoModel() {
        HashMap<String, Process> processContentMap = new HashMap<String, Process>();
        processContentMap.put(this.getModel().getProcess().getId(), this.getModel().getProcess());
        HashMap<String, ActivityInfo> processInfoMap = new HashMap<String, ActivityInfo>();
        processInfoMap.put(this.getModel().getProcess().getId(), this.processRuntimeInfo);
        return new SimulationPhotoModel(processContentMap, processInfoMap);
    }

    public void generateFirstEvent(long wallClockStart) {
        this.startTime = this.getProjectSimulationModel().getStartTime();
        if (this.startTime == Long.MIN_VALUE) {
            this.startTime = wallClockStart;
        }
        this.eventQueue.clear();
        this.stopSimulation = false;
        this.simulationPaused = false;
        this.currentTime = this.startTime;
        Event event = Event.createGenerateEvent((long)this.currentTime, (int)this.getNextCategory(this.getProjectSimulationModel()), (ProjectSimulation)this.projectSimulationModel, (ModelSimulation)this.getModel(), (ActivityInfo)this.getProcessActivityInfo());
        this.eventQueue.offer(event);
    }

    public void runSimulation() {
        Token.setNextId((int)0);
        this.getModel().addListener((ModelListener)this);
        long wallClockStart = System.currentTimeMillis() * 1000L;
        this.generateFirstEvent(wallClockStart);
        int totalInstances = 0;
        this.simulate(wallClockStart, totalInstances);
        this.terminateSimulation();
        this.getModel().removeListener((ModelListener)this);
        AbstractStudioWorkbench.getInstance().setSimulation(null);
    }

    public void simulate(long wallClockStart, int totalInstances) {
        while (!this.stopSimulation && !this.eventQueue.isEmpty()) {
            this.checkPause();
            Event currentEvent = (Event)this.eventQueue.remove();
            long newTime = currentEvent.getDueTime();
            long simulationElapsedTime = newTime - this.startTime;
            if (simulationElapsedTime > this.getProjectSimulationModel().getDurationMicroseconds()) break;
            if (this.performingAnimation && newTime > this.currentTime) {
                double scale = this.getTimeScalePct();
                long sleepTime = (long)(5000.0 / scale);
                this.letsTimePass(sleepTime);
                if (this.stopSimulation) break;
            }
            this.currentTime = newTime;
            this.checkPause();
            if (this.simulationPauseEndTime != 0L) {
                this.pausedTime = this.simulationPauseEndTime - this.simulationPauseStartTime;
                wallClockStart += this.pausedTime;
                this.simulationPauseEndTime = 0L;
                this.simulationPauseStartTime = 0L;
            }
            switch (currentEvent.getType()) {
                case 7: {
                    totalInstances = this.processGenerate(currentEvent, true, totalInstances);
                    break;
                }
                case 1: {
                    totalInstances = this.processGenerate(currentEvent, false, totalInstances);
                    break;
                }
                case 2: 
                case 6: {
                    this.processMove(currentEvent);
                    break;
                }
                case 3: {
                    this.processTerminate(currentEvent);
                }
            }
            this.fireEventDue(currentEvent);
        }
    }

    public ResourceInfo getResourceInfo(Simulation simulation, ProjectSimulation projectSimulationModel, SimulationResource simulationResource) {
        return new ResourceInfo((Run)simulation, projectSimulationModel, simulationResource.getId(), simulationResource.getCapacity(), simulationResource.getCost());
    }

    protected Token checkIfLeavingGroups(Token token, FlowNode from, FlowNode to, SequenceFlow transition) {
        Subprocess parentGroup;
        if ((ModelUtils.isExceptionFlow((SequenceFlow)transition) || ModelUtils.isDueFlow((SequenceFlow)transition) || ModelUtils.isEndEvent((FlowNode)to)) && (parentGroup = ProcessSimulation.getParentGroup((FlowNode)from)) != ProcessSimulation.getParentGroup((FlowNode)to)) {
            token.remove();
            token = token.getParent();
            ActivityInfo parentGroupInfo = (ActivityInfo)this.getProcessRuntimeInfo().getActivity(parentGroup.getId());
            parentGroupInfo.remove(token, false);
            this.fireEventDue(Event.createMoveEvent((Token)token, (long)this.currentTime, (FlowNode)parentGroup, (FlowNode)to, null, (boolean)false));
            return this.checkIfLeavingGroups(token, (FlowNode)parentGroup, to, transition);
        }
        return token;
    }

    protected void resourceCapacityChanged(ModelEvent e, List<ActivityInfo> activities) {
        this.resourceCapacityChanged(e, activities, this.getProcessRuntimeInfo());
    }

    private void processTerminate(Event currentEvent) {
        Token token = currentEvent.getToken();
        SimulationFlowNode endActivity = token.getModel().getAnyEndFlowNode();
        assert (endActivity != null) : "End activity cannot be null";
        ActivityInfo simActivity = (ActivityInfo)token.getProcessInfo().getActivity(endActivity.getId());
        simActivity.remove(token);
        token.getProcessInfo().terminateInstance(token.getCreationTime(), token.getCategory());
    }

    private void processMove(Event currentEvent) {
        ActivityInfo simActivity;
        FlowNode node;
        Token token = currentEvent.getToken();
        if (currentEvent.isFirstStep()) {
            node = currentEvent.getFrom();
            simActivity = (ActivityInfo)token.getProcessInfo().getActivity(node.getId());
            SequenceFlow t = currentEvent.getTransition();
            boolean normalTransition = t != null && ModelUtils.isExceptionFlow((SequenceFlow)t);
            simActivity.remove(token, normalTransition);
            token = this.checkIfLeavingGroups(token, node, currentEvent.getTo(), t);
            currentEvent.setToken(token);
            List activitiesToActivate = simActivity.activate();
            for (Token next : activitiesToActivate) {
                if (next == null) continue;
                try {
                    SimulationFlowNode simulationActivity = this.addSimulationActivity(token, node);
                    ((SimulationFlowNodeImpl)simulationActivity).scheduleMove(this.currentTime, next, this.eventQueue, this.random);
                }
                catch (ProjectException e) {
                    e.printStackTrace();
                }
            }
        }
        if (this.performingAnimation && !currentEvent.isLastStep()) {
            this.eventQueue.offer(Event.createMoveStep((Event)currentEvent, (int)this.stepIncrement));
        } else {
            node = currentEvent.getTo();
            simActivity = (ActivityInfo)token.getProcessInfo().getActivity(node.getId());
            if (!simActivity.queue(token)) {
                try {
                    SimulationFlowNode simulationActivity = this.addSimulationActivity(token, node);
                    if (ModelUtils.isEndEvent((FlowNode)node)) {
                        ((SimulationFlowNodeImpl)simulationActivity).scheduleTerminate(this.currentTime, token, this.eventQueue, this.random);
                    } else {
                        ((SimulationFlowNodeImpl)simulationActivity).scheduleMove(this.currentTime, token, this.eventQueue, this.random);
                    }
                }
                catch (ProjectException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private SimulationFlowNode addSimulationActivity(Token token, FlowNode node) throws ProjectException {
        ModelSimulation modelSimulation = token.getModel();
        SimulationFlowNode simulationActivity = modelSimulation.findSimulationFlowNode(node.getId());
        if (simulationActivity == null) {
            simulationActivity = modelSimulation.createSimulationFlowNode(node.getId());
            modelSimulation.addSimulationFlowNode(simulationActivity);
        }
        return simulationActivity;
    }

    private int processGenerate(Event currentEvent, boolean ipc, int totalInstances) {
        Token token = currentEvent.getToken();
        SimulationFlowNode beginActivity = token.getModel().getBeginFlowNode();
        assert (beginActivity != null) : "Begin activity cannot be null";
        ActivityInfo simActivity = (ActivityInfo)token.getProcessInfo().getActivity(beginActivity.getId());
        if (!simActivity.queue(token)) {
            ((SimulationFlowNodeImpl)beginActivity).scheduleMove(this.currentTime, token, this.eventQueue, this.random);
        }
        token.getProcessInfo().createInstance(token.getCategory(), this.currentTime);
        if (!(ipc || token.getModel().getUseMaxInstances() && ++totalInstances >= token.getModel().getMaxInstances())) {
            Event event = Event.createGenerateEvent((long)this.getNextIAT(token.getModel()), (int)this.getNextCategory(token.getProjectSimulation()), (ProjectSimulation)token.getProjectSimulation(), (ModelSimulation)token.getModel(), (ActivityInfo)token.getProcessInfo());
            this.eventQueue.offer(event);
        }
        return totalInstances;
    }
}

