/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.simulation;

import java.util.Arrays;
import java.util.SortedSet;
import oracle.bpm.designer.ProjectObjectTreeNode;
import oracle.bpm.designer.simulation.ActivityNode;
import oracle.bpm.designer.utils.IconFactory;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.util.ModelUtils;
import oracle.bpm.ui.Image;

public class ProcessNode
extends ProjectObjectTreeNode<Process> {
    public ProcessNode(Process process) {
        super((ProjectObject)process);
    }

    @Override
    public Image resolveIcon() {
        return IconFactory.createProcessImageIcon(((Process)this.getProjectObject()).isReadOnly());
    }

    @Override
    public String toString() {
        return ((Process)this.getProjectObject()).getDefaultLabel();
    }

    @Override
    protected void onLoading() {
        this.buildTree();
    }

    private void buildTree() {
        FlowNode[] activities = ((Process)this.getProjectObject()).getFlowNodes().toArray(new FlowNode[0]);
        SortedSet sortNodes = ModelUtils.buildActivitySortedSet();
        sortNodes.addAll(Arrays.asList(activities));
        for (FlowNode sortNode : sortNodes) {
            if (!ModelUtils.canBeSimulated((FlowNode)sortNode)) continue;
            ActivityNode atn = new ActivityNode(sortNode);
            this.add(atn);
        }
        this.expand();
    }
}

