/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.simulation;

import oracle.bpm.designer.DesignerAction;
import oracle.bpm.designer.action.OpenObjectAction;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.simulation.SimulationNameInputValidator;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.msg.ProjectModelMsg;
import oracle.bpm.project.model.util.ModelUtils;
import oracle.bpm.project.ui.msg.ProjectUiMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.InputValidator;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiWindow;

class NewSimulationAction
extends DesignerAction {
    private Project project;

    public NewSimulationAction(Project project) {
        super(DesignerMsg.NEW_SIMULATION);
        this.requires(ProjectObject.class);
        this.project = project;
    }

    @Override
    public boolean doIt() {
        boolean result;
        try {
            result = this.newSimulation();
        }
        catch (ProjectException e) {
            MessageDialog.showError((Throwable)e);
            result = false;
        }
        return result;
    }

    public void unDoIt() {
    }

    private boolean newSimulation() throws ProjectException {
        String name = this.getNewSimulationName();
        return name != null && new OpenObjectAction(this.project.getSimulations().createAndAddProjectSimulation(name)).doIt();
    }

    private Project getProject() {
        return this.project;
    }

    private String getNewSimulationName() {
        return MessageDialog.showInput((UiWindow)Ui.getRoot(), (Msg)ProjectUiMsg.CREATE((Msg)ProjectModelMsg.PROJECT_SIMULATION), (Msg)ProjectModelMsg.PROJECT_SIMULATION, (String)ModelUtils.nextNameForProjectSimulation((Project)this.project, (String)ProjectModelMsg.PROJECT_SIMULATION.getString()), (InputValidator)new SimulationNameInputValidator(this.getProject()), (boolean)false);
    }
}

