/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.simulation;

import fuego.simulation.AbstractDistribution;
import fuego.simulation.ModelSimulationImpl;
import oracle.bpm.cil.CilCompiler;
import oracle.bpm.compiler.FuegoCompiler;
import oracle.bpm.designer.AbstractEditor;
import oracle.bpm.designer.EditorType;
import oracle.bpm.designer.ErrorList;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.simulation.ActivitiesPanel;
import oracle.bpm.designer.simulation.DistributionPanel;
import oracle.bpm.extensionpoint.metadata.Editor;
import oracle.bpm.log.Log;
import oracle.bpm.project.compile.process.ProcessChecker;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.events.ProjectListener;
import oracle.bpm.project.model.events.ProjectListenerAdapter;
import oracle.bpm.project.model.events.ProjectMessageListener;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.simulation.Distribution;
import oracle.bpm.project.model.simulation.DistributionType;
import oracle.bpm.project.model.simulation.ModelSimulation;
import oracle.bpm.project.ui.events.UiProjectAdapter;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.CheckBox;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.TabbedPane;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiFactory;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;
import oracle.bpm.ui.layout.AttributeConstraint;
import oracle.bpm.ui.layout.AttributeType;
import oracle.bpm.ui.layout.CardLayout;
import oracle.bpm.ui.layout.Constraint;
import oracle.bpm.ui.layout.FlowLayout;
import oracle.bpm.ui.layout.RelativeLayout;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.text.NumericField;
import oracle.bpm.ui.utils.Layout;

@Editor(objectClass=ModelSimulation.class)
public class ModelSimulationEditor
extends AbstractEditor<ModelSimulation> {
    private ActivitiesPanel activitiesPanel;
    private CardLayout distribCardLayout;
    private ComboBox<DistributionType> distribCombo;
    private Panel distribContainerPanel;
    private DistributionPanel distribPanel;
    private NumericField<Integer> maxInstancesSpinner;
    private ProjectListener<ModelSimulation> modelSimulationReplaceListener;
    private CheckBox useMaxInstances;

    public ModelSimulationEditor(UiContainer parent, ModelSimulation model) {
        super(parent, model, ModelSimulation.class);
        this.addModelListeners();
    }

    @Override
    public void check() throws ProjectException {
    }

    public ModelSimulation getModelSimulation() {
        return (ModelSimulation)this.getProjectObject();
    }

    @Override
    public EditorType getEditorType() {
        return EditorType.MODEL_SIMULATION_CONFIGURATION;
    }

    @Override
    public Image getIcon() {
        return Image.create((Msg)DesignerMsg.SIMULATION);
    }

    @Override
    public void disposeEditor() {
        this.removeModelListeners();
        super.disposeEditor();
    }

    @Override
    protected void objectToEditor() {
        this.distribCombo.setSelectedIndex(this.getModelSimulation().getDistributions()[0].getType().ordinal());
        boolean useMaxInstances = this.getModelSimulation().getUseMaxInstances();
        this.useMaxInstances.setSelected(useMaxInstances);
        this.maxInstancesSpinner.setEnabled(useMaxInstances);
        if (useMaxInstances) {
            this.maxInstancesSpinner.setValue((Number)this.getModelSimulation().getMaxInstances());
        }
    }

    @Override
    protected void editorToObject() {
        this.activitiesPanel.editorToObject();
        this.getModelSimulation().setUseMaxInstances(this.useMaxInstances.isSelected());
        this.getModelSimulation().setMaxInstances(((Integer)this.maxInstancesSpinner.getValue()).intValue());
        this.updateDistributionsCardLayout();
        this.getModelSimulation().setDistribution((Distribution)this.distribPanel.getDistribution());
        this.updateModelOtherDistributions();
    }

    @Override
    protected void buildUI(UiContainer parent) {
        parent.setLayout((oracle.bpm.ui.layout.Layout)new BorderLayout());
        Panel container = new Panel(parent);
        container.setLayout((oracle.bpm.ui.layout.Layout)new BorderLayout());
        TabbedPane tabbedPane = new TabbedPane((UiContainer)container);
        this.checkModel();
        tabbedPane.addTab(DesignerMsg.PROCESS_INFORMATION, (UiComponent)this.buildInstanceGenerationPanel((UiContainer)tabbedPane));
        this.activitiesPanel = this.buildActivitiesPanel((UiContainer)tabbedPane);
        tabbedPane.addTab(DesignerMsg.FLOW_NODES, (UiComponent)this.activitiesPanel);
        container.add((UiComponent)tabbedPane, (Object)"Center");
        parent.add((UiComponent)container, (Object)"Center");
        this.revalidate();
    }

    @Override
    protected void setProjectObject(ModelSimulation projectObject) {
        super.setProjectObject(projectObject);
        this.revalidate();
    }

    private void checkModel() {
        ProcessChecker checker = new ProcessChecker(((ModelSimulation)this.getProjectObject()).getProcess());
        checker.setCompiler((CilCompiler)new FuegoCompiler());
        checker.setListener((ProjectMessageListener)new ErrorList());
        try {
            checker.check();
        }
        catch (Throwable e) {
            Log.logWarning(e);
        }
    }

    private void updateModelOtherDistributions() {
        ModelSimulationImpl modelSimulation = (ModelSimulationImpl)this.getModelSimulation();
        for (int i = 0; i < this.distribCombo.getItemCount(); ++i) {
            DistributionType distributionType = (DistributionType)this.distribCombo.getItemAt(i);
            DistributionPanel otherPanel = (DistributionPanel)this.distribCardLayout.getComponent(distributionType.getString());
            AbstractDistribution panelDistribution = otherPanel.getDistribution();
            Distribution modelDistribution = modelSimulation.getCalculatedDistributionForType(distributionType);
            if (modelDistribution != null) {
                modelSimulation.removeCalculatedDistribution(modelDistribution);
            }
            modelSimulation.addCalculatedDistribution((Distribution)panelDistribution);
        }
    }

    private void updateDistributionsCardLayout() {
        DistributionType selectedDistribution = (DistributionType)this.distribCombo.getSelectedItem();
        if (selectedDistribution != null) {
            this.distribPanel = (DistributionPanel)this.distribCardLayout.getComponent(selectedDistribution.getString());
        }
    }

    private ActivitiesPanel buildActivitiesPanel(UiContainer parent) {
        return new ActivitiesPanel(parent, this.getModelSimulation(), this);
    }

    private Panel buildDistributionPanel(UiContainer parent) {
        Panel distributionPanel = new Panel(parent, DesignerMsg.GENERATION_DISTRIBUTION);
        distributionPanel.setLayout((oracle.bpm.ui.layout.Layout)new BorderLayout());
        this.distribContainerPanel = new Panel((UiContainer)distributionPanel, DesignerMsg.DISTRIBUTION_INFO);
        this.distribCardLayout = new CardLayout();
        this.distribContainerPanel.setLayout((oracle.bpm.ui.layout.Layout)this.distribCardLayout);
        Panel distTypePanel = new Panel((UiContainer)distributionPanel);
        distTypePanel.setLayout((oracle.bpm.ui.layout.Layout)new FlowLayout(0, 0, 0));
        distTypePanel.add((UiComponent)Label.create((UiContainer)distTypePanel, (Msg)DesignerMsg.DISTRIBUTION_TYPE));
        this.distribCombo = UiFactory.createComboBox((UiContainer)distTypePanel);
        DistributionType[] distributionTypes = DistributionType.values();
        Distribution savedDistribution = this.getModelSimulation().getDistributions()[0];
        Distribution[] distributions = this.getModelSimulation().getCalculatedDistributions();
        for (DistributionType distributionType : distributionTypes) {
            DistributionPanel panel;
            this.distribCombo.addItem((Object)distributionType);
            if (savedDistribution.getType().equals((Object)distributionType)) {
                panel = DistributionPanel.create((UiContainer)this.distribContainerPanel, savedDistribution);
                if (this.getDistributionForType(distributions, distributionType) == null) {
                    this.getModelSimulation().addCalculatedDistribution(savedDistribution);
                }
            } else {
                Distribution otherDistribution = this.getDistributionForType(distributions, distributionType);
                if (otherDistribution == null) {
                    otherDistribution = AbstractDistribution.create((DistributionType)distributionType);
                    this.getModelSimulation().addCalculatedDistribution(otherDistribution);
                }
                panel = DistributionPanel.create((UiContainer)this.distribContainerPanel, otherDistribution);
            }
            this.distribContainerPanel.add((UiComponent)panel, (Object)distributionType.getString());
        }
        this.distribCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                DistributionType selectedDistribution = (DistributionType)ModelSimulationEditor.this.distribCombo.getSelectedItem();
                if (selectedDistribution != null) {
                    ModelSimulationEditor.this.distribPanel = (DistributionPanel)ModelSimulationEditor.this.distribCardLayout.getComponent(selectedDistribution.getString());
                    ModelSimulationEditor.this.distribCardLayout.show((UiContainer)ModelSimulationEditor.this.distribContainerPanel, selectedDistribution.getString());
                    ModelSimulationEditor.this.distribContainerPanel.revalidate();
                }
            }
        });
        distTypePanel.add(this.distribCombo);
        distributionPanel.add((UiComponent)distTypePanel, (Object)"North");
        distributionPanel.add((UiComponent)this.distribContainerPanel, (Object)"Center");
        this.distribCombo.setSelectedItem((Object)savedDistribution.getType());
        this.distribCardLayout.show((UiContainer)this.distribContainerPanel, savedDistribution.getType().getString());
        this.distribPanel = (DistributionPanel)this.distribCardLayout.getComponent(savedDistribution.getType().getString());
        return distributionPanel;
    }

    private Distribution getDistributionForType(Distribution[] distributions, DistributionType distributionType) {
        for (Distribution distribution : distributions) {
            if (!distribution.getType().equals((Object)distributionType)) continue;
            return distribution;
        }
        return null;
    }

    private Panel buildInstanceGenerationPanel(UiContainer parent) {
        RelativeLayout layout = new RelativeLayout();
        Panel instanceGenerationPanel = new Panel(parent);
        instanceGenerationPanel.setLayout((oracle.bpm.ui.layout.Layout)layout);
        Panel maximumPanel = this.buildMaximumPanel((UiContainer)instanceGenerationPanel);
        Panel distributionPanel = this.buildDistributionPanel((UiContainer)instanceGenerationPanel);
        instanceGenerationPanel.add((UiComponent)maximumPanel, (Object)"maximum");
        layout.addConstraint("maximum", AttributeType.TOP, (Constraint)new AttributeConstraint("_container", AttributeType.TOP, 5));
        layout.addConstraint("maximum", AttributeType.LEFT, (Constraint)new AttributeConstraint("_container", AttributeType.LEFT));
        layout.addConstraint("maximum", AttributeType.RIGHT, (Constraint)new AttributeConstraint("_container", AttributeType.RIGHT));
        return instanceGenerationPanel;
    }

    private Panel buildMaximumPanel(UiContainer parent) {
        RelativeLayout layout = new RelativeLayout();
        Panel instanceGenerationPanel = new Panel(parent, DesignerMsg.INSTANCE_GENERATION_INFO);
        instanceGenerationPanel.setLayout((oracle.bpm.ui.layout.Layout)layout);
        this.useMaxInstances = CheckBox.create((UiContainer)instanceGenerationPanel, (Msg)DesignerMsg.ENABLE_MAX_INTANCES_LIMIT);
        this.useMaxInstances.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                ModelSimulationEditor.this.updateMaxField();
            }
        });
        this.maxInstancesSpinner = NumericField.createIntegerNumericField((UiContainer)instanceGenerationPanel);
        this.maxInstancesSpinner.setValue((Number)100);
        this.maxInstancesSpinner.setRange((Number)1, (Number)1000000000);
        this.maxInstancesSpinner.setStepSize((Number)1);
        instanceGenerationPanel.add(this.maxInstancesSpinner, (Object)"maxInstancesSpinner");
        instanceGenerationPanel.add((UiComponent)this.useMaxInstances, (Object)"useMaxInstances");
        Layout.fixToComp((RelativeLayout)layout, (String)"useMaxInstances", (AttributeType)AttributeType.VERTICAL_CENTER, (String)"maxInstancesSpinner");
        Layout.fixToRoot((RelativeLayout)layout, (String)"useMaxInstances", (AttributeType)AttributeType.LEFT, (int)5);
        Layout.fixToRoot((RelativeLayout)layout, (String)"maxInstancesSpinner", (AttributeType)AttributeType.TOP, (int)2);
        Layout.fixToComp((RelativeLayout)layout, (String)"maxInstancesSpinner", (AttributeType)AttributeType.LEFT, (String)"useMaxInstances", (AttributeType)AttributeType.RIGHT, (int)2);
        this.maxInstancesSpinner.setEnabled(false);
        instanceGenerationPanel.revalidate();
        return instanceGenerationPanel;
    }

    private void updateMaxField() {
        this.maxInstancesSpinner.setEnabled(this.useMaxInstances.isSelected());
    }

    private void addModelListeners() {
        if (this.modelSimulationReplaceListener == null) {
            this.modelSimulationReplaceListener = this.createModelSimulationReplaceListener();
            this.getModelSimulation().getProject().addListener(this.modelSimulationReplaceListener);
        }
    }

    private ProjectListener<ModelSimulation> createModelSimulationReplaceListener() {
        return new UiProjectAdapter((ProjectListener)new ProjectListenerAdapter<ModelSimulation>(ModelSimulation.class){

            public void objectReplaced(ModelSimulation oldObject, ModelSimulation newObject) {
                if (ModelSimulationEditor.this.getModelSimulation().getId().equals(oldObject.getId())) {
                    ModelSimulationEditor.this.setProjectObject(newObject);
                }
            }
        });
    }

    private void removeModelListeners() {
        Project project = this.getProject();
        project.removeListener(this.modelSimulationReplaceListener);
        this.modelSimulationReplaceListener = null;
    }
}

