/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.simulation;

import fuego.simulation.AbstractDistribution;
import fuego.simulation.ExponentialDistribution;
import oracle.bpm.designer.simulation.DistributionPanel;
import oracle.bpm.lang.IntervalUnit;
import oracle.bpm.project.model.simulation.Distribution;
import oracle.bpm.project.msg.ProjectMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.layout.AttributeConstraint;
import oracle.bpm.ui.layout.AttributeType;
import oracle.bpm.ui.layout.Constraint;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.RelativeLayout;
import oracle.bpm.ui.text.IntervalField;
import oracle.bpm.ui.text.NumericField;

class ExponentialDistributionPanel
extends DistributionPanel {
    private NumericField<Integer> instances;
    private IntervalField interval;

    public ExponentialDistributionPanel(UiContainer parent, Distribution distrib) {
        super(parent, distrib);
        RelativeLayout layout = new RelativeLayout();
        this.setLayout((Layout)layout);
        ExponentialDistribution distribution = (ExponentialDistribution)distrib;
        this.interval = IntervalField.createPositiveIntervalField((UiContainer)this, (IntervalUnit)IntervalUnit.DAYS, (IntervalUnit)IntervalUnit.SECONDS);
        this.interval.setInterval(distribution.getInterval());
        this.instances = NumericField.createIntegerNumericField((UiContainer)this);
        this.instances.setRange((Number)1, (Number)10000000);
        this.instances.setStepSize((Number)1);
        this.instances.setValue((Number)distribution.getEvents());
        Label frequencyLabel = Label.create((UiContainer)this, (Msg)ProjectMsg.EXPONENTIAL_AVERAGE_FREQUENCY);
        Label instancesLabel = Label.create((UiContainer)this, (Msg)ProjectMsg.EXPONENTIAL_INSTANCES);
        Label intervalLabel = Label.create((UiContainer)this, (Msg)ProjectMsg.EXPONENTIAL_INTERVAL);
        this.add((UiComponent)frequencyLabel, "frequencyLabel");
        this.add((UiComponent)this.instances, "instances");
        this.add((UiComponent)instancesLabel, "instancesLabel");
        this.add((UiComponent)intervalLabel, "intervalLabel");
        this.add((UiComponent)this.interval, "interval");
        layout.addConstraint("frequencyLabel", AttributeType.VERTICAL_CENTER, (Constraint)new AttributeConstraint("instances", AttributeType.VERTICAL_CENTER));
        layout.addConstraint("frequencyLabel", AttributeType.LEFT, (Constraint)new AttributeConstraint("_container", AttributeType.LEFT));
        layout.addConstraint("instances", AttributeType.TOP, (Constraint)new AttributeConstraint("_container", AttributeType.TOP));
        layout.addConstraint("instances", AttributeType.LEFT, (Constraint)new AttributeConstraint("frequencyLabel", AttributeType.RIGHT, 5));
        layout.addConstraint("instancesLabel", AttributeType.VERTICAL_CENTER, (Constraint)new AttributeConstraint("instances", AttributeType.VERTICAL_CENTER));
        layout.addConstraint("instancesLabel", AttributeType.LEFT, (Constraint)new AttributeConstraint("instances", AttributeType.RIGHT, 5));
        layout.addConstraint("intervalLabel", AttributeType.VERTICAL_CENTER, (Constraint)new AttributeConstraint("interval", AttributeType.VERTICAL_CENTER));
        layout.addConstraint("intervalLabel", AttributeType.LEFT, (Constraint)new AttributeConstraint("_container", AttributeType.LEFT));
        layout.addConstraint("interval", AttributeType.TOP, (Constraint)new AttributeConstraint("instances", AttributeType.BOTTOM, 2));
        layout.addConstraint("interval", AttributeType.LEFT, (Constraint)new AttributeConstraint("intervalLabel", AttributeType.RIGHT, 5));
    }

    @Override
    public AbstractDistribution getDistribution(int meanType) {
        if (meanType == 0) {
            return this.getDistribution();
        }
        return null;
    }

    @Override
    public AbstractDistribution getDistribution() {
        ExponentialDistribution distribution = (ExponentialDistribution)super.getDistribution();
        distribution.setEvents(((Integer)this.instances.getValue()).intValue());
        distribution.setInterval(this.interval.getInterval());
        return distribution;
    }
}

