/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.simulation;

import fuego.simulation.AbstractDistribution;
import fuego.simulation.SimulationFlowNodeImpl;
import fuego.simulation.SplitNSimulationActivityImpl;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.bpm.designer.DesignerException;
import oracle.bpm.designer.GenericPropertiesPanel;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.simulation.ActivityTabPanel;
import oracle.bpm.designer.simulation.ActivityTabType;
import oracle.bpm.designer.simulation.CostTabPanel;
import oracle.bpm.designer.simulation.DistributionPanel;
import oracle.bpm.designer.simulation.ModelSimulationEditor;
import oracle.bpm.designer.simulation.QueueInfoTabPanel;
import oracle.bpm.designer.simulation.RefreshListInterface;
import oracle.bpm.designer.simulation.ResourcesTabPanel;
import oracle.bpm.designer.simulation.ThreadsTabPanel;
import oracle.bpm.geom.Insets;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.Activity;
import oracle.bpm.project.model.processes.BoundaryEvent;
import oracle.bpm.project.model.processes.BpmnType;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.project.model.simulation.Distribution;
import oracle.bpm.project.model.simulation.DistributionType;
import oracle.bpm.project.model.simulation.ModelSimulation;
import oracle.bpm.project.model.simulation.SimulationFlowNode;
import oracle.bpm.project.model.simulation.SimulationSequenceFlow;
import oracle.bpm.project.model.util.ModelUtils;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.AbstractButton;
import oracle.bpm.ui.ButtonGroup;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.LabelMultiline;
import oracle.bpm.ui.OkCancelDialog;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.RadioButton;
import oracle.bpm.ui.SliderGroup;
import oracle.bpm.ui.TabbedPane;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiFactory;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;
import oracle.bpm.ui.event.SizeEvent;
import oracle.bpm.ui.event.SizeListener;
import oracle.bpm.ui.layout.AttributeType;
import oracle.bpm.ui.layout.CardLayout;
import oracle.bpm.ui.layout.GridBagConstraints;
import oracle.bpm.ui.layout.RelativeLayout;
import oracle.bpm.ui.utils.Layout;

class ActivitySimulationPropertiesPanel
extends GenericPropertiesPanel {
    private ModelSimulationEditor editor;
    private FlowNode nodeInfo;
    private RefreshListInterface refreshList;
    private ModelSimulation simulationModel = null;
    private TabbedPane tabbedPane;
    private Map<ActivityTabType, ActivityTabPanel> typeActivityTabMap;

    public ActivitySimulationPropertiesPanel(UiContainer parent, OkCancelDialog dialog, FlowNode actInfo, SimulationFlowNode activity, RefreshListInterface refreshList, ModelSimulation simulationModel) {
        this(parent, dialog, actInfo, activity, refreshList, simulationModel, null);
    }

    public ActivitySimulationPropertiesPanel(UiContainer parent, OkCancelDialog dialog, FlowNode actInfo, SimulationFlowNode activity, RefreshListInterface refreshList, ModelSimulation simulationModel, ModelSimulationEditor editor) {
        super(parent, dialog, DesignerMsg.SIMULATION, new FlowNodeInfo(actInfo, activity));
        this.nodeInfo = actInfo;
        this.refreshList = refreshList;
        this.simulationModel = simulationModel;
        this.editor = editor;
        this.build();
    }

    @Override
    public void check() throws ProjectException {
        if (this.nodeInfo.getBpmnType() == BpmnType.PARALLEL_GATEWAY) {
            return;
        }
        if (this.getActivity().showTransitions()) {
            OutgoingFlowsTabPanel tabPanel = (OutgoingFlowsTabPanel)this.ensureTabPanel(ActivityTabType.TRANSITIONS);
            tabPanel.check();
        }
    }

    public SimulationFlowNodeImpl getActivity() {
        return (SimulationFlowNodeImpl)((FlowNodeInfo)this.getObject()).getSimulationActivity();
    }

    @Override
    public void objectToPanel() {
        SimulationFlowNodeImpl activity = this.getActivity();
        if (activity == null) {
            return;
        }
        for (ActivityTabType activityTabType : ActivityTabType.values()) {
            if (!activityTabType.correspondsToActivity(activity)) continue;
            ActivityTabPanel tabPanel = this.ensureTabPanel(activityTabType);
            if (activityTabType.isDistributionHolder()) {
                ((DistributionHolder)((Object)tabPanel)).setDistributionType(activity.getDistribution().getType());
            }
            tabPanel.objectToTab(activity);
        }
    }

    @Override
    public boolean panelToObject() {
        SimulationFlowNodeImpl activity = this.getActivity();
        for (ActivityTabType activityTabType : ActivityTabType.values()) {
            if (!activityTabType.correspondsToActivity(activity)) continue;
            ActivityTabPanel tabPanel = this.ensureTabPanel(activityTabType);
            if (activityTabType.isDistributionHolder()) {
                DistributionHolder holder = (DistributionHolder)((Object)tabPanel);
                int meanType = activityTabType.equals((Object)ActivityTabType.DURATION) || activityTabType.equals((Object)ActivityTabType.INSTANCE_CREATION) ? 0 : 1;
                activity.setDistribution(holder.getDistribution(meanType));
            }
            tabPanel.tabToObject(activity);
        }
        return true;
    }

    public void updateTransitions() {
        OutgoingFlowsTabPanel tabPanel = (OutgoingFlowsTabPanel)this.ensureTabPanel(ActivityTabType.TRANSITIONS);
        tabPanel.buildTransitionSliderGroup(this.simulationModel, this.getActivity(), this.nodeInfo);
        this.validate();
        this.repaint();
    }

    @Override
    protected void build() {
        super.build();
        this.buildFields();
        this.buildTabbedPane();
    }

    protected GridBagConstraints getFldConstraints(int gridx, int gridy) {
        GridBagConstraints constr = new GridBagConstraints();
        constr.gridx = gridx;
        constr.gridy = gridy;
        constr.fill = 1;
        constr.anchor = 17;
        constr.insets = new Insets(8, 10, 8, 10);
        return constr;
    }

    private ActivityTabPanel ensureTabPanel(ActivityTabType tabType) {
        ActivityTabPanel activityTabPanel = this.typeActivityTabMap.get((Object)tabType);
        if (activityTabPanel != null && !activityTabPanel.isDisposed()) {
            return activityTabPanel;
        }
        activityTabPanel = this.getTabForType(tabType, (UiContainer)this.tabbedPane);
        this.typeActivityTabMap.put(tabType, activityTabPanel);
        return activityTabPanel;
    }

    private void updateActivityOtherDistributions(int meanType, DistributionHolder distributionHolder) {
        SimulationFlowNodeImpl activity = this.getActivity();
        for (AbstractDistribution panelDistribution : distributionHolder.getAllDistributions(meanType)) {
            Distribution activityDistribution = activity.getCalculatedDistributionForType(panelDistribution.getType());
            if (activityDistribution != null) {
                activity.removeCalculatedDistribution(activityDistribution);
            }
            activity.addCalculatedDistribution((Distribution)panelDistribution);
        }
    }

    private void buildTabbedPane() {
        Panel container = this.getContainerPanel();
        this.tabbedPane = new TabbedPane((UiContainer)container);
        this.buildPanels();
        container.add((UiComponent)this.tabbedPane, (Object)"Center");
        this.revalidate();
    }

    private Distribution getDistributionForType(Distribution[] distributions, DistributionType distributionType) {
        for (Distribution distribution : distributions) {
            if (!distribution.getType().equals((Object)distributionType)) continue;
            return distribution;
        }
        return null;
    }

    private void buildFields() {
        this.initListeners();
        this.typeActivityTabMap = new HashMap<ActivityTabType, ActivityTabPanel>(ActivityTabType.values().length);
    }

    private void updateEditorUpdatingState(boolean state) {
        if (this.editor != null) {
            this.editor.setUpdating(state);
        }
    }

    private void buildPanels() {
        SimulationFlowNodeImpl activity = this.getActivity();
        for (ActivityTabType activityTabType : ActivityTabType.values()) {
            if (!activityTabType.correspondsToActivity(activity)) continue;
            ActivityTabPanel tabPanel = this.ensureTabPanel(activityTabType);
            this.tabbedPane.addTab(tabPanel.getTabMessage(), (UiComponent)tabPanel);
        }
    }

    private void initListeners() {
    }

    private void selectTab(String name) {
        for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
            if (!name.equals(this.tabbedPane.getTitleAt(i))) continue;
            this.tabbedPane.setSelectedIndex(i);
            break;
        }
    }

    private boolean hasDue() {
        return this.nodeInfo.isActivity() && ModelUtils.hasTimerBoundaryEvent((Activity)((Activity)this.nodeInfo.asAnyNode(Activity.class)));
    }

    private boolean hasExclusiveTransitionProbability() {
        return this.nodeInfo.getBpmnType() != BpmnType.INCLUSIVE_GATEWAY && this.nodeInfo.getBpmnType() != BpmnType.PARALLEL_GATEWAY;
    }

    private void updateActivityList() {
        if (this.refreshList != null) {
            // empty if block
        }
    }

    private void updateGroupPanels() {
    }

    private ActivityTabPanel getTabForType(ActivityTabType activityTabType, UiContainer parent) {
        if (activityTabType.equals((Object)ActivityTabType.DURATION)) {
            return new DurationTabPanel(parent);
        }
        if (activityTabType.equals((Object)ActivityTabType.INSTANCE_CREATION)) {
            return new InstanceCreationTabPanel(parent);
        }
        if (activityTabType.equals((Object)ActivityTabType.COPIES)) {
            return new CopiesTabPanel(parent);
        }
        if (activityTabType.equals((Object)ActivityTabType.RESOURCES)) {
            return new ResourcesTabPanel(parent);
        }
        if (activityTabType.equals((Object)ActivityTabType.THREADS)) {
            return new ThreadsTabPanel(parent);
        }
        if (activityTabType.equals((Object)ActivityTabType.COST)) {
            return new CostTabPanel(parent);
        }
        if (activityTabType.equals((Object)ActivityTabType.QUEUE_INFO)) {
            return new QueueInfoTabPanel(parent);
        }
        if (activityTabType.equals((Object)ActivityTabType.TRANSITIONS)) {
            return new OutgoingFlowsTabPanel(parent);
        }
        return null;
    }

    private static class FlowNodeInfo {
        private FlowNode node;
        private SimulationFlowNode simulationActivity;

        private FlowNodeInfo(FlowNode node, SimulationFlowNode simulationActivity) {
            this.node = node;
            this.simulationActivity = simulationActivity;
        }

        public FlowNode getActivity() {
            return this.node;
        }

        public SimulationFlowNode getSimulationActivity() {
            return this.simulationActivity;
        }
    }

    public class OutgoingFlowsTabPanel
    extends ActivityTabPanel {
        private SliderGroup interruptingAndNormalOutFlowsSliderGroup;
        private SliderGroup nonInterruptingOutFlowsSliderGroup;
        private Map<SliderGroup.SliderInfo, SequenceFlow> nonIntSequenceInfoMap;
        private Map<SliderGroup.SliderInfo, SequenceFlow> sequenceInfoMap;

        public OutgoingFlowsTabPanel(UiContainer parent) {
            super(parent, ActivityTabType.TRANSITIONS);
        }

        @Override
        protected void buildTab() {
            RelativeLayout layout = new RelativeLayout();
            this.setLayout((oracle.bpm.ui.layout.Layout)layout);
            LabelMultiline descTextArea = new LabelMultiline((UiContainer)this, DesignerMsg.TRANSITION_PROB);
            LabelMultiline descNonIntTextArea = new LabelMultiline((UiContainer)this, DesignerMsg.NON_INT_TRANSITION_PROB);
            this.interruptingAndNormalOutFlowsSliderGroup = new SliderGroup((UiContainer)this, 0, 100, 0, true);
            this.nonInterruptingOutFlowsSliderGroup = new SliderGroup((UiContainer)this, 0, 100, 0, true);
            boolean hasNonInterruptingBoundaries = ModelUtils.hasNonInterruptingBoundaryEvents((FlowNode)ActivitySimulationPropertiesPanel.this.getActivity().getFlowNode());
            this.add((UiComponent)descTextArea, "textArea");
            this.add((UiComponent)this.interruptingAndNormalOutFlowsSliderGroup, "table");
            if (hasNonInterruptingBoundaries) {
                this.add((UiComponent)descNonIntTextArea, "nonIntTextArea");
                this.add((UiComponent)this.nonInterruptingOutFlowsSliderGroup, "nonIntTable");
            }
            Layout.fixToRoot((RelativeLayout)layout, (String)"textArea", (AttributeType)AttributeType.TOP, (int)2);
            Layout.fixToRoot((RelativeLayout)layout, (String)"textArea", (AttributeType)AttributeType.LEFT);
            Layout.fixToRoot((RelativeLayout)layout, (String)"textArea", (AttributeType)AttributeType.RIGHT);
            Layout.fixToComp((RelativeLayout)layout, (String)"table", (AttributeType)AttributeType.TOP, (String)"textArea", (AttributeType)AttributeType.BOTTOM, (int)2);
            Layout.fixToRoot((RelativeLayout)layout, (String)"table", (AttributeType)AttributeType.LEFT);
            Layout.fixToRoot((RelativeLayout)layout, (String)"table", (AttributeType)AttributeType.RIGHT);
            if (hasNonInterruptingBoundaries) {
                Layout.fixToComp((RelativeLayout)layout, (String)"nonIntTextArea", (AttributeType)AttributeType.TOP, (String)"table", (AttributeType)AttributeType.BOTTOM, (int)10);
                Layout.fixToRoot((RelativeLayout)layout, (String)"nonIntTextArea", (AttributeType)AttributeType.LEFT);
                Layout.fixToRoot((RelativeLayout)layout, (String)"nonIntTextArea", (AttributeType)AttributeType.RIGHT);
                Layout.fixToComp((RelativeLayout)layout, (String)"nonIntTable", (AttributeType)AttributeType.TOP, (String)"nonIntTextArea", (AttributeType)AttributeType.BOTTOM, (int)2);
                Layout.fixToRoot((RelativeLayout)layout, (String)"nonIntTable", (AttributeType)AttributeType.LEFT);
                Layout.fixToRoot((RelativeLayout)layout, (String)"nonIntTable", (AttributeType)AttributeType.BOTTOM);
                Layout.fixToRoot((RelativeLayout)layout, (String)"nonIntTable", (AttributeType)AttributeType.RIGHT);
            }
        }

        @Override
        protected void tabToObject(SimulationFlowNodeImpl activity) {
            this.sliderToActivity(activity, ActivitySimulationPropertiesPanel.this.simulationModel);
        }

        @Override
        protected void objectToTab(SimulationFlowNodeImpl activity) {
            this.buildTransitionSliderGroup(ActivitySimulationPropertiesPanel.this.simulationModel, activity, ActivitySimulationPropertiesPanel.this.nodeInfo);
            this.revalidate();
        }

        protected void check() throws DesignerException {
        }

        private void sliderToActivity(SimulationFlowNodeImpl activity, ModelSimulation simulationModel) {
            this.sliderToActivityFrom(simulationModel, this.sequenceInfoMap, this.interruptingAndNormalOutFlowsSliderGroup);
            this.sliderToActivityFrom(simulationModel, this.nonIntSequenceInfoMap, this.nonInterruptingOutFlowsSliderGroup);
        }

        private void sliderToActivityFrom(ModelSimulation simulationModel, Map<SliderGroup.SliderInfo, SequenceFlow> sequenceInfoMap, SliderGroup flowsSliderGroup) {
            for (SliderGroup.SliderInfo sliderInfo : sequenceInfoMap.keySet()) {
                SequenceFlow sequenceFlow = sequenceInfoMap.get(sliderInfo);
                SimulationSequenceFlow t = simulationModel.asSimulationSequenceFlow(sequenceFlow);
                t.setId(sequenceFlow.getId());
                int probability = flowsSliderGroup.getValue(sliderInfo);
                t.setProbability((double)probability / 100.0);
            }
        }

        private void buildTransitionSliderGroup(ModelSimulation simulationModel, SimulationFlowNodeImpl activity, FlowNode flowNode) {
            this.nonIntSequenceInfoMap = new HashMap<SliderGroup.SliderInfo, SequenceFlow>();
            this.sequenceInfoMap = new HashMap<SliderGroup.SliderInfo, SequenceFlow>();
            List simulationValidOutputSeqFlows = SimulationFlowNodeImpl.findValidForSimulationOutputTransitions((FlowNode)flowNode);
            List interruptingBoundariesSeqFlows = null;
            if (flowNode.isActivity()) {
                interruptingBoundariesSeqFlows = SimulationFlowNodeImpl.findValidInterruptingBoundaryEventsSeqFlows((Activity)((Activity)flowNode.asAnyNode(Activity.class)));
            }
            if (interruptingBoundariesSeqFlows != null) {
                simulationValidOutputSeqFlows.addAll(interruptingBoundariesSeqFlows);
            }
            HashMap<SliderGroup.SliderInfo, Integer> msgs = new HashMap<SliderGroup.SliderInfo, Integer>();
            this.fillSliderInfo(simulationModel, simulationValidOutputSeqFlows, msgs, this.sequenceInfoMap, ActivitySimulationPropertiesPanel.this.hasExclusiveTransitionProbability());
            this.interruptingAndNormalOutFlowsSliderGroup.initSliders(msgs);
            this.interruptingAndNormalOutFlowsSliderGroup.revalidate();
            this.interruptingAndNormalOutFlowsSliderGroup.repaint();
            if (flowNode.isActivity() && ModelUtils.hasNonInterruptingBoundaryEvents((FlowNode)flowNode)) {
                List nonIntBoundariesSeqFlows = SimulationFlowNodeImpl.findValidNonInterruptingBoundaryEventsSeqFlows((Activity)((Activity)flowNode.asAnyNode(Activity.class)));
                HashMap<SliderGroup.SliderInfo, Integer> nonIntMsgs = new HashMap<SliderGroup.SliderInfo, Integer>();
                this.fillSliderInfo(simulationModel, nonIntBoundariesSeqFlows, nonIntMsgs, this.nonIntSequenceInfoMap, false);
                this.nonInterruptingOutFlowsSliderGroup.setEnableAllSliders(true);
                this.nonInterruptingOutFlowsSliderGroup.initSliders(nonIntMsgs);
                this.nonInterruptingOutFlowsSliderGroup.revalidate();
                this.nonInterruptingOutFlowsSliderGroup.repaint();
            }
        }

        private void fillSliderInfo(ModelSimulation simulationModel, List<SequenceFlow> simulationValidOutputSeqFlows, Map<SliderGroup.SliderInfo, Integer> msgs, Map<SliderGroup.SliderInfo, SequenceFlow> sequenceInfoMap, boolean hasExclusiveProb) {
            if (!simulationValidOutputSeqFlows.isEmpty()) {
                for (SequenceFlow transition : simulationValidOutputSeqFlows) {
                    SimulationSequenceFlow sequenceFlowModel = simulationModel.findSimulationSequenceFlow(transition.getId());
                    Integer value = null;
                    if (sequenceFlowModel != null) {
                        value = (int)(sequenceFlowModel.getProbability() * 100.0);
                    }
                    SliderGroup.SliderInfo info = this.getSliderInfo(transition, hasExclusiveProb);
                    msgs.put(info, value);
                    sequenceInfoMap.put(info, transition);
                }
            }
        }

        private Image getIcon(SequenceFlow sequenceFlow) {
            Msg msg = sequenceFlow.isConditionalFlow() ? DesignerMsg.TREE_TRANSITION_CONDITIONAL : DesignerMsg.TREE_TRANSITION;
            return Image.create((URL)msg.getImageResource());
        }

        private SliderGroup.SliderInfo getSliderInfo(SequenceFlow sequenceFlow, boolean hasBooleanProb) {
            String text = sequenceFlow.getTarget().getDefaultLabel();
            FlowNode source = sequenceFlow.getSource();
            if (ModelUtils.isBoundaryEvent((FlowNode)source)) {
                text = text + " (from " + ((BoundaryEvent)source.asAnyNode(BoundaryEvent.class)).getEventTriggerType().getString() + " event '" + source.getDefaultLabel() + "')";
            }
            return new SliderGroup.SliderInfo(text, this.getIcon(sequenceFlow), hasBooleanProb);
        }
    }

    public class InstanceCreationTabPanel
    extends ActivityTabPanel
    implements DistributionHolder {
        private DistributionHolderImpl holder;

        public InstanceCreationTabPanel(UiContainer parent) {
            super(parent, ActivityTabType.INSTANCE_CREATION, DesignerMsg.INSTANCE_CREATION);
        }

        @Override
        public void setDistributionType(DistributionType type) {
            this.holder.setDistributionType(type);
        }

        @Override
        public Distribution getDistribution(int meanType) {
            return this.holder.getDistribution(meanType);
        }

        @Override
        public List<AbstractDistribution> getAllDistributions(int meanType) {
            return this.holder.getAllDistributions(meanType);
        }

        @Override
        protected void buildTab() {
            RelativeLayout layout = new RelativeLayout();
            this.setLayout((oracle.bpm.ui.layout.Layout)layout);
            this.holder = new DistributionHolderImpl((UiContainer)this);
            this.add((UiComponent)new LabelMultiline((UiContainer)this, DesignerMsg.ACTIVITY_INSTANCE_CREATION), "description");
            this.add((UiComponent)Label.create((UiContainer)this, (Msg)DesignerMsg.DISTRIBUTION_TYPE), "label");
            this.add(this.holder.getComboBox(), "combo");
            this.add(this.holder.getDistributionsPanel(), "panel");
            Layout.fixToRoot((RelativeLayout)layout, (String)"description", (AttributeType)AttributeType.TOP, (int)2);
            Layout.fixToRoot((RelativeLayout)layout, (String)"description", (AttributeType)AttributeType.LEFT, (int)2);
            Layout.fixToRoot((RelativeLayout)layout, (String)"description", (AttributeType)AttributeType.RIGHT, (int)2);
            Layout.fixToComp((RelativeLayout)layout, (String)"label", (AttributeType)AttributeType.VERTICAL_CENTER, (String)"combo");
            Layout.fixToRoot((RelativeLayout)layout, (String)"label", (AttributeType)AttributeType.LEFT, (int)2);
            Layout.fixToComp((RelativeLayout)layout, (String)"combo", (AttributeType)AttributeType.TOP, (String)"description", (AttributeType)AttributeType.BOTTOM, (int)2);
            Layout.fixToComp((RelativeLayout)layout, (String)"combo", (AttributeType)AttributeType.LEFT, (String)"label", (AttributeType)AttributeType.RIGHT, (int)2);
            Layout.fixToRoot((RelativeLayout)layout, (String)"combo", (AttributeType)AttributeType.RIGHT, (int)-2);
            Layout.fixToComp((RelativeLayout)layout, (String)"panel", (AttributeType)AttributeType.TOP, (String)"combo", (AttributeType)AttributeType.BOTTOM, (int)2);
            Layout.fixToRoot((RelativeLayout)layout, (String)"panel", (AttributeType)AttributeType.LEFT);
            Layout.fixToRoot((RelativeLayout)layout, (String)"panel", (AttributeType)AttributeType.BOTTOM);
            Layout.fixToRoot((RelativeLayout)layout, (String)"panel", (AttributeType)AttributeType.RIGHT);
        }

        @Override
        protected void tabToObject(SimulationFlowNodeImpl activity) {
        }

        @Override
        protected void objectToTab(SimulationFlowNodeImpl activity) {
        }
    }

    public class DurationTabPanel
    extends ActivityTabPanel
    implements DistributionHolder {
        private DistributionHolderImpl holder;

        public DurationTabPanel(UiContainer parent) {
            super(parent, ActivityTabType.DURATION, DesignerMsg.ACTIVITY_DURATION);
        }

        @Override
        public void setDistributionType(DistributionType type) {
            this.holder.setDistributionType(type);
        }

        @Override
        public Distribution getDistribution(int meanType) {
            return this.holder.getDistribution(meanType);
        }

        @Override
        public List<AbstractDistribution> getAllDistributions(int meanType) {
            return this.holder.getAllDistributions(meanType);
        }

        @Override
        protected void buildTab() {
            RelativeLayout layout = new RelativeLayout();
            this.setLayout((oracle.bpm.ui.layout.Layout)layout);
            this.holder = new DistributionHolderImpl((UiContainer)this);
            this.add((UiComponent)new LabelMultiline((UiContainer)this, DesignerMsg.ACTIVITY_DISTRIB), "description");
            this.add((UiComponent)Label.create((UiContainer)this, (Msg)DesignerMsg.DISTRIBUTION_TYPE), "label");
            this.add(this.holder.getComboBox(), "combo");
            this.add(this.holder.getDistributionsPanel(), "panel");
            Layout.fixToRoot((RelativeLayout)layout, (String)"description", (AttributeType)AttributeType.TOP, (int)2);
            Layout.fixToRoot((RelativeLayout)layout, (String)"description", (AttributeType)AttributeType.LEFT, (int)2);
            Layout.fixToRoot((RelativeLayout)layout, (String)"description", (AttributeType)AttributeType.RIGHT, (int)2);
            Layout.fixToComp((RelativeLayout)layout, (String)"label", (AttributeType)AttributeType.VERTICAL_CENTER, (String)"combo");
            Layout.fixToRoot((RelativeLayout)layout, (String)"label", (AttributeType)AttributeType.LEFT, (int)2);
            Layout.fixToComp((RelativeLayout)layout, (String)"combo", (AttributeType)AttributeType.TOP, (String)"description", (AttributeType)AttributeType.BOTTOM, (int)2);
            Layout.fixToComp((RelativeLayout)layout, (String)"combo", (AttributeType)AttributeType.LEFT, (String)"label", (AttributeType)AttributeType.RIGHT, (int)2);
            Layout.fixToRoot((RelativeLayout)layout, (String)"combo", (AttributeType)AttributeType.RIGHT, (int)-2);
            Layout.fixToComp((RelativeLayout)layout, (String)"panel", (AttributeType)AttributeType.TOP, (String)"combo", (AttributeType)AttributeType.BOTTOM, (int)2);
            Layout.fixToRoot((RelativeLayout)layout, (String)"panel", (AttributeType)AttributeType.LEFT);
            Layout.fixToRoot((RelativeLayout)layout, (String)"panel", (AttributeType)AttributeType.BOTTOM);
            Layout.fixToRoot((RelativeLayout)layout, (String)"panel", (AttributeType)AttributeType.RIGHT);
        }

        @Override
        protected void tabToObject(SimulationFlowNodeImpl activity) {
        }

        @Override
        protected void objectToTab(SimulationFlowNodeImpl activity) {
        }
    }

    public class DistributionHolderImpl
    implements DistributionHolder {
        private DistributionPanel distributionPanel;
        private CardLayout distributionsCardLayout;
        private ComboBox<DistributionType> distributionsCombo;
        private Panel distributionsContainerPanel;
        private ItemListener distributionsComboItemListener = new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                DistributionHolderImpl.this.updateDistributionPanel(true);
            }
        };
        private UiContainer parent;

        public DistributionHolderImpl(UiContainer parent) {
            this.parent = parent;
            this.buildPanel();
        }

        @Override
        public void setDistributionType(DistributionType type) {
            SimulationFlowNodeImpl activity = ActivitySimulationPropertiesPanel.this.getActivity();
            this.distributionsCombo.removeItemListener(this.distributionsComboItemListener);
            this.distributionsCombo.setSelectedItem((Object)activity.getDistribution().getType());
            this.distributionsCombo.addItemListener(this.distributionsComboItemListener);
        }

        @Override
        public Distribution getDistribution(int meanType) {
            this.updateDistributionPanel(false);
            return this.distributionPanel.getDistribution(meanType);
        }

        @Override
        public List<AbstractDistribution> getAllDistributions(int meanType) {
            ArrayList<AbstractDistribution> distributions = new ArrayList<AbstractDistribution>();
            for (int i = 0; i < this.distributionsCombo.getItemCount(); ++i) {
                DistributionType distributionType = (DistributionType)this.distributionsCombo.getItemAt(i);
                DistributionPanel otherPanel = (DistributionPanel)this.distributionsCardLayout.getComponent(distributionType.getString());
                if (otherPanel == null) continue;
                distributions.add(otherPanel.getDistribution(meanType));
            }
            return distributions;
        }

        public UiComponent getComboBox() {
            return this.distributionsCombo;
        }

        public UiComponent getDistributionsPanel() {
            return this.distributionsContainerPanel;
        }

        private void updateDistributionPanel(boolean refreshView) {
            DistributionType selectedDistribution = (DistributionType)this.distributionsCombo.getSelectedItem();
            if (selectedDistribution != null) {
                this.distributionPanel = (DistributionPanel)this.distributionsCardLayout.getComponent(selectedDistribution.getString());
                if (refreshView) {
                    this.distributionsCardLayout.show((UiContainer)this.distributionsContainerPanel, selectedDistribution.getString());
                    this.distributionsContainerPanel.revalidate();
                }
            }
        }

        private void buildPanel() {
            this.distributionsContainerPanel = new Panel(this.parent, DesignerMsg.DISTRIBUTION_INFO);
            this.distributionsCardLayout = new CardLayout();
            this.distributionsContainerPanel.setLayout((oracle.bpm.ui.layout.Layout)this.distributionsCardLayout);
            ArrayList<DistributionType> distrList = new ArrayList<DistributionType>();
            DistributionType[] types = DistributionType.values();
            Distribution savedDistribution = ActivitySimulationPropertiesPanel.this.getActivity().getDistribution();
            Distribution[] distributions = ActivitySimulationPropertiesPanel.this.getActivity().getCalculatedDistributions();
            for (DistributionType distributionType : types) {
                DistributionPanel panel;
                if (ActivitySimulationPropertiesPanel.this.getActivity().showCopiesInfo() && distributionType == DistributionType.EXPONENTIAL) continue;
                distrList.add(distributionType);
                if (savedDistribution.getType().equals((Object)distributionType)) {
                    panel = DistributionPanel.create((UiContainer)this.distributionsContainerPanel, savedDistribution, ActivitySimulationPropertiesPanel.this.getActivity().showCopiesInfo() ? 1 : 0);
                } else {
                    AbstractDistribution otherDistribution = AbstractDistribution.create((DistributionType)distributionType);
                    panel = DistributionPanel.create((UiContainer)this.distributionsContainerPanel, (Distribution)otherDistribution, ActivitySimulationPropertiesPanel.this.getActivity().showCopiesInfo() ? 1 : 0);
                }
                this.distributionsContainerPanel.add((UiComponent)panel, (Object)distributionType.getString());
            }
            this.distributionsCombo = UiFactory.createComboBox((UiContainer)this.parent, distrList);
            this.distributionsCombo.addItemListener(this.distributionsComboItemListener);
            this.distributionsCombo.setSelectedItem((Object)savedDistribution.getType());
            this.distributionsContainerPanel.addSizeListener(new SizeListener(){

                public void componentResized(SizeEvent event) {
                    DistributionHolderImpl.this.distributionsContainerPanel.revalidate();
                }
            });
            this.distributionsCardLayout.show((UiContainer)this.distributionsContainerPanel, savedDistribution.getType().getString());
            this.distributionPanel = (DistributionPanel)this.distributionsCardLayout.getComponent(savedDistribution.getType().getString());
        }
    }

    public class CopiesTabPanel
    extends ActivityTabPanel
    implements DistributionHolder {
        private DistributionHolderImpl holder;
        private RadioButton nBallsRadio;
        private RadioButton oneBallRadio;

        public CopiesTabPanel(UiContainer parent) {
            super(parent, ActivityTabType.COPIES, DesignerMsg.GENERATION_MODE);
        }

        @Override
        public void setDistributionType(DistributionType type) {
            this.holder.setDistributionType(type);
        }

        @Override
        public Distribution getDistribution(int meanType) {
            return this.holder.getDistribution(meanType);
        }

        @Override
        public List<AbstractDistribution> getAllDistributions(int meanType) {
            return this.holder.getAllDistributions(meanType);
        }

        @Override
        protected void buildTab() {
            RelativeLayout layout = new RelativeLayout();
            this.setLayout((oracle.bpm.ui.layout.Layout)layout);
            this.nBallsRadio = new RadioButton((UiContainer)this);
            this.oneBallRadio = new RadioButton((UiContainer)this);
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add((AbstractButton)this.nBallsRadio);
            buttonGroup.add((AbstractButton)this.oneBallRadio);
            Label nBallsLabel = Label.create((UiContainer)this, (Msg)DesignerMsg.TRAIN_MODE);
            this.add((UiComponent)nBallsLabel, "nBallsLabel");
            this.add((UiComponent)this.nBallsRadio, "nBalls");
            Label oneBallLabel = Label.create((UiContainer)this, (Msg)DesignerMsg.GROUP_MODE);
            this.add((UiComponent)oneBallLabel, "oneBallLabel");
            this.add((UiComponent)this.oneBallRadio, "oneBall");
            Layout.fixToComp((RelativeLayout)layout, (String)"nBallsLabel", (AttributeType)AttributeType.VERTICAL_CENTER, (String)"nBalls");
            Layout.fixToRoot((RelativeLayout)layout, (String)"nBallsLabel", (AttributeType)AttributeType.LEFT, (int)2);
            Layout.fixToRoot((RelativeLayout)layout, (String)"nBalls", (AttributeType)AttributeType.TOP, (int)2);
            Layout.fixToComp((RelativeLayout)layout, (String)"nBalls", (AttributeType)AttributeType.LEFT, (String)"nBallsLabel", (AttributeType)AttributeType.RIGHT, (int)8);
            Layout.fixToComp((RelativeLayout)layout, (String)"oneBallLabel", (AttributeType)AttributeType.TOP, (String)"nBallsLabel", (AttributeType)AttributeType.BOTTOM, (int)8);
            Layout.fixToRoot((RelativeLayout)layout, (String)"oneBallLabel", (AttributeType)AttributeType.LEFT, (int)2);
            Layout.fixToComp((RelativeLayout)layout, (String)"oneBall", (AttributeType)AttributeType.TOP, (String)"nBallsLabel", (AttributeType)AttributeType.BOTTOM, (int)8);
            Layout.fixToComp((RelativeLayout)layout, (String)"oneBall", (AttributeType)AttributeType.LEFT, (String)"nBallsLabel", (AttributeType)AttributeType.RIGHT, (int)8);
            Layout.fixToComp((RelativeLayout)layout, (String)"oneBall", (AttributeType)AttributeType.VERTICAL_CENTER, (String)"oneBallLabel");
            this.holder = new DistributionHolderImpl((UiContainer)this);
            this.add((UiComponent)Label.create((UiContainer)this, (Msg)DesignerMsg.DISTRIBUTION_TYPE), "label");
            this.add(this.holder.getComboBox(), "combo");
            this.add(this.holder.getDistributionsPanel(), "panel");
            Layout.fixToComp((RelativeLayout)layout, (String)"label", (AttributeType)AttributeType.VERTICAL_CENTER, (String)"combo");
            Layout.fixToRoot((RelativeLayout)layout, (String)"label", (AttributeType)AttributeType.LEFT, (int)2);
            Layout.fixToComp((RelativeLayout)layout, (String)"combo", (AttributeType)AttributeType.TOP, (String)"oneBall", (AttributeType)AttributeType.BOTTOM, (int)4);
            Layout.fixToComp((RelativeLayout)layout, (String)"combo", (AttributeType)AttributeType.LEFT, (String)"label", (AttributeType)AttributeType.RIGHT, (int)2);
            Layout.fixToRoot((RelativeLayout)layout, (String)"combo", (AttributeType)AttributeType.RIGHT, (int)-2);
            Layout.fixToComp((RelativeLayout)layout, (String)"panel", (AttributeType)AttributeType.TOP, (String)"combo", (AttributeType)AttributeType.BOTTOM, (int)0);
            Layout.fixToRoot((RelativeLayout)layout, (String)"panel", (AttributeType)AttributeType.LEFT);
            Layout.fixToRoot((RelativeLayout)layout, (String)"panel", (AttributeType)AttributeType.BOTTOM);
            Layout.fixToRoot((RelativeLayout)layout, (String)"panel", (AttributeType)AttributeType.RIGHT);
        }

        @Override
        protected void tabToObject(SimulationFlowNodeImpl activity) {
            ((SplitNSimulationActivityImpl)activity).setSimulateNballs(this.nBallsRadio.isSelected());
        }

        @Override
        protected void objectToTab(SimulationFlowNodeImpl activity) {
            boolean simulateNBalls = ((SplitNSimulationActivityImpl)activity).getSimulateNballs();
            this.nBallsRadio.setSelected(simulateNBalls);
            this.oneBallRadio.setSelected(!simulateNBalls);
        }
    }

    public static interface DistributionHolder {
        public void setDistributionType(DistributionType var1);

        public Distribution getDistribution(int var1);

        public List<AbstractDistribution> getAllDistributions(int var1);
    }
}

