/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.simulation;

import fuego.simulation.Simulation;
import fuego.simulation.SimulationFlowNodeImpl;
import java.io.Serializable;
import oracle.bpm.bamdata.ActivityInfo;
import oracle.bpm.bamdata.ProcessInfo;
import oracle.bpm.designer.ActivitySimulationInterface;
import oracle.bpm.designer.ProcessDomain;
import oracle.bpm.designer.controller.FlowNodeController;
import oracle.bpm.designer.simulation.SimulationRunTimeResourcePanel;
import oracle.bpm.designer.simulation.StudioSimulationUtils;
import oracle.bpm.draw.Color;
import oracle.bpm.draw.DrawContext;
import oracle.bpm.draw.Font;
import oracle.bpm.draw.Graphics;
import oracle.bpm.geom.Point;
import oracle.bpm.geom.Rectangle;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.Subprocess;
import oracle.bpm.project.model.simulation.ModelSimulation;
import oracle.bpm.project.model.simulation.SimulationFlowNode;
import oracle.bpm.project.model.util.ModelUtils;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.PaintCanvas;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.event.ActionListener;
import oracle.bpm.ui.msg.UIMsg;

public class ActivitySimulationDelegated
implements ActivitySimulationInterface,
Serializable {
    private Button anotherButton;
    private FlowNodeController controller;
    private Button lessCapacityButton;
    private int maxQueue = 0;
    private Button moreCapacityButton;
    private int numberInProcess;
    private Rectangle numberInProcessRectangle;
    private boolean opened;
    private int queueSize;
    private Button resourcePanelButton;
    private transient SimulationRunTimeResourcePanel simulationRunTimeResourcePanel;
    private int totalNumberProcessed;
    private static final long serialVersionUID = 7129733331833624258L;
    private static Image PLUS_IMAGE = Image.create((Msg)UIMsg.TREE_PLUS);

    public ActivitySimulationDelegated(FlowNodeController controller) {
        this.controller = controller;
    }

    @Override
    public FlowNode getActivity() {
        return this.getFlowNode();
    }

    @Override
    public SimulationFlowNodeImpl getSimulationInfo() {
        String activityId = this.controller.getModelObject().getId();
        SimulationFlowNode simulationActivity = this.getSimulationModel().findSimulationFlowNode(activityId);
        if (simulationActivity == null) {
            simulationActivity = this.getSimulationModel().createSimulationFlowNode(activityId);
            try {
                this.getSimulationModel().addSimulationFlowNode(simulationActivity);
            }
            catch (ProjectException e) {
                e.printStackTrace();
            }
        }
        return (SimulationFlowNodeImpl)simulationActivity;
    }

    @Override
    public void drawSimulation(Graphics g) {
        DrawContext context = this.getDomain().getDrawContext();
        int xpos = context.scale(this.getLocation().getX());
        int ypos = context.scale(this.getLocation().getY());
        int inProcessRectY = ypos - context.scale(this.controller.getDrawableObject().getHeight(context) + 2);
        this.drawSimulation(g, xpos, inProcessRectY);
    }

    @Override
    public void resetSimulation() {
        this.numberInProcess = 0;
        this.queueSize = 0;
        this.maxQueue = 0;
        this.totalNumberProcessed = 0;
        this.removeFromSimulation((UiComponent)this.moreCapacityButton);
        this.removeFromSimulation((UiComponent)this.lessCapacityButton);
        if (this.resourcePanelButton != null) {
            this.resourcePanelButton.setVisible(false);
            this.resourcePanelButton = null;
        }
        if (this.simulationRunTimeResourcePanel != null) {
            this.simulationRunTimeResourcePanel.setVisible(false);
            this.opened = false;
            this.simulationRunTimeResourcePanel = null;
        }
    }

    @Override
    public void updateSimulationValues() {
        if (this.getSimulation() != null) {
            this.numberInProcess = this.getRuntimeInfo().getRunningInfo().getCurrentWorkCount();
            this.queueSize = this.getRuntimeInfo().getRunningInfo().getQueueCount();
            this.totalNumberProcessed = this.getRuntimeInfo().getRunningInfo().getOperationsCompletedCount();
            if (this.simulationRunTimeResourcePanel != null && !this.simulationRunTimeResourcePanel.isDisposed() && this.simulationRunTimeResourcePanel.isVisible()) {
                this.simulationRunTimeResourcePanel.update();
            }
        }
    }

    protected Point getLocation() {
        return this.controller.getDrawableObject().getLocation();
    }

    protected void drawSimulation(Graphics g, int inProcessRectX, int inProcessRectY) {
        DrawContext context = this.getDomain().getDrawContext();
        int rectWidth = context.scale(18);
        int rectHeight = context.scale(25);
        int xpos = context.isHorizontalDrawing() ? context.scale(this.getLocation().getY()) : context.scale(this.getLocation().getX());
        int ypos = context.isHorizontalDrawing() ? context.scale(this.getLocation().getX()) : context.scale(this.getLocation().getY());
        int counterXLocation = xpos + this.controller.getDrawableObject().getWidth(context) / 2;
        int counterYLocation = ypos - this.controller.getDrawableObject().getHeight(context);
        if (!this.getDomain().isShowAnimation()) {
            if (this.moreCapacityButton != null) {
                this.moreCapacityButton.setVisible(false);
            }
            if (this.lessCapacityButton != null) {
                this.lessCapacityButton.setVisible(false);
            }
            if (this.resourcePanelButton != null) {
                this.resourcePanelButton.setVisible(false);
            }
            if (this.simulationRunTimeResourcePanel != null) {
                this.simulationRunTimeResourcePanel.setVisible(false);
                this.opened = false;
            }
            return;
        }
        if (this.getSimulationModel() == null) {
            return;
        }
        if (ModelUtils.isStartEvent((FlowNode)this.getFlowNode())) {
            if (this.getSimulationModel().getUseMaxInstances() && this.totalNumberProcessed > 0) {
                g.drawString(String.valueOf(this.getSimulationModel().getMaxInstances() - this.totalNumberProcessed + "/" + this.getSimulationModel().getMaxInstances()), counterXLocation, counterYLocation);
            }
            return;
        }
        if (ModelUtils.isEndEvent((FlowNode)this.getFlowNode()) && this.getSimulationModel().getUseMaxInstances()) {
            g.drawString(String.valueOf(this.totalNumberProcessed + this.numberInProcess) + "/" + this.getSimulationModel().getMaxInstances(), counterXLocation, counterYLocation);
            return;
        }
        if (!this.drawSimulationBar()) {
            return;
        }
        int iconHeight = PLUS_IMAGE.getIconHeight();
        Font f = g.getFont();
        g.setFont(f.scale(0.8f * context.getScale()));
        int capacity = this.getSimulationInfo().getCapacity();
        int ocupationPerc = this.numberInProcess > capacity ? 100 : this.numberInProcess * 100 / capacity;
        this.numberInProcessRectangle = new Rectangle(inProcessRectX, inProcessRectY, rectWidth, rectHeight);
        g.draw(this.numberInProcessRectangle);
        int fillHeight = ocupationPerc * rectHeight / 100;
        Rectangle numberInProcessFillRectangle = new Rectangle(inProcessRectX + 1, inProcessRectY + 1 + rectHeight - fillHeight, rectWidth - 2, fillHeight - 2);
        g.setForeground(Color.GREEN);
        g.draw(numberInProcessFillRectangle);
        g.fill(numberInProcessFillRectangle);
        g.setForeground(Color.BLACK);
        g.drawString(String.valueOf(this.numberInProcess), inProcessRectX + 2, inProcessRectY + rectHeight - 5);
        if (this.drawSimulationControls()) {
            g.drawString(String.valueOf(capacity), inProcessRectX + 1, inProcessRectY - 3);
        }
        if (this.moreCapacityButton == null) {
            this.moreCapacityButton = this.createMoreCapacityButton((UiContainer)this.getCanvas());
        }
        if (this.lessCapacityButton == null) {
            this.lessCapacityButton = this.createLessCapacityButton((UiContainer)this.getCanvas());
        }
        if (this.drawSimulationControls()) {
            this.moreCapacityButton.setVisible(true);
            this.lessCapacityButton.setVisible(true);
            Rectangle more = new Rectangle(this.numberInProcessRectangle.getX() + this.numberInProcessRectangle.getWidth() + 2, this.numberInProcessRectangle.getY() + (this.numberInProcessRectangle.getHeight() - iconHeight * 2) / 2, this.moreCapacityButton.getIcon().getIconWidth(), this.moreCapacityButton.getIcon().getIconHeight());
            this.moreCapacityButton.setBounds(more);
            Rectangle less = new Rectangle(this.numberInProcessRectangle.getX() + this.numberInProcessRectangle.getWidth() + 2, this.moreCapacityButton.getLocation().getY() + iconHeight + 2, this.lessCapacityButton.getIcon().getIconWidth(), this.lessCapacityButton.getIcon().getIconHeight());
            this.lessCapacityButton.setBounds(less);
        } else {
            this.moreCapacityButton.setVisible(false);
            this.lessCapacityButton.setVisible(false);
        }
        int queueRectX = inProcessRectX - rectWidth - 2;
        if (this.queueSize > 0) {
            if (this.queueSize > this.maxQueue) {
                this.maxQueue = this.queueSize;
            }
            capacity = this.maxQueue;
            int queuePerc = this.queueSize * 100 / capacity;
            Rectangle queueRectangle = new Rectangle(queueRectX, inProcessRectY, rectWidth, rectHeight);
            g.draw(queueRectangle);
            fillHeight = queuePerc * rectHeight / 100;
            Rectangle fillRect = new Rectangle(queueRectX + 1, inProcessRectY + 1 + rectHeight - fillHeight, rectWidth - 2, fillHeight - 2);
            Color color = this.queueSize <= this.getSimulationInfo().getQueueWarningLevel() ? Color.YELLOW : Color.RED;
            g.setForeground(color);
            g.draw(fillRect);
            g.fill(fillRect);
            g.setForeground(Color.BLACK);
            g.drawString(String.valueOf(this.queueSize), queueRectX + 2, inProcessRectY + rectHeight - 5);
            g.drawString(String.valueOf(capacity), queueRectX + 1, inProcessRectY - 3);
        }
        g.setFont(f);
        this.drawRunTimeResourcePanel();
    }

    private PaintCanvas getCanvas() {
        return this.getDomain().getCanvas();
    }

    private ProcessDomain getDomain() {
        return this.controller.getDomain();
    }

    private FlowNode getFlowNode() {
        return this.controller.getModelObject();
    }

    private void removeFromSimulation(UiComponent component) {
        if (component != null) {
            component.setVisible(false);
        }
    }

    private Process getContent() {
        return this.controller.getModelObject().getProcess();
    }

    private Button createLessCapacityButton(UiContainer parent) {
        Image image = Image.create((Msg)UIMsg.TREE_MINUS);
        Button button = new Button(parent, image);
        parent.add((UiComponent)button);
        parent.revalidate();
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SimulationFlowNodeImpl simulationActivityImpl = ActivitySimulationDelegated.this.getSimulationInfo();
                if (simulationActivityImpl != null && simulationActivityImpl.getCapacity() > 1) {
                    simulationActivityImpl.setCapacity(simulationActivityImpl.getCapacity() - 1);
                }
            }
        });
        return button;
    }

    private Button createMoreCapacityButton(UiContainer parent) {
        Image image = Image.create((Msg)UIMsg.TREE_PLUS);
        Button button = new Button(parent, image);
        parent.add((UiComponent)button);
        parent.revalidate();
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SimulationFlowNodeImpl simulationActivityImpl = ActivitySimulationDelegated.this.getSimulationInfo();
                if (simulationActivityImpl != null && simulationActivityImpl.getCapacity() < 10000) {
                    simulationActivityImpl.setCapacity(simulationActivityImpl.getCapacity() + 1);
                }
            }
        });
        return button;
    }

    private Subprocess getParentScope() {
        return this.controller.getModelObject().getSubprocess();
    }

    private SimulationRunTimeResourcePanel getRunTimeResourcePanel(UiContainer parent) {
        Simulation simulation = this.getSimulation();
        SimulationRunTimeResourcePanel runTimeResourcePanel = new SimulationRunTimeResourcePanel(parent, this.getRuntimeInfo(), simulation.getProcessRuntimeInfo(this.getContent().getId()), simulation.getProjectSimulation());
        runTimeResourcePanel.setBackground(this.getCanvas().getBackground());
        runTimeResourcePanel.init();
        return runTimeResourcePanel;
    }

    private ActivityInfo getRuntimeInfo() {
        ProcessInfo processRuntimeInfo = this.getSimulation().getProcessRuntimeInfo(this.getContent().getId());
        return (ActivityInfo)processRuntimeInfo.getActivity(this.controller.getModelObject().getId());
    }

    private Simulation getSimulation() {
        return StudioSimulationUtils.getRunningSimulation(this.getContent());
    }

    private ModelSimulation getSimulationModel() {
        Simulation runningSimulation = StudioSimulationUtils.getRunningSimulation(this.getContent());
        if (runningSimulation != null) {
            return runningSimulation.getProcessModel(this.getContent());
        }
        return null;
    }

    private void drawRunTimeResourcePanel() {
        if (ModelUtils.isAnyInteractive((FlowNode)this.getFlowNode())) {
            if (this.resourcePanelButton == null) {
                this.resourcePanelButton = new Button((UiContainer)this.getCanvas());
                this.resourcePanelButton.setIcon(Image.create((Msg)UIMsg.LEFT_ARROW));
                this.resourcePanelButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        if (!ActivitySimulationDelegated.this.opened) {
                            ActivitySimulationDelegated.this.opened = true;
                            ActivitySimulationDelegated.this.resourcePanelButton.setIcon(UIMsg.RIGHT_ARROW);
                            ActivitySimulationDelegated.this.simulationRunTimeResourcePanel = ActivitySimulationDelegated.this.getRunTimeResourcePanel((UiContainer)ActivitySimulationDelegated.this.getCanvas());
                            ActivitySimulationDelegated.this.simulationRunTimeResourcePanel.setVisible(true);
                            ActivitySimulationDelegated.this.simulationRunTimeResourcePanel.setBounds(ActivitySimulationDelegated.this.resourcePanelButton.getX() + ActivitySimulationDelegated.this.resourcePanelButton.getWidth(), ActivitySimulationDelegated.this.resourcePanelButton.getY() + ActivitySimulationDelegated.this.resourcePanelButton.getHeight(), ActivitySimulationDelegated.this.simulationRunTimeResourcePanel.getPanelSize().getWidth(), ActivitySimulationDelegated.this.simulationRunTimeResourcePanel.getPanelSize().getHeight());
                            ActivitySimulationDelegated.this.simulationRunTimeResourcePanel.moveOnTop();
                        } else {
                            ActivitySimulationDelegated.this.opened = false;
                            ActivitySimulationDelegated.this.resourcePanelButton.setIcon(UIMsg.LEFT_ARROW);
                            if (ActivitySimulationDelegated.this.simulationRunTimeResourcePanel != null) {
                                ActivitySimulationDelegated.this.simulationRunTimeResourcePanel.setVisible(false);
                                ActivitySimulationDelegated.this.simulationRunTimeResourcePanel = null;
                            }
                            ActivitySimulationDelegated.this.getCanvas().repaint();
                        }
                    }
                });
                this.getCanvas().add((UiComponent)this.resourcePanelButton);
            }
            this.resourcePanelButton.setBounds(this.numberInProcessRectangle.getX() + this.numberInProcessRectangle.getWidth() + 2, this.numberInProcessRectangle.getY(), 12, 16);
            this.resourcePanelButton.setFocusPainted(false);
            this.resourcePanelButton.setFocusable(false);
            if (this.getSimulationInfo().getUseOrgResources()) {
                this.resourcePanelButton.setVisible(true);
            } else {
                this.resourcePanelButton.setVisible(false);
            }
        }
    }

    private boolean drawSimulationBar() {
        return this.getParentScope() == null && !ModelUtils.isBoundaryEvent((FlowNode)this.getFlowNode());
    }

    private boolean drawSimulationControls() {
        if (this.getSimulationInfo().getUseOrgResources() || !ModelUtils.isAnyInteractive((FlowNode)this.getFlowNode())) {
            return false;
        }
        if (ModelUtils.isSubprocess((FlowNode)this.getFlowNode())) {
            return !this.getSimulationInfo().getInnerSimulation();
        }
        return this.getParentScope() == null;
    }
}

