/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.simulation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.SortedSet;
import oracle.bpm.designer.simulation.ActivityNode;
import oracle.bpm.designer.simulation.ActivitySimulationPropertiesPanel;
import oracle.bpm.designer.simulation.ModelSimulationEditor;
import oracle.bpm.designer.simulation.ProcessNode;
import oracle.bpm.designer.simulation.RefreshListInterface;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.events.ProjectEvent;
import oracle.bpm.project.model.events.ProjectListener;
import oracle.bpm.project.model.events.ProjectListenerAdapter;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.BoundaryEvent;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.project.model.simulation.ModelSimulation;
import oracle.bpm.project.model.simulation.SimulationFlowNode;
import oracle.bpm.project.model.util.ModelUtils;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.SplitPane;
import oracle.bpm.ui.TreeSelectionMode;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiRunnableDecorator;
import oracle.bpm.ui.event.TreeSelectionEvent;
import oracle.bpm.ui.event.TreeSelectionListener;
import oracle.bpm.ui.event.VisibilityListener;
import oracle.bpm.ui.layout.CardLayout;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.tree.MutableTree;
import oracle.bpm.ui.tree.Tree;
import oracle.bpm.ui.tree.TreeNode;

class ActivitiesPanel
extends SplitPane
implements RefreshListInterface {
    private ActivityCardPanel activityCardPanel;
    private Tree activityTree;
    private ProjectListener<FlowNode> modelActivitiesListener;
    private ModelSimulation modelSimulation;
    private ModelSimulationEditor modelSimulationEditor;
    private ProjectListener<SequenceFlow> modelTransitionsListener;

    public ActivitiesPanel(UiContainer parent, ModelSimulation modelSimulation, ModelSimulationEditor modelSimulationEditor) {
        super(parent);
        this.modelSimulation = modelSimulation;
        this.modelSimulationEditor = modelSimulationEditor;
        this.init();
    }

    @Override
    public void addInnerActivities(FlowNode node) {
        this.fillActivityList();
        ProcessNode rootNode = (ProcessNode)this.activityTree.getRoot();
        final ActivityNode activityNode = (ActivityNode)rootNode.findChild(node.getId());
        if (activityNode != null) {
            new UiRunnableDecorator(0, new Runnable(){

                @Override
                public void run() {
                    activityNode.reloadAllChildren();
                    activityNode.expand();
                    activityNode.select();
                }
            }).run();
        }
    }

    @Override
    public void removeInnerActivities(final FlowNode node) {
        if (node != null) {
            new UiRunnableDecorator(0, new Runnable(){

                @Override
                public void run() {
                    TreeNode treeNode = ActivitiesPanel.this.activityTree.getRoot().findTreeNodeByUserObject((Object)node);
                    if (treeNode != null) {
                        treeNode.getParent().remove(treeNode);
                        ActivitiesPanel.this.activityTree.getRoot().reload();
                    }
                    ActivitiesPanel.this.activityCardPanel.removeCard(node);
                }
            }).run();
            SimulationFlowNode simulationActivity = this.getModelSimulation().findSimulationFlowNode(node.getId());
            if (simulationActivity != null) {
                try {
                    this.getModelSimulation().removeSimulationFlowNode(simulationActivity);
                }
                catch (ProjectException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    void editorToObject() {
        Collection cards = this.activityCardPanel.getCards();
        for (ActivitySimulationPropertiesPanel panel : cards) {
            panel.panelToObject();
        }
    }

    private void init() {
        this.activityTree = new MutableTree((UiContainer)this);
        this.activityTree.setShowsRootHandles(true);
        this.activityTree.setRootVisible(false);
        this.activityTree.setSelectionMode(TreeSelectionMode.SINGLE_TREE_SELECTION);
        this.activityCardPanel = new ActivityCardPanel((UiContainer)this, this.getModelSimulation(), this, this.modelSimulationEditor);
        ProcessNode rootNode = new ProcessNode(this.getModelSimulation().getProcess());
        this.activityTree.setRoot((TreeNode)rootNode);
        this.fillActivityList();
        this.activityTree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                TreeNode selectedTreeNode = ActivitiesPanel.this.activityTree.getSelectedTreeNode();
                if (selectedTreeNode instanceof ActivityNode) {
                    ActivitiesPanel.this.changedActivity();
                }
            }
        });
        this.setLeftComponent((UiComponent)this.activityTree);
        this.setRightComponent((UiComponent)this.activityCardPanel);
        if (rootNode.getChildCount() > 0) {
            TreeNode node = rootNode.getChildAt(0);
            node.select();
            this.changedActivity();
        }
        this.setOneTouchExpandable(true);
        this.setResizeWeight(0.25);
        this.registerListeners();
    }

    private void fillActivityList() {
        SortedSet nodes = ModelUtils.buildActivitySortedSet();
        for (FlowNode node : this.getModelSimulation().getProcess().getFlowNodes()) {
            this.addActivityToList(nodes, node);
        }
        TreeNode treeNode = this.activityTree.getSelectedTreeNode();
        this.activityTree.reload();
        if (treeNode != null) {
            treeNode.select();
        }
    }

    private void changedActivity() {
        ActivityNode activityNode;
        FlowNode node;
        TreeNode selectedNode = this.activityTree.getSelectedTreeNode();
        if (selectedNode instanceof ActivityNode && (node = (activityNode = (ActivityNode)this.activityTree.getSelectedTreeNode()).getActivity()) != null) {
            this.handleGroupActivities(node, activityNode);
            this.activityCardPanel.showCard(node);
        }
    }

    private void handleGroupActivities(FlowNode node, ActivityNode activityNode) {
        boolean innerSimulation;
        if (ModelUtils.isSubprocess((FlowNode)node) && !(innerSimulation = this.getModelSimulation().findSimulationFlowNode(node.getId()).getInnerSimulation())) {
            activityNode.removeAllChildren();
            activityNode.reload();
        }
    }

    private void addActivityToList(SortedSet<FlowNode> nodes, FlowNode node) {
        if (ModelUtils.canBeSimulated((FlowNode)node)) {
            SimulationFlowNode simulationActivity;
            nodes.add(node);
            if (ModelUtils.isSubprocess((FlowNode)node) && (simulationActivity = this.getModelSimulation().findSimulationFlowNode(node.getId())) == null) {
                simulationActivity = this.getModelSimulation().createSimulationFlowNode(node.getId());
                try {
                    this.getModelSimulation().addSimulationFlowNode(simulationActivity);
                }
                catch (ProjectException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void transitionOrBoundaryAdded(SequenceFlow transition) {
        this.transitionOrBoundaryAdded(transition.getSource());
    }

    private void transitionOrBoundaryAdded(FlowNode nodeFrom) {
        if (nodeFrom != null) {
            this.activityCardPanel.updateTransitionsCard(nodeFrom);
        }
    }

    private void transitionOrBoundaryRemoved(SequenceFlow transition) {
        this.transitionOrBoundaryAdded(transition);
    }

    private void transitionOrBoundaryRemoved(FlowNode flowNode) {
        this.transitionOrBoundaryAdded(flowNode);
    }

    private void transitionChanged() {
    }

    private void activityAdded(FlowNode node) {
        final ActivityNode activityNode = new ActivityNode(node);
        TreeNode groupTreeNode = this.activityTree.getRoot();
        if (node.getSubprocess() != null) {
            groupTreeNode = this.activityTree.getRoot().findTreeNodeByUserObject((Object)node.getSubprocess());
        }
        final TreeNode parentTreeNode = groupTreeNode == null ? this.activityTree.getRoot() : groupTreeNode;
        new UiRunnableDecorator(0, new Runnable(){

            @Override
            public void run() {
                parentTreeNode.add((TreeNode)activityNode);
                ActivitiesPanel.this.activityTree.getRoot().reload();
            }
        }).run();
    }

    private void activityRemoved(FlowNode node) {
        this.removeInnerActivities(node);
    }

    private ModelSimulation getModelSimulation() {
        return this.modelSimulation;
    }

    private void registerListeners() {
        Project project = this.getModelSimulation().getProject();
        if (this.modelActivitiesListener == null) {
            this.modelActivitiesListener = this.createModelActivitiesListener();
            project.addListener(this.modelActivitiesListener);
        }
        if (this.modelTransitionsListener == null) {
            this.modelTransitionsListener = this.createModelTransitionsListener();
            project.addListener(this.modelTransitionsListener);
        }
        this.addVisibilityListener(new VisibilityListener(){

            public void onDispose() {
                ActivitiesPanel.this.unregisterListeners();
            }
        });
    }

    private void unregisterListeners() {
        Project project = this.getModelSimulation().getProject();
        project.removeListener(this.modelActivitiesListener);
        project.removeListener(this.modelTransitionsListener);
        this.modelActivitiesListener = null;
        this.modelTransitionsListener = null;
    }

    private ProjectListenerAdapter<FlowNode> createModelActivitiesListener() {
        return new ProjectListenerAdapter<FlowNode>(FlowNode.class){

            public void postObjectAdded(FlowNode node, ProjectObject parent) {
                if (this.isValid(node)) {
                    ActivitiesPanel.this.activityAdded(node);
                }
            }

            public void postObjectRemoved(FlowNode node, ProjectObject parent) {
                if (this.isValid(node)) {
                    ActivitiesPanel.this.activityRemoved(node);
                }
            }

            private boolean isValid(FlowNode node) {
                return node.getProcess() != null && !ModelUtils.isBoundaryEvent((FlowNode)node) && !ModelUtils.isEndEvent((FlowNode)node);
            }
        };
    }

    private ProjectListener<SequenceFlow> createModelTransitionsListener() {
        return new ProjectListenerAdapter<SequenceFlow>(SequenceFlow.class){

            public void postObjectAdded(SequenceFlow transition, ProjectObject parent) {
                if (this.isValid(transition)) {
                    ActivitiesPanel.this.transitionOrBoundaryAdded(transition);
                    FlowNode node = transition.getSource();
                    if (ModelUtils.isBoundaryEvent((FlowNode)node)) {
                        ActivitiesPanel.this.transitionOrBoundaryAdded((FlowNode)((BoundaryEvent)node.asAnyNode(BoundaryEvent.class)).getBoundaryActivity());
                    }
                }
            }

            public void postObjectRemoved(SequenceFlow transition, ProjectObject parent) {
                if (this.isValid(transition)) {
                    ActivitiesPanel.this.transitionOrBoundaryRemoved(transition);
                    FlowNode node = transition.getSource();
                    if (ModelUtils.isBoundaryEvent((FlowNode)node)) {
                        ActivitiesPanel.this.transitionOrBoundaryRemoved((FlowNode)((BoundaryEvent)node.asAnyNode(BoundaryEvent.class)).getBoundaryActivity());
                    }
                }
            }

            public void objectChanged(SequenceFlow projectObject, ProjectEvent event) {
                if (event != null && event.getProjectObject() != null) {
                    FlowNode node;
                    SequenceFlow transition = (SequenceFlow)event.getProjectObject();
                    if (this.isValid(transition)) {
                        ActivitiesPanel.this.transitionChanged();
                    }
                    if (ModelUtils.isBoundaryEvent((FlowNode)(node = transition.getSource()))) {
                        ActivitiesPanel.this.transitionOrBoundaryAdded((FlowNode)((BoundaryEvent)node.asAnyNode(BoundaryEvent.class)).getBoundaryActivity());
                    }
                }
            }

            private boolean isValid(SequenceFlow transition) {
                return transition.getProcess() != null;
            }
        };
    }

    private static class ActivityCardPanel
    extends Panel {
        private ModelSimulationEditor editor;
        private ModelSimulation modelSimulation;
        private RefreshListInterface refreshListInterface;

        public ActivityCardPanel(UiContainer parent, ModelSimulation modelSimulation, RefreshListInterface refreshListInterface, ModelSimulationEditor editor) {
            super(parent);
            this.setLayout((Layout)new CardLayout());
            this.modelSimulation = modelSimulation;
            this.refreshListInterface = refreshListInterface;
            this.editor = editor;
        }

        public CardLayout getLayout() {
            return (CardLayout)super.getLayout();
        }

        public void showCard(FlowNode node) {
            String id = node.getId();
            if (this.getCard(id) == null) {
                ActivitySimulationPropertiesPanel panel = this.createCard(node);
                this.add((UiComponent)panel, id);
            }
            this.show(id);
        }

        public void removeCard(FlowNode node) {
            ActivitySimulationPropertiesPanel activityPanel = this.getCard(node);
            if (activityPanel != null) {
                this.remove((UiComponent)activityPanel);
                this.getLayout().removeLayoutComponent((UiComponent)activityPanel);
            }
        }

        public void updateTransitionsCard(FlowNode node) {
            ActivitySimulationPropertiesPanel activityPanel = this.getCard(node);
            if (activityPanel != null) {
                activityPanel.updateTransitions();
                activityPanel.repaint();
            }
        }

        private void show(String key) {
            this.getLayout().show((UiContainer)this, key);
        }

        private ActivitySimulationPropertiesPanel getCard(FlowNode node) {
            return this.getCard(node.getId());
        }

        private ActivitySimulationPropertiesPanel getCard(String id) {
            return (ActivitySimulationPropertiesPanel)this.getLayout().getComponent(id);
        }

        private ActivitySimulationPropertiesPanel createCard(FlowNode node) {
            this.editor.setUpdating(true);
            ModelSimulation simulation = this.getModelSimulation();
            String id = node.getId();
            SimulationFlowNode simulationActivity = simulation.findSimulationFlowNode(id);
            if (simulationActivity == null) {
                simulationActivity = simulation.createSimulationFlowNode(id);
                try {
                    simulation.addSimulationFlowNode(simulationActivity);
                }
                catch (ProjectException e) {
                    e.printStackTrace();
                }
            }
            ActivitySimulationPropertiesPanel panel = new ActivitySimulationPropertiesPanel((UiContainer)this, null, node, simulationActivity, this.refreshListInterface, simulation, this.editor);
            panel.objectToPanel();
            this.editor.setUpdating(false);
            return panel;
        }

        private Collection<ActivitySimulationPropertiesPanel> getCards() {
            Collection cards = this.getLayout().getContainedComponents().values();
            ArrayList<ActivitySimulationPropertiesPanel> result = new ArrayList<ActivitySimulationPropertiesPanel>();
            for (UiComponent component : cards) {
                result.add((ActivitySimulationPropertiesPanel)component);
            }
            return result;
        }

        private ModelSimulation getModelSimulation() {
            return this.modelSimulation;
        }
    }
}

