/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.selectorpanel;

import java.util.ArrayList;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.designer.conversation.ReferenceComboBox;
import oracle.bpm.designer.selectorpanel.AbstractSelectorPanel;
import oracle.bpm.designer.selectorpanel.SelectorComponent;
import oracle.bpm.designer.selectorpanel.SelectorListener;
import oracle.bpm.designer.selectorpanel.VetoableSelectorChangeEvent;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import org.jetbrains.annotations.NotNull;

public abstract class ComboBoxSelectorPanel<S, P extends ProjectObject>
extends AbstractSelectorPanel<S, P> {
    public ComboBoxSelectorPanel(@NotNull UiContainer parent, Msg title, P projectObject, Msg selectorLabel) {
        this(parent, title, projectObject, selectorLabel, 0);
    }

    public ComboBoxSelectorPanel(@NotNull UiContainer parent, Msg title, P projectObject, Msg selectorLabel, int insets) {
        super(parent, title, projectObject, selectorLabel, insets);
    }

    public void setLabelProvider(LabelProvider<S> labelProvider) {
        ((ComboBoxSelector)this.getOptionsComponent()).setLabelProvider(labelProvider);
    }

    @Override
    protected SelectorComponent<S> createOptionsComponent(@NotNull UiContainer container) {
        return new ComboBoxSelector(container, this.getLabel());
    }

    private static class ComboBoxSelector<T>
    extends Panel
    implements SelectorComponent<T> {
        private T currentSelection;
        private ArrayList<SelectorListener<T>> listeners = new ArrayList();
        private ReferenceComboBox<T> selectorComboBox;

        protected ComboBoxSelector(@NotNull UiContainer parent, Msg selectorLabel) {
            super(parent);
            this.init(selectorLabel);
        }

        @Override
        public void addSelectorListener(@NotNull SelectorListener<T> listener) {
            this.listeners.add(listener);
        }

        @Override
        public void removeSelectorListener(@NotNull SelectorListener<T> listener) {
            this.listeners.remove(listener);
        }

        @Override
        public void setSelectedOption(@NotNull T selectedOption) {
            this.selectorComboBox.setSelectedItem(selectedOption);
        }

        @Override
        public Sequence<T> getOptions() {
            ArrayList<Object> result = new ArrayList<Object>();
            for (int i = 0; i < this.selectorComboBox.getItemCount(); ++i) {
                result.add(this.selectorComboBox.getItemAt(i));
            }
            return CollectionUtils.asSequence(result);
        }

        @Override
        public T getSelectedOption() {
            return this.currentSelection;
        }

        @Override
        public UiComponent getUiComponent() {
            return this;
        }

        @Override
        public void addOption(@NotNull T item) {
            this.selectorComboBox.addItem(item);
        }

        @Override
        public boolean isValidSelection() {
            return this.selectorComboBox.isValidSelection();
        }

        @Override
        public void setSelectorEnabled(boolean enabled) {
            this.selectorComboBox.setEnabled(enabled);
        }

        public void setLabelProvider(LabelProvider<T> labelProvider) {
            this.selectorComboBox.setLabelProvider(labelProvider);
        }

        private void init(Msg selectorLabel) {
            this.setLayout((Layout)new MigLayout("ins 0, gap 0, fillx"));
            if (selectorLabel != null) {
                this.add((UiComponent)Label.create((UiContainer)this, (Msg)selectorLabel), "gapright 5");
            }
            this.selectorComboBox = new ReferenceComboBox((UiContainer)this);
            this.add((UiComponent)this.selectorComboBox, "growx");
            this.selectorComboBox.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    Object newValue = ComboBoxSelector.this.selectorComboBox.getSelectedItem();
                    if (ComboBoxSelector.this.currentSelection != newValue) {
                        if (!ComboBoxSelector.this.fireSelectionChanging(newValue)) {
                            ComboBoxSelector.this.setSelectedOption(ComboBoxSelector.this.currentSelection);
                        } else {
                            ComboBoxSelector.this.currentSelection = newValue;
                            ComboBoxSelector.this.fireSelectionChanged();
                        }
                    }
                }
            });
        }

        private boolean fireSelectionChanging(T newValue) {
            boolean result = true;
            VetoableSelectorChangeEvent<T> event = new VetoableSelectorChangeEvent<T>(this, newValue);
            for (SelectorListener<T> listener : this.listeners) {
                result &= listener.selectionChanging(event);
            }
            return result;
        }

        private void fireSelectionChanged() {
            for (SelectorListener<T> listener : this.listeners) {
                listener.selectionChanged();
            }
        }
    }
}

