/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.search.impl;

import java.util.Locale;
import oracle.bpm.designer.action.OpenComponentAction;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.search.impl.TypeDescriptionMatch;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.util.documentation.DocumentationType;

public class ObjectDocMatch
extends TypeDescriptionMatch {
    private int column;
    private int endColumn;
    private Locale lang;
    private int line;
    private ObjectTypeDescription object;
    private int offset;
    private String text;
    private DocumentationType type;

    public ObjectDocMatch(ObjectTypeDescription object, String pattern, DocumentationType type, Locale lang, String text, int line, int column, int offset, int endColumn) {
        super(object);
        this.object = object;
        this.type = type;
        this.lang = lang;
        this.text = text;
        this.line = line;
        this.column = column;
        this.offset = offset;
        this.endColumn = endColumn;
    }

    @Override
    public String getSourceText() {
        return this.object.getName();
    }

    @Override
    public String getText() {
        return DesignerMsg.DOCUMENTATION.getString() + " (" + this.line + "," + this.column + ") " + this.text;
    }

    @Override
    public void edit(Exception exception) {
        OpenComponentAction openComponentAction = new OpenComponentAction(this.object);
        openComponentAction.run();
    }

    @Override
    public void select(Exception exception) {
    }
}

