/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.search;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import javax.swing.JTextPane;
import oracle.bpm.collections.maps.LocaleStringMap;
import oracle.bpm.designer.search.Finder;
import oracle.bpm.designer.search.Match;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.resources.Msg;
import oracle.bpm.util.ProgressMonitor;
import oracle.bpm.util.documentation.DocumentationType;
import oracle.bpm.util.documentation.DocumentationUtils;

public abstract class FindSupport {
    protected Matcher matcher;

    public abstract String getType();

    public abstract List<Match> deepSearch(List<Finder.Readable> var1, Matcher var2, ProgressMonitor var3) throws Exception;

    protected abstract Match createMethodNameMatch(MethodTypeDescription var1);

    protected abstract Match createMethodSrcMatch(MethodTypeDescription var1, String var2, int var3, int var4, int var5, int var6);

    protected void findInSource(final List<Match> matches, final MethodTypeDescription method) {
        if (method.getCode() != null) {
            TextSearchListener listener = new TextSearchListener(){

                @Override
                public void matchFound(String pattern, String lineText, int line, int column, int offset, int endColumn) {
                    matches.add(FindSupport.this.createMethodSrcMatch(method, lineText, line, column, offset, endColumn));
                }
            };
            this.findInText(new String(method.getCode().getText()).trim(), listener);
        }
    }

    protected void phase(ProgressMonitor monitor, Msg msg) {
        if (monitor != null) {
            monitor.phase(msg);
        }
    }

    protected void searchDocumentationMap(TypeDescription type, final DocumentationSearchListener listener) {
        for (final DocumentationType docType : DocumentationType.values()) {
            LocaleStringMap documentation = type.getDocumentation(docType);
            for (Map.Entry entry : documentation.entrySet()) {
                final Locale lang = (Locale)entry.getKey();
                String text = (String)entry.getValue();
                try {
                    JTextPane pane = new JTextPane();
                    DocumentationUtils.loadDocumentation(pane, text);
                    text = pane.getDocument().getText(0, pane.getDocument().getLength());
                }
                catch (Throwable e) {
                    text = (String)entry.getValue();
                }
                TextSearchListener textListener = new TextSearchListener(){

                    @Override
                    public void matchFound(String pattern, String lineText, int line, int column, int offset, int endColumn) {
                        listener.matchFound(pattern, docType, lang, lineText, line, column, offset, endColumn);
                    }
                };
                this.findInText(text, textListener);
            }
        }
    }

    private void findInText(String text, TextSearchListener listener) {
        if (text.length() > 0) {
            StringTokenizer tokenizer = new StringTokenizer(text, "\r\n");
            int line = 0;
            int offset = 0;
            while (tokenizer.hasMoreTokens()) {
                ++line;
                String lineSeq = tokenizer.nextToken();
                this.matcher.reset(lineSeq);
                while (this.matcher.find()) {
                    listener.matchFound("", lineSeq.trim(), line, this.matcher.start(), this.matcher.start() + offset, this.matcher.end());
                }
                offset += lineSeq.length() + 1;
            }
        }
    }

    private static interface TextSearchListener {
        public void matchFound(String var1, String var2, int var3, int var4, int var5, int var6);
    }

    protected static interface DocumentationSearchListener {
        public void matchFound(String var1, DocumentationType var2, Locale var3, String var4, int var5, int var6, int var7, int var8);
    }
}

