/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.screenflow;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import oracle.bpm.collections.lists.MsgList;
import oracle.bpm.collections.maps.LocaleStringMap;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.screenflow.InputField;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.Modifier;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.project.ActivityImpl;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.processes.DataObject;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.type.TypeFactory;
import oracle.bpm.type.TypeHolder;
import oracle.bpm.ui.table.ProviderTableModel;

public class Model
extends ProviderTableModel<InputField> {
    private ActivityImpl activityImpl;
    private static final int REQUIRED = 0;
    private static final int READONLY = 1;
    static final int LABEL = 2;
    static final int TARGET = 3;
    static final int TYPE = 4;
    private static final MsgList TITLES = MsgList.create(DesignerMsg.INPUT_REQUIRED_FIELD, DesignerMsg.INPUT_READONLY_FIELD, DesignerMsg.INPUT_LABEL, DesignerMsg.VARIABLES, DesignerMsg.INPUT_TYPE);
    public static final Class[] CLASSES = new Class[]{Boolean.class, Boolean.class, String.class, TypeHolder.class, InputField.Type.class};

    public Model(ActivityImpl activityImpl) {
        super(TITLES);
        this.activityImpl = activityImpl;
    }

    public boolean isCellEditable(int row, int column) {
        return true;
    }

    public Class getColumnClass(int columnIndex) {
        return CLASSES[columnIndex];
    }

    public void setValueAt(Object aValue, int row, int column) {
        InputField field = (InputField)this.getRow(row);
        switch (column) {
            case 0: {
                boolean required = (Boolean)aValue;
                if (required && field.isReadonly()) {
                    field.setReadonly(false);
                    this.fireTableCellUpdated(row, 1);
                }
                field.setRequired(required);
                break;
            }
            case 1: {
                boolean readonly = (Boolean)aValue;
                field.setReadonly(readonly);
                if (!readonly || !field.isRequired()) break;
                field.setRequired(false);
                this.fireTableCellUpdated(row, 0);
                break;
            }
            case 2: {
                field.setLocaleStringMap((LocaleStringMap)aValue);
                break;
            }
            case 3: {
                TypeHolder typeHolder = (TypeHolder)aValue;
                field.setTarget(typeHolder);
                this.checkTargetTypeConsistency(row, field);
                break;
            }
            case 4: {
                field.setType((InputField.Type)aValue);
            }
        }
        this.fireTableCellUpdated(row, column);
    }

    public void check() {
        for (int i = 0; i < this.getRowCount(); ++i) {
            InputField field = (InputField)this.getRow(i);
            this.checkTargetTypeConsistency(i, field);
        }
    }

    public Object getValueAt(int row, int column) {
        InputField field = (InputField)this.getRow(row);
        switch (column) {
            case 0: {
                return field.isRequired();
            }
            case 1: {
                return field.isReadonly();
            }
            case 2: {
                return field.getLocaleStringMap();
            }
            case 3: {
                return field.getTarget();
            }
            case 4: {
                return field.getType();
            }
        }
        return null;
    }

    public int indexOf(InputField field) {
        return this.getData().indexOf(field);
    }

    public List<TypeHolder> getUnusedVariablesList(TypeHolder currentValue) {
        List data = this.getData();
        HashSet<TypeHolder> used = new HashSet<TypeHolder>();
        for (InputField inputField : data) {
            TypeHolder target = inputField.getTarget();
            if (target == currentValue) continue;
            used.add(target);
        }
        List<TypeHolder> list = this.getVariablesList();
        ArrayList<TypeHolder> unusedList = new ArrayList<TypeHolder>();
        for (TypeHolder typeHolder : list) {
            if (used.contains(typeHolder)) continue;
            unusedList.add(typeHolder);
        }
        return unusedList;
    }

    public List<TypeHolder> getVariablesList() {
        return null;
    }

    private void checkTargetTypeConsistency(int row, InputField field) {
        TypeHolder typeHolder = field.getTarget();
        TypeDescription typeDescription = typeHolder.getType();
        InputField.Type newType = InputField.Type.getDefault(typeDescription);
        if (field.getType() == null || newType.getId() != field.getType().getId()) {
            field.setType(newType);
            field.resetValues();
            this.fireTableCellUpdated(row, 4);
        }
    }

    private ActivityImpl getActivity() {
        return this.activityImpl;
    }

    private Process getContent() {
        return this.getActivity().getProcess();
    }

    private Project getProject() {
        return this.getContent().getProject();
    }

    private boolean isAllowed(MethodTypeDescription variable) {
        boolean isAllowed;
        long modifiers = variable.getModifiers();
        boolean bl = isAllowed = !Modifier.isHidden(modifiers) && variable instanceof DataObject && Modifier.hasSetter(modifiers);
        if (isAllowed) {
            TypeDescription resultType = variable.getResultType();
            int kind = resultType.getKind();
            isAllowed = kind >= 1 && kind <= 7 || kind == 12 && resultType.getElementType() == TypeFactory.getString() || resultType.isEnum();
        }
        return isAllowed;
    }
}

