/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.screenflow;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.DefaultListModel;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.screenflow.InputField;
import oracle.bpm.draw.msg.ProjectDrawMsg;
import oracle.bpm.lang.Interval;
import oracle.bpm.lang.IntervalUnit;
import oracle.bpm.lang.Time;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.lib.msg.LibMsg;
import oracle.bpm.project.msg.ProjectMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.type.TypeHolder;
import oracle.bpm.ui.AbstractButton;
import oracle.bpm.ui.BorderPanel;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.ButtonGroup;
import oracle.bpm.ui.CheckBox;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.OkCancelDialog;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.RadioButton;
import oracle.bpm.ui.RadioTabbedPane;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiFactory;
import oracle.bpm.ui.UiManager;
import oracle.bpm.ui.UiUtilities;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.border.BorderFactory;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.event.ActionListener;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;
import oracle.bpm.ui.event.ListSelectionEvent;
import oracle.bpm.ui.event.ListSelectionListener;
import oracle.bpm.ui.event.UiEvent;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.layout.form.CellConstraints;
import oracle.bpm.ui.layout.form.FormLayout;
import oracle.bpm.ui.layout.form.PanelBuilder;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.text.IntervalField;
import oracle.bpm.ui.text.NumericField;
import oracle.bpm.ui.text.TextArea;
import oracle.bpm.ui.text.TextField;
import oracle.bpm.ui.text.TimeField;

class InputOptionsDialog
extends OkCancelDialog {
    private BasePanel basePanel;
    private InputField field;
    private List<TypeHolder> optionList;

    public InputOptionsDialog(UiWindow parent, InputField field, List<TypeHolder> variableList) {
        super(parent, DesignerMsg.ADVANCED_OPTIONS, true);
        this.field = field;
        this.optionList = variableList;
        this.init();
    }

    public void close() {
        super.close();
    }

    public InputField getField() {
        return this.field;
    }

    public void ok() {
        BasePanel basePanel = this.getBasePanel();
        if (basePanel.validateChanges()) {
            basePanel.applyChanges();
            this.close();
        }
    }

    BasePanel getBasePanel() {
        return this.basePanel;
    }

    private void init() {
        InputField field = this.getField();
        InputField.Type type = field.getType();
        UiContainer contentPane = this.getContentPane();
        this.basePanel = type == InputField.NUMBER ? NumberPanel.create(contentPane, field) : (type == InputField.TEXT ? new TextPanel(contentPane, field) : (type == InputField.LONG_TEXT ? new LongTextPanel(contentPane, field) : (type == InputField.PASSWORD ? new TextPanel(contentPane, field) : (type == InputField.TIME ? new TimePanel(contentPane, field) : (type == InputField.INTERVAL ? new IntervalPanel(contentPane, field) : (type == InputField.BOOL ? new BoolPanel(contentPane, field) : (type == InputField.OPTION ? new OptionPanel(contentPane, field, this.optionList) : new OptionsPanel(contentPane, field))))))));
        this.basePanel.updatePanel();
        contentPane.setLayout((Layout)new BorderLayout());
        contentPane.add((UiComponent)this.basePanel, (Object)"Center");
        this.pack();
        this.setLocationRelativeTo((UiComponent)this.getParent());
    }

    private class OptionsPanel
    extends BasePanel
    implements ListSelectionListener,
    ActionListener {
        private Button addBtn;
        private Button delBtn;
        private Button selBtn;
        private List<Object> selectedList;
        private Button unselBtn;
        private TextField valueFld;
        private oracle.bpm.ui.List valueList;

        public OptionsPanel(UiContainer parent, InputField field) {
            super(parent, field);
            this.selectedList = new ArrayList<Object>();
            this.add(this.buildOptionsPanel((UiContainer)this), "Center");
        }

        public void actionPerformed(ActionEvent e) {
            int[] indices;
            UiComponent source = e.getSource();
            DefaultListModel model = (DefaultListModel)this.valueList.getModel();
            if (source == this.addBtn) {
                String value = this.valueFld.getText().trim();
                if (!"".equals(value) && !model.contains(value)) {
                    model.addElement(value);
                    this.valueFld.setText("");
                    this.valueFld.requestFocus();
                }
            } else if (source == this.delBtn) {
                int[] indices2 = this.valueList.getSelectedIndices();
                if (indices2 != null) {
                    for (int indice : indices2) {
                        Object elementAt = model.getElementAt(indice);
                        model.removeElement(elementAt);
                        this.selectedList.remove(elementAt);
                    }
                }
            } else if (source == this.selBtn) {
                int[] indices3 = this.valueList.getSelectedIndices();
                if (indices3 != null) {
                    for (int indice : indices3) {
                        Object value = model.getElementAt(indice);
                        if (this.selectedList.contains(value)) continue;
                        this.selectedList.add(value);
                    }
                    this.invokeRepaint();
                }
            } else if (source == this.unselBtn && (indices = this.valueList.getSelectedIndices()) != null) {
                for (int indice : indices) {
                    this.selectedList.remove(model.getElementAt(indice));
                }
                this.invokeRepaint();
            }
        }

        @Override
        public void applyChanges() {
            DefaultListModel model = (DefaultListModel)this.valueList.getModel();
            InputField field = this.getField();
            List values = field.getValues();
            values.clear();
            List selectedValues = field.getSelectedValues();
            selectedValues.clear();
            for (int i = 0; i < model.getSize(); ++i) {
                values.add(model.getElementAt(i));
            }
            selectedValues.clear();
            selectedValues.addAll(this.getSelectedValues());
        }

        public void valueChanged(ListSelectionEvent e) {
            int[] indices = this.valueList.getSelectedIndices();
            this.delBtn.setEnabled(indices.length > 0);
            this.selBtn.setEnabled(indices.length > 0);
            this.unselBtn.setEnabled(indices.length > 0);
        }

        @Override
        protected void updatePanel() {
            InputField field = this.getField();
            List values = field.getValues();
            this.selectedList.addAll(field.getSelectedValues());
            DefaultListModel model = (DefaultListModel)this.valueList.getModel();
            for (Object value : values) {
                model.addElement(value);
            }
        }

        @Override
        boolean validateChanges() {
            boolean isEmpty;
            boolean bl = isEmpty = this.valueList.getModel().getSize() == 0;
            if (isEmpty) {
                MessageDialog.showError((Msg)UIMsg.ERROR, (Msg)UIMsg.TO_MSG((String)"Please enter at least one option"));
            }
            return !isEmpty;
        }

        private UiComponent buildOptionsPanel(UiContainer parent) {
            Panel panel = new Panel(parent);
            this.valueList = new oracle.bpm.ui.List((UiContainer)panel, new DefaultListModel());
            this.valueList.setLabelProvider((LabelProvider)new LabelProvider.Default<Object>(){

                public String getText(Object element) {
                    return OptionsPanel.this.selectedList.contains(element) ? element + " <" + ProjectDrawMsg.SELECTED.getString() + ">" : element.toString();
                }
            });
            this.valueList.addListSelectionListener((ListSelectionListener)this);
            this.addBtn = new Button((UiContainer)panel, UIMsg.ADD);
            this.delBtn = new Button((UiContainer)panel, UIMsg.REMOVE);
            this.selBtn = new Button((UiContainer)panel, LibMsg.SELECT);
            this.unselBtn = new Button((UiContainer)panel, DesignerMsg.UNSELECT);
            this.addBtn.addActionListener((ActionListener)this);
            this.delBtn.addActionListener((ActionListener)this);
            this.selBtn.addActionListener((ActionListener)this);
            this.unselBtn.addActionListener((ActionListener)this);
            this.valueFld = new TextField((UiContainer)panel);
            this.valueFld.setColumns(25);
            FormLayout layout = new FormLayout("5dlu, pref, 5dlu, pref:grow, 5dlu, pref, 5dlu", "5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, max(50dlu;pref):grow, 5dlu");
            PanelBuilder builder = layout.createBuilder(panel);
            CellConstraints cc = layout.createCellConstraints();
            builder.add((UiComponent)Label.create((UiContainer)panel, (Msg)DesignerMsg.VALUE), cc.xy(2, 2));
            builder.add((UiComponent)this.valueFld, cc.xy(4, 2));
            builder.add((UiComponent)this.addBtn, cc.xy(6, 2));
            builder.add((UiComponent)this.delBtn, cc.xy(6, 4));
            builder.add((UiComponent)this.selBtn, cc.xy(6, 6));
            builder.add((UiComponent)this.unselBtn, cc.xy(6, 8));
            builder.add((UiComponent)this.valueList, cc.xywh(2, 4, 3, 6));
            return panel;
        }

        private List getSelectedValues() {
            return this.selectedList;
        }

        private void invokeRepaint() {
            this.valueList.repaint();
        }
    }

    private static class TimePanel
    extends BasePanel
    implements ActionListener {
        private RadioButton dateBtn;
        private CheckBox defaultValueChk;
        private RadioButton timeBtn;
        private RadioButton timeDateBtn;
        private TimeField timeField;

        public TimePanel(UiContainer parent, InputField field) {
            super(parent, field);
            this.setLayout((Layout)new BorderLayout());
            this.add(this.buildDefaultPanel((UiContainer)this), "North");
            this.add(this.buildTimePanel((UiContainer)this), "Center");
        }

        public void actionPerformed(ActionEvent e) {
            UiComponent source = e.getSource();
            if (source == this.defaultValueChk) {
                this.timeField.setEnabled(this.defaultValueChk.isSelected());
            }
        }

        @Override
        void applyChanges() {
            InputField field = this.getField();
            Time value = this.timeField.getTime();
            if (this.defaultValueChk.isSelected()) {
                field.setDefaultValue(value);
            } else {
                field.setDefaultValue(null);
            }
            if (this.timeBtn.isSelected()) {
                field.setTimeOption("time");
            } else if (this.dateBtn.isSelected()) {
                field.setTimeOption("date");
            } else {
                field.setTimeOption(null);
            }
        }

        @Override
        void updatePanel() {
            String option;
            Object defaultValue = this.getField().getDefaultValue();
            if (defaultValue != null) {
                Time time = defaultValue instanceof Time ? (Time)defaultValue : Time.valueOf(defaultValue.toString());
                this.timeField.setTime(time);
                this.defaultValueChk.setSelected(true);
                this.timeField.setEnabled(true);
            }
            if ((option = this.field.getTimeOption()) != null) {
                if (option.equals("time")) {
                    this.timeBtn.setSelected(true);
                } else if (option.equals("date")) {
                    this.dateBtn.setSelected(true);
                } else {
                    this.timeDateBtn.setSelected(true);
                }
            }
        }

        @Override
        boolean validateChanges() {
            return true;
        }

        private UiComponent buildDefaultPanel(UiContainer parent) {
            BorderPanel panel = new BorderPanel(parent);
            this.timeField = new TimeField((UiContainer)panel);
            this.timeField.setTime(new Time());
            this.timeField.setEnabled(false);
            FormLayout layout = new FormLayout("5dlu, pref, 5dlu, pref:grow, 5dlu", "5dlu, pref, 5dlu");
            PanelBuilder builder = layout.createBuilder((Panel)panel);
            CellConstraints cc = layout.createCellConstraints();
            this.defaultValueChk = CheckBox.create((UiContainer)panel, (Msg)ProjectMsg.DEFAULT_VALUE);
            this.defaultValueChk.addActionListener((ActionListener)this);
            builder.add((UiComponent)this.defaultValueChk, cc.xy(2, 2));
            builder.add((UiComponent)this.timeField, cc.xy(4, 2));
            return panel;
        }

        private UiComponent buildTimePanel(UiContainer parent) {
            Panel panel = new Panel(parent, DesignerMsg.TIME_OPTIONS);
            this.timeDateBtn = new RadioButton((UiContainer)panel, DesignerMsg.DISPLAY_DATE_TIME);
            this.dateBtn = new RadioButton((UiContainer)panel, DesignerMsg.DISPLAY_DATE);
            this.timeBtn = new RadioButton((UiContainer)panel, DesignerMsg.DISPLAY_TIME);
            ButtonGroup btnGroup = new ButtonGroup();
            btnGroup.add((AbstractButton)this.timeDateBtn);
            btnGroup.add((AbstractButton)this.timeBtn);
            btnGroup.add((AbstractButton)this.dateBtn);
            FormLayout layout = new FormLayout("5dlu, pref:grow, 5dlu", "5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu");
            PanelBuilder builder = layout.createBuilder(panel);
            CellConstraints cc = layout.createCellConstraints();
            builder.add((UiComponent)this.timeDateBtn, cc.xy(2, 2));
            builder.add((UiComponent)this.timeBtn, cc.xy(2, 4));
            builder.add((UiComponent)this.dateBtn, cc.xy(2, 6));
            this.timeDateBtn.setSelected(true);
            return panel;
        }
    }

    private static class TextPanel
    extends BasePanel
    implements ActionListener {
        private CheckBox defaultValueChk;
        private TextField textField;

        public TextPanel(UiContainer parent, InputField field) {
            super(parent, field);
            this.add(this.buildDefaultPanel((UiContainer)this), "North");
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.defaultValueChk) {
                this.textField.setEnabled(this.defaultValueChk.isSelected());
            }
        }

        @Override
        void applyChanges() {
            if (this.defaultValueChk.isSelected()) {
                this.getField().setDefaultValue(this.textField.getText());
            } else {
                this.getField().setDefaultValue(null);
            }
        }

        @Override
        void updatePanel() {
            Object defaultValue = this.getField().getDefaultValue();
            if (defaultValue != null) {
                this.textField.setText(defaultValue.toString());
                this.defaultValueChk.setSelected(true);
                this.textField.setEnabled(true);
            }
        }

        @Override
        boolean validateChanges() {
            return true;
        }

        private UiComponent buildDefaultPanel(UiContainer parent) {
            BorderPanel panel = new BorderPanel(parent);
            this.textField = new TextField((UiContainer)panel);
            this.textField.setEnabled(false);
            FormLayout layout = new FormLayout("5dlu, pref, 5dlu, pref:grow, 5dlu", "5dlu, pref, 5dlu");
            PanelBuilder builder = layout.createBuilder((Panel)panel);
            CellConstraints cc = layout.createCellConstraints();
            this.defaultValueChk = CheckBox.create((UiContainer)panel, (Msg)ProjectMsg.DEFAULT_VALUE);
            this.defaultValueChk.addActionListener((ActionListener)this);
            builder.add((UiComponent)this.defaultValueChk, cc.xy(2, 2));
            builder.add((UiComponent)this.textField, cc.xy(4, 2));
            return panel;
        }
    }

    private static class OptionPanel
    extends BasePanel
    implements ListSelectionListener,
    ActionListener {
        private Button addBtn;
        private ComboBox attributeCombo;
        private Button delBtn;
        private RadioTabbedPane panel;
        private TextField valueFld;
        private oracle.bpm.ui.List valueList;

        public OptionPanel(UiContainer parent, InputField field, List<TypeHolder> attributeList) {
            super(parent, field);
            this.add(this.buildPanel((UiContainer)this, attributeList), "Center");
        }

        public void actionPerformed(ActionEvent e) {
            UiComponent source = e.getSource();
            DefaultListModel model = (DefaultListModel)this.valueList.getModel();
            if (source == this.addBtn) {
                String value = this.valueFld.getText().trim();
                if (!"".equals(value) && !model.contains(value)) {
                    model.addElement(value);
                    this.valueFld.setText("");
                    UiUtilities.invokeLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            OptionPanel.this.valueFld.requestFocus();
                        }
                    });
                }
            } else if (source == this.delBtn) {
                int[] indices = this.valueList.getSelectedIndices();
                for (int i = indices.length - 1; i >= 0; --i) {
                    Object elementAt = model.getElementAt(indices[i]);
                    model.removeElement(elementAt);
                }
            }
        }

        @Override
        public void applyChanges() {
            List values = this.getField().getValues();
            values.clear();
            if (this.panel.getSelectedIndex() == 0) {
                DefaultListModel model = (DefaultListModel)this.valueList.getModel();
                for (int i = 0; i < model.getSize(); ++i) {
                    values.add(model.getElementAt(i));
                }
                this.getField().setValueProvider(null);
            } else {
                TypeHolder holder = (TypeHolder)this.attributeCombo.getSelectedItem();
                this.getField().setValueProvider(holder == null ? null : holder.getName());
            }
        }

        public void valueChanged(ListSelectionEvent e) {
            int[] indices = this.valueList.getSelectedIndices();
            this.delBtn.setEnabled(indices.length > 0);
        }

        @Override
        protected void updatePanel() {
            this.attributeCombo.setSelectedItem(null);
            if (this.getField().getValueProvider() == null) {
                List values = this.getField().getValues();
                DefaultListModel model = (DefaultListModel)this.valueList.getModel();
                model.removeAllElements();
                for (Object value : values) {
                    model.addElement(value);
                }
                this.panel.setSelectedIndex(0);
            } else {
                this.panel.setSelectedIndex(1);
                String attributeName = this.getField().getValueProvider();
                for (int i = 0; i < this.attributeCombo.getModel().getSize(); ++i) {
                    Object each = this.attributeCombo.getModel().getElementAt(i);
                    if (!(each instanceof TypeHolder) || !attributeName.equals(((TypeHolder)each).getName())) continue;
                    this.attributeCombo.setSelectedItem(each);
                    break;
                }
            }
        }

        @Override
        boolean validateChanges() {
            boolean isEmpty;
            if (this.panel.getSelectedIndex() == 0) {
                boolean isEmpty2;
                boolean bl = isEmpty2 = this.valueList.getModel().getSize() == 0;
                if (isEmpty2) {
                    MessageDialog.showError((Msg)UIMsg.ERROR, (Msg)UIMsg.TO_MSG((String)"Please enter at least one option"));
                }
                return !isEmpty2;
            }
            boolean bl = isEmpty = this.attributeCombo.getSelectedItem() == null;
            if (isEmpty) {
                MessageDialog.showError((Msg)UIMsg.ERROR, (Msg)UIMsg.TO_MSG((String)"Please choose an attribute"));
            }
            return !isEmpty;
        }

        private UiComponent buildAttributePanel(UiContainer parent, List<TypeHolder> attributeList) {
            Panel panel = new Panel(parent);
            FormLayout layout = new FormLayout("5dlu, pref:grow, 5dlu", "5dlu, pref, 5dlu:grow");
            PanelBuilder builder = layout.createBuilder(panel);
            CellConstraints cc = layout.createCellConstraints();
            this.attributeCombo = UiFactory.createComboBox((UiContainer)panel);
            this.attributeCombo.addItems(attributeList);
            builder.add((UiComponent)this.attributeCombo, cc.xy(2, 2));
            return panel;
        }

        private UiComponent buildOptionsPanel(UiContainer parent) {
            Panel panel = new Panel(parent);
            this.valueList = new oracle.bpm.ui.List((UiContainer)panel, new DefaultListModel());
            this.valueList.addListSelectionListener((ListSelectionListener)this);
            this.addBtn = new Button((UiContainer)panel, UIMsg.ADD);
            this.delBtn = new Button((UiContainer)panel, UIMsg.REMOVE);
            this.addBtn.addActionListener((ActionListener)this);
            this.delBtn.addActionListener((ActionListener)this);
            this.valueFld = new TextField((UiContainer)panel);
            this.valueFld.setColumns(25);
            FormLayout layout = new FormLayout("5dlu, pref, 5dlu, pref:grow, 5dlu, pref, 5dlu", "5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, max(50dlu;pref):grow, 5dlu");
            PanelBuilder builder = layout.createBuilder(panel);
            CellConstraints cc = layout.createCellConstraints();
            builder.add((UiComponent)Label.create((UiContainer)panel, (Msg)DesignerMsg.VALUE), cc.xy(2, 2));
            builder.add((UiComponent)this.valueFld, cc.xy(4, 2));
            builder.add((UiComponent)this.addBtn, cc.xy(6, 2));
            builder.add((UiComponent)this.delBtn, cc.xy(6, 4));
            builder.add((UiComponent)this.valueList, cc.xywh(2, 4, 3, 6));
            return panel;
        }

        private UiComponent buildPanel(UiContainer parent, List<TypeHolder> attributeList) {
            this.panel = new RadioTabbedPane(parent);
            UiComponent options = this.buildOptionsPanel(this.panel.getAddPoint());
            options.setBorder(BorderFactory.createEtchedBorder());
            UiComponent attributePanel = this.buildAttributePanel(this.panel.getAddPoint(), attributeList);
            attributePanel.setBorder(BorderFactory.createEtchedBorder());
            this.panel.addTab(DesignerMsg.LIST_VALID_VALUES, options);
            this.panel.addTab(DesignerMsg.INSTANCE_VARIABLE, attributePanel);
            return this.panel;
        }
    }

    private static class LongTextPanel
    extends BasePanel
    implements ActionListener {
        private CheckBox defaultValueChk;
        private TextArea textArea;

        public LongTextPanel(UiContainer parent, InputField field) {
            super(parent, field);
            this.add(this.buildDefaultPanel((UiContainer)this), "North");
            this.add(this.buildLongTextPanel((UiContainer)this), "Center");
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.defaultValueChk) {
                this.textArea.setEnabled(this.defaultValueChk.isSelected());
            }
        }

        @Override
        void applyChanges() {
            if (this.defaultValueChk.isSelected()) {
                this.getField().setDefaultValue(this.textArea.getText());
            } else {
                this.getField().setDefaultValue(null);
            }
        }

        @Override
        void updatePanel() {
            Object defaultValue = this.getField().getDefaultValue();
            if (defaultValue != null) {
                this.textArea.setText(defaultValue.toString());
                this.defaultValueChk.setSelected(true);
                this.textArea.setEnabled(true);
            }
        }

        @Override
        boolean validateChanges() {
            return true;
        }

        private UiComponent buildDefaultPanel(UiContainer parent) {
            BorderPanel panel = new BorderPanel(parent);
            FormLayout layout = new FormLayout("5dlu, pref, 5dlu", "5dlu, pref, 5dlu");
            PanelBuilder builder = layout.createBuilder((Panel)panel);
            CellConstraints cc = layout.createCellConstraints();
            this.defaultValueChk = CheckBox.create((UiContainer)panel, (Msg)ProjectMsg.DEFAULT_VALUE);
            this.defaultValueChk.addActionListener((ActionListener)this);
            builder.add((UiComponent)this.defaultValueChk, cc.xy(2, 2));
            return panel;
        }

        private UiComponent buildLongTextPanel(UiContainer parent) {
            this.textArea = new TextArea(parent);
            this.textArea.setRows(10);
            this.textArea.setColumns(30);
            this.textArea.setEnabled(false);
            this.textArea.setBorder(UiManager.border((String)"TextField.border"));
            return this.textArea;
        }
    }

    private static class IntervalPanel
    extends BasePanel
    implements ActionListener,
    ItemListener {
        private CheckBox defaultValueChk;
        private IntervalField intervalField;
        private ComboBox intervalLst;

        public IntervalPanel(UiContainer parent, InputField field) {
            super(parent, field);
            this.setLayout((Layout)new BorderLayout());
            this.add(this.buildOptionsPanel((UiContainer)this), "North");
            this.add(this.buildValuePanel((UiContainer)this), "Center");
        }

        public void itemStateChanged(ItemEvent e) {
            this.processEvent((UiEvent)e);
        }

        public void actionPerformed(ActionEvent e) {
            this.processEvent((UiEvent)e);
        }

        @Override
        void applyChanges() {
            InputField field = this.getField();
            if (this.defaultValueChk.isSelected()) {
                field.setDefaultValue(this.intervalField.getInterval());
            } else {
                field.setDefaultValue(null);
            }
            Object item = this.intervalLst.getSelectedItem();
            if (item instanceof IntervalUnit) {
                field.setIntervalOption(item.toString().toLowerCase());
            }
        }

        @Override
        void updatePanel() {
            IntervalUnit intervalUnit;
            String option;
            InputField field = this.getField();
            Object defaultValue = field.getDefaultValue();
            if (defaultValue != null) {
                Interval interval = defaultValue instanceof Interval ? (Interval)defaultValue : Interval.valueOf(defaultValue.toString());
                this.intervalField.setInterval(interval);
                this.defaultValueChk.setSelected(true);
                this.intervalField.setEnabled(true);
                this.intervalLst.setEnabled(true);
            }
            if ((option = field.getIntervalOption()) != null && (intervalUnit = IntervalUnit.valueOf(option.toUpperCase())) != null) {
                this.intervalLst.setSelectedItem((Object)intervalUnit);
            }
        }

        @Override
        boolean validateChanges() {
            return true;
        }

        private void processEvent(UiEvent e) {
            UiComponent source = e.getSource();
            if (source == this.defaultValueChk) {
                boolean selected = this.defaultValueChk.isSelected();
                this.intervalField.setEnabled(selected);
                this.intervalLst.setEnabled(selected);
            }
        }

        private UiComponent buildOptionsPanel(UiContainer parent) {
            ArrayList<IntervalUnit> newValues = new ArrayList<IntervalUnit>(Arrays.asList(IntervalUnit.values()));
            newValues.add(0, (IntervalUnit)((Object)DesignerMsg.NONE));
            BorderPanel panel = new BorderPanel(parent);
            this.intervalLst = UiFactory.createMutableComboBox((UiContainer)panel, newValues);
            this.intervalLst.setEnabled(false);
            this.intervalLst.addItemListener((ItemListener)this);
            FormLayout layout = new FormLayout("5dlu, pref, 5dlu, pref:grow, 5dlu", "5dlu, pref, 5dlu");
            PanelBuilder builder = layout.createBuilder((Panel)panel);
            CellConstraints cc = layout.createCellConstraints();
            builder.add((UiComponent)Label.create((UiContainer)panel, (Msg)LibMsg.OPTIONS), cc.xy(2, 2));
            builder.add((UiComponent)this.intervalLst, cc.xy(4, 2));
            return panel;
        }

        private UiComponent buildValuePanel(UiContainer parent) {
            BorderPanel panel = new BorderPanel(parent);
            this.intervalField = new IntervalField((UiContainer)panel);
            this.intervalField.setEnabled(false);
            FormLayout layout = new FormLayout("5dlu, pref, 5dlu, pref:grow, 5dlu", "5dlu, pref, 5dlu");
            PanelBuilder builder = layout.createBuilder((Panel)panel);
            CellConstraints cc = layout.createCellConstraints();
            this.defaultValueChk = CheckBox.create((UiContainer)panel, (Msg)ProjectMsg.DEFAULT_VALUE);
            this.defaultValueChk.addActionListener((ActionListener)this);
            builder.add((UiComponent)this.defaultValueChk, cc.xy(2, 2));
            builder.add((UiComponent)this.intervalField, cc.xy(4, 2));
            return panel;
        }
    }

    private static class BoolPanel
    extends BasePanel
    implements ActionListener {
        private ComboBox booleanLst;
        private CheckBox defaultValueChk;

        public BoolPanel(UiContainer parent, InputField field) {
            super(parent, field);
            this.add(this.buildDefaultPanel((UiContainer)this), "North");
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.defaultValueChk) {
                this.booleanLst.setEnabled(this.defaultValueChk.isSelected());
            }
        }

        @Override
        void applyChanges() {
            if (this.defaultValueChk.isSelected()) {
                this.getField().setDefaultValue(this.booleanLst.getSelectedItem());
            } else {
                this.getField().setDefaultValue(null);
            }
        }

        @Override
        void updatePanel() {
            InputField field = this.getField();
            Object defaultValue = field.getDefaultValue();
            if (defaultValue != null) {
                String s = String.valueOf(defaultValue);
                this.booleanLst.setSelectedItem((Object)Boolean.valueOf(s));
                this.defaultValueChk.setSelected(true);
                this.booleanLst.setEnabled(true);
            }
        }

        @Override
        boolean validateChanges() {
            return true;
        }

        private UiComponent buildDefaultPanel(UiContainer parent) {
            BorderPanel panel = new BorderPanel(parent);
            this.booleanLst = UiFactory.createBooleanComboBox((UiContainer)panel);
            this.booleanLst.setEnabled(false);
            FormLayout layout = new FormLayout("5dlu, pref, 5dlu, pref:grow, 5dlu", "5dlu, pref, 5dlu");
            PanelBuilder builder = layout.createBuilder((Panel)panel);
            CellConstraints cc = layout.createCellConstraints();
            this.defaultValueChk = CheckBox.create((UiContainer)panel, (Msg)ProjectMsg.DEFAULT_VALUE);
            this.defaultValueChk.addActionListener((ActionListener)this);
            builder.add((UiComponent)this.defaultValueChk, cc.xy(2, 2));
            builder.add((UiComponent)this.booleanLst, cc.xy(4, 2));
            return panel;
        }
    }

    private static abstract class NumberPanel<E extends Number>
    extends BasePanel
    implements ActionListener {
        private CheckBox defaultValueChk;
        private NumericField<E> numericField;

        private NumberPanel(UiContainer parent, InputField field) {
            super(parent, field);
            this.setLayout((Layout)new BorderLayout());
            this.add(this.buildDefaultPanel((UiContainer)this), "North");
        }

        public static final NumberPanel create(UiContainer parent, InputField field) {
            TypeDescription type = field.getTarget().getType();
            NumberPanel result = type.isInt() ? new NumberPanelInteger(parent, field) : new NumberPanelDecimal(parent, field);
            return result;
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.defaultValueChk) {
                boolean selected = this.defaultValueChk.isSelected();
                this.numericField.setEnabled(selected);
            }
        }

        protected abstract NumericField<E> createNumericField(UiContainer var1);

        protected abstract void setValue(String var1);

        protected NumericField<E> getNumericField() {
            return this.numericField;
        }

        @Override
        void applyChanges() {
            String value = this.defaultValueChk.isSelected() ? this.numericField.getValue().toString() : null;
            this.getField().setDefaultValue(value);
        }

        @Override
        void updatePanel() {
            InputField field = this.getField();
            Object defaultValue = field.getDefaultValue();
            if (defaultValue != null) {
                this.setValue((String)defaultValue);
                this.defaultValueChk.setSelected(true);
                this.numericField.setEnabled(true);
            }
        }

        private UiComponent buildDefaultPanel(UiContainer parent) {
            BorderPanel panel = new BorderPanel(parent);
            this.numericField = this.createNumericField((UiContainer)panel);
            this.numericField.setColumns(10);
            this.numericField.setEnabled(false);
            FormLayout layout = new FormLayout("5dlu, pref, 5dlu, pref:grow, 5dlu", "5dlu, pref, 5dlu");
            PanelBuilder builder = layout.createBuilder((Panel)panel);
            CellConstraints cc = layout.createCellConstraints();
            this.defaultValueChk = CheckBox.create((UiContainer)panel, (Msg)ProjectMsg.DEFAULT_VALUE);
            this.defaultValueChk.addActionListener((ActionListener)this);
            builder.add((UiComponent)this.defaultValueChk, cc.xy(2, 2));
            builder.add(this.numericField, cc.xy(4, 2));
            return panel;
        }

        private static class NumberPanelInteger
        extends NumberPanel<Integer> {
            public NumberPanelInteger(UiContainer parent, InputField field) {
                super(parent, field);
            }

            @Override
            protected NumericField<Integer> createNumericField(UiContainer parent) {
                return NumericField.createIntegerNumericField((UiContainer)parent);
            }

            @Override
            protected void setValue(String value) {
                this.getNumericField().setValue((Number)Integer.valueOf(value));
            }

            @Override
            boolean validateChanges() {
                String value = ((Integer)this.getNumericField().getValue()).toString();
                return this.parseInt(value);
            }

            private boolean parseInt(String value) {
                try {
                    Integer.parseInt(value);
                }
                catch (Exception e) {
                    MessageDialog.showError((Msg)DesignerMsg.INPUT_INVALID_INTEGER, (Throwable)e);
                    return false;
                }
                return true;
            }
        }

        private static class NumberPanelDecimal
        extends NumberPanel<Double> {
            public NumberPanelDecimal(UiContainer parent, InputField field) {
                super(parent, field);
            }

            @Override
            protected NumericField<Double> createNumericField(UiContainer parent) {
                return NumericField.createDoubleNumericField((UiContainer)parent);
            }

            @Override
            protected void setValue(String value) {
                this.getNumericField().setValue((Number)Double.valueOf(value));
            }

            @Override
            boolean validateChanges() {
                String value = ((Double)this.getNumericField().getValue()).toString();
                return this.parseDouble(value);
            }

            private boolean parseDouble(String value) {
                try {
                    Double.valueOf(value);
                }
                catch (Exception e) {
                    MessageDialog.showError((Msg)DesignerMsg.INPUT_INVALID_REAL, (Throwable)e);
                    return false;
                }
                return true;
            }
        }
    }

    private static abstract class BasePanel
    extends Panel {
        protected InputField field;

        public BasePanel(UiContainer parent, InputField field) {
            super(parent);
            this.setField(field);
            this.setLayout((Layout)new BorderLayout());
        }

        public InputField getField() {
            return this.field;
        }

        abstract void applyChanges();

        abstract void updatePanel();

        abstract boolean validateChanges();

        private void setField(InputField field) {
            this.field = field;
        }
    }
}

