/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.screenflow;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import oracle.bpm.collections.maps.LocaleStringMap;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.screenflow.Model;
import oracle.bpm.lang.IntervalUnit;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.lib.msg.LibMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.type.TypeFactory;
import oracle.bpm.type.TypeHolder;

public class InputField {
    private Object defaultValue;
    private String intervalOption;
    private LocaleStringMap localeStringMap;
    private final Model model;
    private boolean readonly;
    private boolean required;
    private List selectedValues;
    private TypeHolder target;
    private String timeOption;
    private Type type;
    private String valueProviderAttribute;
    private List values;
    private static List<Type> typeList;
    public static final Type NUMBER;
    public static final Type TEXT;
    public static final Type LONG_TEXT;
    public static final Type PASSWORD;
    public static final Type TIME;
    public static final Type INTERVAL;
    public static final Type BOOL;
    public static final Type OPTION;
    public static final Type OPTIONS;

    public InputField(Model model, LocaleStringMap name, TypeHolder target, Type type, boolean readonly, boolean required) {
        this.model = model;
        this.localeStringMap = name;
        this.target = target;
        this.type = type;
        this.readonly = readonly;
        this.required = required;
    }

    public static List<Type> getTypesAsList() {
        if (typeList == null) {
            typeList = new ArrayList<Type>();
            typeList.add(NUMBER);
            typeList.add(TEXT);
            typeList.add(LONG_TEXT);
            typeList.add(PASSWORD);
            typeList.add(TIME);
            typeList.add(INTERVAL);
            typeList.add(BOOL);
            typeList.add(OPTION);
            typeList.add(OPTIONS);
        }
        return typeList;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public String[] getFieldOptions() {
        String intervalOption;
        ArrayList<String> options = new ArrayList<String>();
        if (this.isRequired()) {
            options.add("required");
        } else if (this.isReadonly()) {
            options.add("readonly");
        }
        if (this.isText()) {
            String textOption = this.getTextOption();
            if (textOption != null) {
                options.add(textOption);
            }
        } else if (this.isTime()) {
            String timeOption = this.getTimeOption();
            if (timeOption != null) {
                options.add(timeOption);
            }
        } else if (this.isInterval() && (intervalOption = this.getIntervalOption()) != null) {
            options.add(intervalOption);
        }
        return options.toArray(new String[options.size()]);
    }

    public String getIntervalOption() {
        return this.intervalOption;
    }

    public LocaleStringMap getLocaleStringMap() {
        return this.localeStringMap;
    }

    public List getSelectedValues() {
        if (this.selectedValues == null) {
            this.selectedValues = new ArrayList();
        }
        return this.selectedValues;
    }

    public TypeHolder getTarget() {
        return this.target;
    }

    public String getTextOption() {
        Type type = this.getType();
        if (type == LONG_TEXT) {
            return "textarea";
        }
        if (type == PASSWORD) {
            return "password";
        }
        return null;
    }

    public String getTimeOption() {
        return this.timeOption;
    }

    public Type getType() {
        return this.type;
    }

    public String getValueProvider() {
        return this.valueProviderAttribute;
    }

    public List getValues() {
        if (this.values == null) {
            this.values = new ArrayList();
        }
        return this.values;
    }

    public boolean hasDefaultValue() {
        return this.getDefaultValue() != null;
    }

    public boolean hasSelectedValues() {
        List validValues = this.getSelectedValues();
        return validValues != null && !validValues.isEmpty();
    }

    public boolean hasValues() {
        List values = this.getValues();
        return values != null && !values.isEmpty();
    }

    public boolean isInterval() {
        Type type = this.getType();
        return type == INTERVAL;
    }

    public boolean isReadonly() {
        return this.readonly;
    }

    public boolean isRequired() {
        return this.required;
    }

    public boolean isText() {
        Type type = this.getType();
        return type == TEXT || type == LONG_TEXT || type == OPTION || type == PASSWORD;
    }

    public boolean isTime() {
        Type type = this.getType();
        return type == TIME;
    }

    public void parseOptions(String[] options) {
        HashSet<String> values = new HashSet<String>();
        for (String option : options) {
            values.add(option);
        }
        if (values.contains("required")) {
            this.setRequired(true);
        }
        if (values.contains("readonly")) {
            this.setReadonly(true);
        }
        if (this.isInterval()) {
            IntervalUnit[] intervals;
            for (IntervalUnit interval : intervals = IntervalUnit.values()) {
                String unitName = interval.toString().toLowerCase();
                if (!values.contains(unitName)) continue;
                this.setIntervalOption(unitName);
                break;
            }
        }
        if (this.isTime()) {
            if (values.contains("date")) {
                this.setTimeOption("date");
            } else if (values.contains("time")) {
                this.setTimeOption("time");
            }
        }
    }

    public void resetValues() {
        this.setDefaultValue(null);
        this.getSelectedValues().clear();
        this.getValues().clear();
        this.setValueProvider(null);
    }

    public void setDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void setIntervalOption(String intervalOption) {
        this.intervalOption = intervalOption;
    }

    public void setLocaleStringMap(LocaleStringMap localeStringMap) {
        this.localeStringMap = localeStringMap;
    }

    public void setReadonly(boolean readonly) {
        this.readonly = readonly;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public void setSelectedValues(List selectedValues) {
        this.selectedValues = selectedValues;
    }

    public void setTarget(TypeHolder target) {
        this.target = target;
    }

    public void setTimeOption(String timeOption) {
        this.timeOption = timeOption;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public void setValueProvider(String valueProviderAttribute) {
        this.valueProviderAttribute = valueProviderAttribute;
    }

    public void setValues(List values) {
        this.values = values;
    }

    public void setLabel(String label) {
        this.localeStringMap.setString(label);
    }

    public Model getModel() {
        return this.model;
    }

    public void validate(StringBuffer errors, Map<String, String> assignsMap) {
        String defaultLabel = this.getLocaleStringMap().getString();
        for (String message : this.getLocaleStringMap().values()) {
            if (message != null && !"".equals(message.trim())) continue;
            errors.append("\n").append(DesignerMsg.INPUT_FIELD_INVALID_LABEL(String.valueOf(this.getFieldIndex())));
        }
        if (this.getTarget() == null) {
            errors.append("\n").append(DesignerMsg.INPUT_FIELD_INVALID_TARGET(defaultLabel).getString());
        } else {
            String targetName = this.getTarget().getName();
            if (assignsMap.containsKey(targetName)) {
                String previousLabel = assignsMap.get(targetName);
                errors.append("\n").append(DesignerMsg.INPUT_FIELD_EXISTING_ASSIGN(defaultLabel, previousLabel).getString());
            } else {
                assignsMap.put(targetName, defaultLabel);
            }
        }
    }

    private int getFieldIndex() {
        return this.model.indexOf(this);
    }

    static {
        NUMBER = new Type(0, DesignerMsg.INPUT_FIELD_NUMBER);
        TEXT = new Type(1, DesignerMsg.INPUT_FIELD_TEXT);
        LONG_TEXT = new Type(2, DesignerMsg.INPUT_FIELD_LONG_TEXT);
        PASSWORD = new Type(3, LibMsg.PASSWORD);
        TIME = new Type(4, LibMsg.TIME);
        INTERVAL = new Type(5, DesignerMsg.INPUT_FIELD_INTERVAL);
        BOOL = new Type(6, DesignerMsg.INPUT_FIELD_BOOLEAN);
        OPTION = new Type(7, DesignerMsg.INPUT_FIELD_CHOICE);
        OPTIONS = new Type(8, DesignerMsg.INPUT_FIELD_SELECTIONS);
    }

    public static class Type {
        private int id;
        private Msg msg;

        public Type(int id, Msg msg) {
            this.id = id;
            this.msg = msg;
        }

        public static Type getDefault(TypeDescription type) {
            Type result = type.equivalent(TypeFactory.getString()) ? TEXT : (type.equivalent(TypeFactory.getArray(TypeFactory.getString())) ? OPTIONS : (type.equivalent(TypeFactory.getTime()) ? TIME : (type.equivalent(TypeFactory.getInterval()) ? INTERVAL : (type.equivalent(TypeFactory.getBool()) ? BOOL : (type.equivalent(TypeFactory.getInt()) ? NUMBER : (type.equivalent(TypeFactory.getReal()) ? NUMBER : (type.equivalent(TypeFactory.getDecimal()) ? NUMBER : (type.isEnum() ? OPTION : TEXT))))))));
            return result;
        }

        public int getId() {
            return this.id;
        }

        public Msg getMsg() {
            return this.msg;
        }

        public String toString() {
            return this.getMsg().toString();
        }
    }
}

