/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.screenflow;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.AbstractButton;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.ButtonGroup;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.ToggleButton;
import oracle.bpm.ui.ToolBar;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.event.ActionListener;
import oracle.bpm.ui.layout.BoxLayout;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.msg.UIMsg;

public class ButtonEditor
extends Panel {
    private Button addButtonBtn;
    private ButtonGroup buttonGroup;
    private List<ToggleButton> buttons;
    private ToolBar buttonsToolBar;
    private Button delButtonBtn;
    private Button editButtonBtn;
    private int minimumRequiredButtons;
    private ToggleButton selectedButton;
    private ActionListener toggleSelectionListener;

    public ButtonEditor(UiContainer parent) {
        this(parent, 0);
    }

    public ButtonEditor(UiContainer parent, int minimumRequiredButtons) {
        super(parent, UIMsg.TO_MSG((String)""));
        this.setLayout((Layout)new BoxLayout((UiContainer)this, 0));
        this.minimumRequiredButtons = minimumRequiredButtons;
        this.buttons = new ArrayList<ToggleButton>();
        this.add((UiComponent)this.buildEditToolBar());
        this.buttonsToolBar = new ToolBar((UiContainer)this);
        this.buttonGroup = new ButtonGroup();
        this.addDefaultButtons();
        this.add((UiComponent)this.buttonsToolBar);
    }

    public String[] getEditedButtonNames() {
        String[] names = new String[this.buttons.size()];
        for (int i = 0; i < this.buttons.size(); ++i) {
            names[i] = this.buttons.get(i).getText();
        }
        return names;
    }

    public ToggleButton getFirstButton() {
        return this.buttons.size() > 0 ? this.buttons.get(0) : null;
    }

    public void setMinimumRequiredButtons(int minimum) {
        this.minimumRequiredButtons = minimum;
    }

    public void addTaskButtons(String[] buttonsToAdd) {
        this.removeAllButtons();
        for (String btnName : buttonsToAdd) {
            this.addToggleButton(btnName);
        }
        if (this.buttons.size() == 0) {
            this.addDefaultButtons();
        }
    }

    public ToggleButton getSelectedButton() {
        return this.selectedButton;
    }

    protected void addDefaultButtons() {
    }

    protected void addToggleButton(String name) {
        int size = this.buttons.size();
        for (int i = 0; i < size; ++i) {
            ToggleButton toggleButton = this.buttons.get(i);
            String actionCommand = toggleButton.getText();
            if (actionCommand == null || !actionCommand.equals(name)) continue;
            return;
        }
        ToggleButton toggleButton = new ToggleButton((UiContainer)this.buttonsToolBar, name);
        toggleButton.setActionCommand(name);
        this.buttonsToolBar.add((UiComponent)toggleButton);
        this.buttonsToolBar.revalidate();
        this.buttonsToolBar.getParent().revalidate();
        if (this.toggleSelectionListener == null) {
            this.toggleSelectionListener = new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ButtonEditor.this.setSelectedButton((ToggleButton)e.getSource());
                    ButtonEditor.this.checkButtonToolBar();
                }
            };
        }
        toggleButton.addActionListener(this.toggleSelectionListener);
        this.buttons.add(toggleButton);
        this.buttonGroup.add((AbstractButton)toggleButton);
        this.setSelectedButton(toggleButton);
        this.doOnAdd(toggleButton);
    }

    protected void doOnAdd(ToggleButton addedButton) {
    }

    protected void doOnDelete(ToggleButton removedButton) {
    }

    protected void doOnEdit(String oldButtonName, String editedButtonName) {
    }

    protected void removeAllButtons() {
        this.buttons.clear();
        this.buttonsToolBar.removeAll();
        this.removeGroupButtons();
    }

    private void setSelectedButton(ToggleButton toggleButton) {
        this.selectedButton = toggleButton;
        if (this.selectedButton != null) {
            this.selectedButton.setSelected(true);
        }
        this.checkButtonToolBar();
    }

    private void addNewButton() {
        String buttonName = this.requestNewName();
        if (buttonName != null) {
            this.addToggleButton(buttonName);
        }
    }

    private boolean btnNameExists(String name) {
        if (name.trim().equals("")) {
            return true;
        }
        Enumeration elements = this.buttonGroup.getElements();
        while (elements.hasMoreElements()) {
            AbstractButton button = (AbstractButton)elements.nextElement();
            if (!button.getText().equals(name)) continue;
            return true;
        }
        return false;
    }

    private ToolBar buildEditToolBar() {
        ToolBar editToolBar = new ToolBar((UiContainer)this);
        this.addButtonBtn = new Button((UiContainer)editToolBar, UIMsg.ADD, 2);
        this.addButtonBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ButtonEditor.this.addNewButton();
            }
        });
        this.delButtonBtn = new Button((UiContainer)editToolBar, UIMsg.REMOVE, 2);
        this.delButtonBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ButtonEditor.this.deleteButton();
            }
        });
        if (this.getSelectedButton() == null) {
            this.delButtonBtn.setEnabled(false);
        }
        this.editButtonBtn = new Button((UiContainer)editToolBar, DesignerMsg.EDIT, 2);
        this.editButtonBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ButtonEditor.this.editButtonName();
            }
        });
        this.editButtonBtn.setEnabled(false);
        editToolBar.setAllSizes((UiComponent)this.addButtonBtn);
        editToolBar.setAllSizes((UiComponent)this.delButtonBtn);
        editToolBar.setAllSizes((UiComponent)this.editButtonBtn);
        editToolBar.add((UiComponent)this.addButtonBtn);
        editToolBar.add((UiComponent)this.delButtonBtn);
        editToolBar.add((UiComponent)this.editButtonBtn);
        return editToolBar;
    }

    private void checkButtonToolBar() {
        if (!this.editButtonBtn.isEnabled()) {
            this.editButtonBtn.setEnabled(true);
        }
        this.delButtonBtn.setEnabled(this.buttons.size() > this.minimumRequiredButtons);
    }

    private void deleteButton() {
        ToggleButton selectedButton = this.getSelectedButton();
        int previousButton = this.buttons.indexOf(selectedButton) - 1;
        if (selectedButton != null && this.buttons.size() > this.minimumRequiredButtons) {
            this.doOnDelete(selectedButton);
            this.buttonGroup.remove((AbstractButton)selectedButton);
            this.buttonsToolBar.remove((UiComponent)selectedButton);
            this.buttons.remove(selectedButton);
            this.buttonsToolBar.revalidate();
            this.buttonsToolBar.repaint();
            if (previousButton < this.buttons.size() && previousButton >= 0) {
                this.setSelectedButton(this.buttons.get(previousButton));
            } else {
                this.delButtonBtn.setEnabled(false);
                this.editButtonBtn.setEnabled(false);
            }
        }
    }

    private void editButtonName() {
        String newName;
        if (this.getSelectedButton() != null && (newName = this.requestNewName(this.getSelectedButton().getText())) != null) {
            String oldName = this.getSelectedButton().getText();
            this.getSelectedButton().setText(newName);
            this.doOnEdit(oldName, newName);
        }
    }

    private void removeGroupButtons() {
        AbstractButton[] buttons = new AbstractButton[this.buttonGroup.getButtonCount()];
        int i = 0;
        Enumeration elements = this.buttonGroup.getElements();
        while (elements.hasMoreElements()) {
            buttons[i++] = (AbstractButton)elements.nextElement();
        }
        for (i = 0; i < buttons.length; ++i) {
            this.buttonGroup.remove(buttons[i]);
        }
    }

    private String requestNewName() {
        return this.requestNewName("");
    }

    private String requestNewName(String initialValue) {
        String inputValue = MessageDialog.showInputDialog((UiWindow)this.getOwnerWindow(), (Msg)DesignerMsg.ENTER_NEW_BUTTON_NAME, (Msg)UIMsg.TO_MSG((String)(DesignerMsg.ENTER_NEW_BUTTON_NAME.getString() + ": ")), null, (String)initialValue, (boolean)true);
        if (inputValue != null && !inputValue.equals(initialValue) || "".equals(inputValue)) {
            while (inputValue != null && this.btnNameExists(inputValue) || "".equals(inputValue)) {
                inputValue = MessageDialog.showInput((UiWindow)this.getOwnerWindow(), (Msg)DesignerMsg.ENTER_NEW_BUTTON_NAME, (Msg)UIMsg.TO_MSG((String)(DesignerMsg.ENTER_NEW_BUTTON_NAME.getString() + ": ")));
            }
        }
        return inputValue;
    }
}

