/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.renderers;

import java.util.ArrayList;
import javax.swing.Icon;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.renderers.DataDeclarationRenderer;
import oracle.bpm.extensionpoint.metadata.ProjectObjectRendererMetadata;
import oracle.bpm.project.model.ProjectDataObject;
import oracle.bpm.project.model.catalog.DataDeclaration;
import oracle.bpm.project.model.processes.DataObject;
import oracle.bpm.project.view.project.view.renderer.DefaultProjectObjectRenderer;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.ComposedIcon;
import oracle.bpm.ui.Image;

@ProjectObjectRendererMetadata(objectClass=DataObject.class)
public class DataObjectRenderer
extends DefaultProjectObjectRenderer<DataObject> {
    public Image getIcon(DataObject dataObject) {
        ProjectDataObject pdo;
        Image result = new DataDeclarationRenderer().getIcon((DataDeclaration)dataObject);
        if (dataObject instanceof ProjectDataObject && (pdo = (ProjectDataObject)dataObject).isBusiness()) {
            ArrayList<Image> list = new ArrayList<Image>();
            list.add(result);
            list.add(Image.create((Msg)DesignerMsg.BUSINESS_INDICATOR_FILTER));
            ComposedIcon c = new ComposedIcon(list);
            result = Image.create((Icon)c);
        }
        return result;
    }

    public String getLabel(DataObject dataObject) {
        if (dataObject instanceof ProjectDataObject) {
            ProjectDataObject projectDataObject = (ProjectDataObject)dataObject;
            return projectDataObject.isBusiness() ? projectDataObject.getDefaultLabel() + "[" + projectDataObject.getBusinessVariableType().getString() + "]" : projectDataObject.getDefaultLabel();
        }
        return dataObject.getDefaultLabel();
    }
}

