/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.renderers;

import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.utils.IconFactory;
import oracle.bpm.extensionpoint.metadata.ProjectObjectRendererMetadata;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.catalog.DataDeclaration;
import oracle.bpm.project.view.project.view.renderer.DefaultProjectObjectRenderer;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Image;

@ProjectObjectRendererMetadata(objectClass=DataDeclaration.class)
public class DataDeclarationRenderer
extends DefaultProjectObjectRenderer<DataDeclaration> {
    public String getLabel(DataDeclaration dataDeclaration) {
        String result = dataDeclaration.getName();
        if (dataDeclaration.getType().isArray()) {
            result = result + "[]";
        }
        return result;
    }

    public Image getIcon(DataDeclaration dataDeclaration) {
        Image resultImage;
        Msg resultMsg = null;
        if (!dataDeclaration.getDeclarations().isEmpty()) {
            resultMsg = DesignerMsg.DATATYPE_COMPOSITE;
        } else {
            CatalogType type = dataDeclaration.getType();
            if (type != null) {
                resultMsg = type.isInt() ? DesignerMsg.DATATYPE_INTEGER : (type.isString() ? DesignerMsg.DATATYPE_STRING : (type.isTime() ? DesignerMsg.DATATYPE_DATETIME : (type.isDecimal() || type.isReal() ? DesignerMsg.DATATYPE_DECIMAL : (type.isBoolean() ? DesignerMsg.DATATYPE_BOOLEAN : (type.isCollection() ? DesignerMsg.DATATYPE_COLLECTION : (type.isBinary() ? DesignerMsg.DATATYPE_BINARY : DesignerMsg.DATATYPE_OTHER))))));
            }
        }
        Image image = resultImage = resultMsg != null ? Image.create((Msg)resultMsg) : null;
        if (resultImage != null && dataDeclaration.isReadOnly()) {
            resultImage = IconFactory.createReadOnly(resultImage);
        }
        return resultImage;
    }
}

