/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.project.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import oracle.bpm.draw.Color;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectRepository;
import oracle.bpm.ui.ColorProvider;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.UiContainer;

public class ProjectCombo
extends ComboBox<Project> {
    private ProjectRepository repository;

    public ProjectCombo(UiContainer parent, ProjectRepository repository, Project ... excludedProjects) {
        super(parent, false);
        this.repository = repository;
        this.init(excludedProjects);
    }

    private void init(Project ... excludedProjects) {
        Collection allProjects = this.repository.getAllProjects();
        ArrayList projects = new ArrayList(allProjects);
        Collections.sort(projects, new Comparator<Project>(){

            @Override
            public int compare(Project p1, Project p2) {
                return p1.getId().compareToIgnoreCase(p2.getId());
            }
        });
        Set<Project> excludedSet = this.createFilter(excludedProjects);
        for (Project project : projects) {
            if (excludedSet.contains(project)) continue;
            this.addItem(project);
        }
        this.setLabelProvider((LabelProvider)ProjectLabelProvider.INSTANCE);
        this.setColorProvider((ColorProvider)ProjectColorProvider.INSTANCE);
    }

    private Set<Project> createFilter(Project ... projects) {
        HashSet<Project> result = new HashSet<Project>();
        for (Project project : projects) {
            result.add(project);
        }
        return result;
    }

    private static class ProjectLabelProvider
    extends LabelProvider.Default<Project> {
        public static ProjectLabelProvider INSTANCE = new ProjectLabelProvider();

        private ProjectLabelProvider() {
        }

        public String getText(Project project) {
            return project != null ? project.getId() : "";
        }
    }

    private static class ProjectColorProvider
    extends ColorProvider.Default<Project> {
        public static ProjectColorProvider INSTANCE = new ProjectColorProvider();

        private ProjectColorProvider() {
        }

        public Color getForeground(Project project) {
            return project != null && project.isOpen() ? null : Color.GRAY;
        }
    }
}

