/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.project.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.util.ModelUtils;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.UiContainer;

public class ModelCombo
extends ComboBox<Process> {
    private Project project;
    private int types;
    public static int INCLUDE_INTERFACE = 2;
    public static int INCLUDE_NON_INTERFACE = 4;
    public static int ALL = INCLUDE_INTERFACE | INCLUDE_NON_INTERFACE;

    public ModelCombo(UiContainer parent, Project project) {
        super(parent, false);
        this.project = project;
        this.setTypes(ALL);
        this.init();
    }

    public void setTypes(int types) {
        boolean changed = types != this.types;
        this.types = types;
        if (changed) {
            this.populate();
        }
    }

    private void init() {
        this.setLabelProvider((LabelProvider)new ModelComboLabelProvider());
        this.populate();
    }

    private void populate() {
        ArrayList<Process> newModelList = new ArrayList<Process>();
        Collection models = this.project.getProcesses();
        for (Process model : models) {
            boolean add = false;
            newModelList.add(model);
        }
        this.setModelList(newModelList);
    }

    private boolean allowsInterfaces() {
        return (this.types & INCLUDE_INTERFACE) != 0;
    }

    private boolean allowsNonInterfaces() {
        return (this.types & INCLUDE_NON_INTERFACE) != 0;
    }

    private boolean allowsAll() {
        return this.allowsInterfaces() && this.allowsNonInterfaces();
    }

    private class ModelComboLabelProvider
    extends LabelProvider.Default<Process> {
        private Map<Process, String> modelTitles = new HashMap<Process, String>();

        private ModelComboLabelProvider() {
        }

        public String getText(Process element) {
            String title = this.modelTitles.get(element);
            if (title == null) {
                title = ModelUtils.getModelTitle((Process)element);
                this.modelTitles.put(element, title);
            }
            return title;
        }
    }
}

