/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.processdesigner.states;

import oracle.bpm.command.Command;
import oracle.bpm.designer.ActionRunner;
import oracle.bpm.designer.action.RemoveObjectsAction;
import oracle.bpm.designer.capability.CapabilityEvent;
import oracle.bpm.designer.capability.CapabilityHelper;
import oracle.bpm.designer.capability.CapabilityType;
import oracle.bpm.designer.capability.SpecifiedResult;
import oracle.bpm.designer.controller.Controller;
import oracle.bpm.designer.processdesigner.states.AbstractDesignerState;
import oracle.bpm.designer.selection.SelectionUtils;
import oracle.bpm.geom.Point;
import oracle.bpm.project.ui.ModelObjectSelection;
import oracle.bpm.ui.MouseEventUtilities;
import oracle.bpm.ui.event.MouseEvent;
import oracle.bpm.ui.selection.Selection;
import org.jetbrains.annotations.NotNull;

public class PointerState
extends AbstractDesignerState {
    private SpecifiedResult dragging;
    private SpecifiedResult targeting;

    @Override
    public void mousePressed(@NotNull MouseEvent mouse, @NotNull Point unscaled) {
        Controller<?> controller;
        SpecifiedResult result;
        if (MouseEventUtilities.isPopupTrigger((MouseEvent)mouse) && (result = CapabilityHelper.specify(controller = this.findAnyController(unscaled), CapabilityType.POP_UP)) != null) {
            CapabilityEvent event = CapabilityEvent.create(result, unscaled, mouse);
            this.processCommand(result, event);
        }
    }

    @Override
    public void mouseDragged(@NotNull MouseEvent mouse, @NotNull Point unscaled) {
        if (this.dragging == null) {
            this.startDrag(mouse, unscaled);
        }
        if (this.dragging != null) {
            this.drag(mouse, unscaled);
        }
    }

    @Override
    public void mouseRealeased(@NotNull MouseEvent mouse, @NotNull Point unscaled) {
        if (this.dragging == null) {
            Controller<?> controller = this.findAnyController(unscaled);
            SpecifiedResult result = CapabilityHelper.specify(controller, CapabilityType.SELECTION);
            if (result != null) {
                CapabilityEvent event = CapabilityEvent.create(result, unscaled, mouse);
                this.processCommand(result, event);
            }
        } else {
            this.stopDrag(mouse, unscaled);
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouse, int x, int y, Point unscaled) {
        Controller<?> controller = this.findAnyController(unscaled);
        SpecifiedResult result = CapabilityHelper.specify(controller, CapabilityType.FOCUS);
        if (result != null) {
            CapabilityEvent event = CapabilityEvent.create(result, unscaled, mouse);
            this.processCommand(result, event);
        }
    }

    @Override
    public void mouseDoubleClicked(MouseEvent event, Point unscaled) {
        Controller<?> controller = this.findAnyController(unscaled);
        this.edit(controller, CapabilityType.EDIT);
    }

    @Override
    public void enteredPressed() {
        Selection selection = this.getDomain().getSelectionProvider().getSelection();
        if (!selection.isEmpty()) {
            this.edit((Controller)selection.as(Controller.class), CapabilityType.EDIT);
        }
    }

    @Override
    public void deletePressed() {
        ModelObjectSelection selection = SelectionUtils.asModelObjectSelection(this.getSelection());
        if (!selection.isEmpty()) {
            RemoveObjectsAction objectsAction = new RemoveObjectsAction();
            objectsAction.runWithSelection((Selection)selection);
            this.getDomain().getSelectionProvider().clear();
        }
    }

    @Override
    public void cancel() {
        CapabilityEvent event;
        if (this.dragging != null) {
            event = CapabilityEvent.create(this.dragging, Point.ORIGIN);
            this.dragging.getCapability().cancelAnyVisuals(event);
            this.dragging = null;
        }
        if (this.targeting != null) {
            event = CapabilityEvent.create(this.targeting, Point.ORIGIN);
            this.targeting.getCapability().cancelAnyVisuals(event);
            this.targeting = null;
        }
        super.cancel();
    }

    private void startDrag(@NotNull MouseEvent mouse, @NotNull Point unscaled) {
        Controller<?> controller = this.findAnyController(unscaled);
        SpecifiedResult result = CapabilityHelper.specify(controller, CapabilityType.DRAG);
        if (result != null) {
            this.dragging = result;
            CapabilityEvent event = CapabilityEvent.create(this.dragging, unscaled, mouse);
            this.dragging.getCapability().showSourceVisuals(event);
        }
    }

    private void drag(@NotNull MouseEvent mouse, @NotNull Point unscaled) {
        CapabilityEvent event = CapabilityEvent.create(this.dragging, unscaled, mouse);
        event.setTarget(this.findAnyController(unscaled));
        this.dragging.getCapability().showSourceVisuals(event);
        if (event.getTarget() != null && !this.dragging.getOwner().equals(event.getTarget())) {
            SpecifiedResult result = CapabilityHelper.specify(event.getTarget(), this.dragging.getSpecified());
            if (result != null) {
                if (this.targeting == null) {
                    this.targeting = result;
                } else if (!this.targeting.equals(result)) {
                    this.targeting.getCapability().eraseTargetVisuals(event);
                    this.targeting = result;
                }
                this.targeting.getCapability().showTargetVisuals(event);
            }
        } else if (this.targeting != null) {
            this.targeting.getCapability().eraseTargetVisuals(event);
            this.targeting = null;
        }
    }

    private void stopDrag(@NotNull MouseEvent mouse, @NotNull Point unscaled) {
        CapabilityEvent event = CapabilityEvent.create(this.dragging, unscaled, mouse);
        if (this.targeting != null) {
            event.setTarget(this.targeting.getOwner());
            this.targeting.getCapability().eraseTargetVisuals(event);
            this.targeting = null;
        }
        this.dragging.getCapability().eraseSourceVisuals(event);
        this.processCommand(this.dragging, event);
        this.dragging = null;
        this.getDomain().getCanvas().repaint();
    }

    private void edit(@NotNull Controller controller, @NotNull CapabilityType type) {
        SpecifiedResult result = CapabilityHelper.specify(controller, type);
        if (result != null) {
            CapabilityEvent event = CapabilityEvent.create(result, Point.ORIGIN);
            this.processCommand(result, event);
        }
    }

    private void processCommand(@NotNull SpecifiedResult result, @NotNull CapabilityEvent event) {
        Command command = result.getCapability().process(event);
        if (command != null) {
            ActionRunner.getInstance().run(command);
            result.getCapability().consolidate(event);
        }
    }

    private Selection getSelection() {
        return this.getSelectionProvider().getSelection();
    }
}

